/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.component;

import java.util.Collections;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.component.ComponentConfig;
import org.modeshape.common.component.MockComponentA;

public class ComponentConfigTest {
    private ComponentConfig configA;
    private ComponentConfig configB;
    private ComponentConfig configA2;
    private String validName;
    private String validDescription;
    private String validClassname;
    private String[] validClasspath;

    @Before
    public void beforeEach() {
        this.validName = "valid configuration name";
        this.validDescription = "a Component";
        this.validClassname = "org.modeshape.acme.GenericComponent";
        this.validClasspath = new String[]{"com.acme:configA:1.0,com.acme:configB:1.0"};
        this.configA = new ComponentConfig("configA", this.validDescription, "org.modeshape.acme.GenericComponent", this.validClasspath);
        this.configB = new ComponentConfig("configB", this.validDescription, "org.modeshape.acme.GenericComponentB", this.validClasspath);
        this.configA2 = new ComponentConfig("conFigA", this.validDescription, "org.modeshape.acme.GenericComponent", this.validClasspath);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowNullNameInConstructor() {
        new ComponentConfig(null, this.validDescription, this.validClassname, this.validClasspath);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowEmptyNameInConstructor() {
        new ComponentConfig("", this.validDescription, this.validClassname, this.validClasspath);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowBlankNameInConstructor() {
        new ComponentConfig("   \t", this.validDescription, this.validClassname, this.validClasspath);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowNullClassNameInConstructor() {
        new ComponentConfig(this.validName, this.validDescription, null, this.validClasspath);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowEmptyClassNameInConstructor() {
        new ComponentConfig(this.validName, this.validDescription, "", this.validClasspath);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowBlankClassNameInConstructor() {
        new ComponentConfig(this.validName, this.validDescription, "   \t", this.validClasspath);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowInvalidClassNameInConstructor() {
        new ComponentConfig(this.validName, this.validDescription, "12.this is not a valid classname", this.validClasspath);
    }

    @Test
    public void shouldConsiderSameIfNamesAreEqualIgnoringCase() {
        Assert.assertThat((Object)this.configA.equals((Object)this.configA2), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldConsiderNotSameIfNamesAreNotEqualIgnoringCase() {
        Assert.assertThat((Object)this.configA.equals((Object)this.configB), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldSetClasspathWithValidMavenIds() {
        Assert.assertThat((Object)this.configA.getComponentClasspath().size(), (Matcher)Is.is((Object)this.validClasspath.length));
        Assert.assertThat((Object)this.configA.getComponentClasspathArray(), (Matcher)Is.is((Object)this.validClasspath));
    }

    @Test
    public void shouldGetNonNullComponentClasspathWhenEmpty() {
        this.configA = new ComponentConfig("configA", this.validDescription, this.validClassname, (String[])null);
        Assert.assertThat((Object)this.configA.getComponentClasspath().size(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.configA.getComponentClasspathArray().length, (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldSetValidProperty() {
        this.configA = new ComponentConfig("configA", this.validDescription, System.currentTimeMillis(), Collections.singletonMap("name", "test name"), MockComponentA.class.getName(), (String[])null);
        Assert.assertThat((Object)this.configA.getComponentClasspath().size(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.configA.getComponentClasspathArray().length, (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.configA.getProperties().size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.configA.getProperties().get("name").toString(), (Matcher)Is.is((Object)"test name"));
    }
}

