/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.util.Reflection;
import org.modeshape.common.util.StringUtil;

public class ReflectionTest {
    private String string;
    private List<String> stringList;
    private Reflection stringReflection;
    private Reflection stringListReflection;

    @Before
    public void setUp() {
        this.string = "This is string #";
        this.stringList = new ArrayList<String>();
        for (int i = 0; i != 10; ++i) {
            this.stringList.add(this.string + (i + 1));
        }
        this.stringReflection = new Reflection(String.class);
        this.stringListReflection = new Reflection(List.class);
    }

    @Test
    public void shouldGetClassNameForClass() {
        Assert.assertThat((Object)Reflection.getClassName(String.class), (Matcher)Is.is((Object)String.class.getName()));
        Assert.assertThat((Object)Reflection.getClassName(ArrayList.class), (Matcher)Is.is((Object)ArrayList.class.getName()));
        Assert.assertThat((Object)Reflection.getClassName(StringUtil.class), (Matcher)Is.is((Object)StringUtil.class.getName()));
    }

    @Test
    public void shouldGetClassNameOfInterface() {
        Assert.assertThat((Object)Reflection.getClassName(CharSequence.class), (Matcher)Is.is((Object)CharSequence.class.getName()));
        Assert.assertThat((Object)Reflection.getClassName(List.class), (Matcher)Is.is((Object)List.class.getName()));
    }

    @Test
    public void shouldGetClassNameWithPrimitive() {
        Assert.assertThat((Object)Reflection.getClassName(Integer.TYPE), (Matcher)Is.is((Object)"int"));
        Assert.assertThat((Object)Reflection.getClassName(Boolean.TYPE), (Matcher)Is.is((Object)"boolean"));
        Assert.assertThat((Object)Reflection.getClassName(Long.TYPE), (Matcher)Is.is((Object)"long"));
        Assert.assertThat((Object)Reflection.getClassName(Short.TYPE), (Matcher)Is.is((Object)"short"));
        Assert.assertThat((Object)Reflection.getClassName(Float.TYPE), (Matcher)Is.is((Object)"float"));
        Assert.assertThat((Object)Reflection.getClassName(Double.TYPE), (Matcher)Is.is((Object)"double"));
        Assert.assertThat((Object)Reflection.getClassName(Character.TYPE), (Matcher)Is.is((Object)"char"));
        Assert.assertThat((Object)Reflection.getClassName(Byte.TYPE), (Matcher)Is.is((Object)"byte"));
        Assert.assertThat((Object)Reflection.getClassName(Void.TYPE), (Matcher)Is.is((Object)"void"));
    }

    @Test
    public void shouldGetClassNameWith1DPrimitiveArray() {
        Assert.assertThat((Object)Reflection.getClassName(new int[0].getClass()), (Matcher)Is.is((Object)"int[]"));
        Assert.assertThat((Object)Reflection.getClassName(new boolean[0].getClass()), (Matcher)Is.is((Object)"boolean[]"));
        Assert.assertThat((Object)Reflection.getClassName(new long[0].getClass()), (Matcher)Is.is((Object)"long[]"));
        Assert.assertThat((Object)Reflection.getClassName(new short[0].getClass()), (Matcher)Is.is((Object)"short[]"));
        Assert.assertThat((Object)Reflection.getClassName(new float[0].getClass()), (Matcher)Is.is((Object)"float[]"));
        Assert.assertThat((Object)Reflection.getClassName(new double[0].getClass()), (Matcher)Is.is((Object)"double[]"));
        Assert.assertThat((Object)Reflection.getClassName(new char[0].getClass()), (Matcher)Is.is((Object)"char[]"));
        Assert.assertThat((Object)Reflection.getClassName(new byte[0].getClass()), (Matcher)Is.is((Object)"byte[]"));
    }

    @Test
    public void shouldGetClassNameWith2DPrimitiveArray() {
        Assert.assertThat((Object)Reflection.getClassName(new int[0][0].getClass()), (Matcher)Is.is((Object)"int[][]"));
        Assert.assertThat((Object)Reflection.getClassName(new boolean[0][0].getClass()), (Matcher)Is.is((Object)"boolean[][]"));
        Assert.assertThat((Object)Reflection.getClassName(new long[0][0].getClass()), (Matcher)Is.is((Object)"long[][]"));
        Assert.assertThat((Object)Reflection.getClassName(new short[0][0].getClass()), (Matcher)Is.is((Object)"short[][]"));
        Assert.assertThat((Object)Reflection.getClassName(new float[0][0].getClass()), (Matcher)Is.is((Object)"float[][]"));
        Assert.assertThat((Object)Reflection.getClassName(new double[0][0].getClass()), (Matcher)Is.is((Object)"double[][]"));
        Assert.assertThat((Object)Reflection.getClassName(new char[0][0].getClass()), (Matcher)Is.is((Object)"char[][]"));
        Assert.assertThat((Object)Reflection.getClassName(new byte[0][0].getClass()), (Matcher)Is.is((Object)"byte[][]"));
    }

    @Test
    public void shouldGetClassNameWith3DPrimitiveArray() {
        Assert.assertThat((Object)Reflection.getClassName(new int[0][0][0].getClass()), (Matcher)Is.is((Object)"int[][][]"));
        Assert.assertThat((Object)Reflection.getClassName(new boolean[0][0][0].getClass()), (Matcher)Is.is((Object)"boolean[][][]"));
        Assert.assertThat((Object)Reflection.getClassName(new long[0][0][0].getClass()), (Matcher)Is.is((Object)"long[][][]"));
        Assert.assertThat((Object)Reflection.getClassName(new short[0][0][0].getClass()), (Matcher)Is.is((Object)"short[][][]"));
        Assert.assertThat((Object)Reflection.getClassName(new float[0][0][0].getClass()), (Matcher)Is.is((Object)"float[][][]"));
        Assert.assertThat((Object)Reflection.getClassName(new double[0][0][0].getClass()), (Matcher)Is.is((Object)"double[][][]"));
        Assert.assertThat((Object)Reflection.getClassName(new char[0][0][0].getClass()), (Matcher)Is.is((Object)"char[][][]"));
        Assert.assertThat((Object)Reflection.getClassName(new byte[0][0][0].getClass()), (Matcher)Is.is((Object)"byte[][][]"));
    }

    @Test
    public void shouldGetClassNameWith8DPrimitiveArray() {
        Assert.assertThat((Object)Reflection.getClassName(new int[0][0][0][0][0][0][0][0].getClass()), (Matcher)Is.is((Object)"int[][][][][][][][]"));
        Assert.assertThat((Object)Reflection.getClassName(new boolean[0][0][0][0][0][0][0][0].getClass()), (Matcher)Is.is((Object)"boolean[][][][][][][][]"));
        Assert.assertThat((Object)Reflection.getClassName(new long[0][0][0][0][0][0][0][0].getClass()), (Matcher)Is.is((Object)"long[][][][][][][][]"));
        Assert.assertThat((Object)Reflection.getClassName(new short[0][0][0][0][0][0][0][0].getClass()), (Matcher)Is.is((Object)"short[][][][][][][][]"));
        Assert.assertThat((Object)Reflection.getClassName(new float[0][0][0][0][0][0][0][0].getClass()), (Matcher)Is.is((Object)"float[][][][][][][][]"));
        Assert.assertThat((Object)Reflection.getClassName(new double[0][0][0][0][0][0][0][0].getClass()), (Matcher)Is.is((Object)"double[][][][][][][][]"));
        Assert.assertThat((Object)Reflection.getClassName(new char[0][0][0][0][0][0][0][0].getClass()), (Matcher)Is.is((Object)"char[][][][][][][][]"));
        Assert.assertThat((Object)Reflection.getClassName(new byte[0][0][0][0][0][0][0][0].getClass()), (Matcher)Is.is((Object)"byte[][][][][][][][]"));
    }

    @Test
    public void shouldHaveTargetClass() {
        Assert.assertThat((Object)(this.stringReflection.getTargetClass() == String.class ? 1 : 0), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)(this.stringListReflection.getTargetClass() == List.class ? 1 : 0), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldFindMethodsWithExactMatchingName() {
        Method[] stringMethods = this.stringReflection.findMethods("indexOf", true);
        Assert.assertThat((Object)stringMethods.length, (Matcher)Is.is((Object)4));
        for (Method method : stringMethods) {
            Assert.assertThat((Object)method.getName(), (Matcher)Is.is((Object)"indexOf"));
        }
        stringMethods = this.stringReflection.findMethods("length", true);
        Assert.assertThat((Object)stringMethods.length, (Matcher)Is.is((Object)1));
        for (Method method : stringMethods) {
            Assert.assertThat((Object)method.getName(), (Matcher)Is.is((Object)"length"));
        }
    }

    @Test
    public void shouldFindMethodsWithNameMatchingRegularExpression() {
        Method[] stringMethods = this.stringReflection.findMethods("indexO.", true);
        Assert.assertThat((Object)stringMethods.length, (Matcher)Is.is((Object)4));
        for (Method method : stringMethods) {
            Assert.assertThat((Object)method.getName(), (Matcher)Is.is((Object)"indexOf"));
        }
        stringMethods = this.stringReflection.findMethods(".+gth", true);
        Assert.assertThat((Object)stringMethods.length, (Matcher)Is.is((Object)1));
        for (Method method : stringMethods) {
            Assert.assertThat((Object)method.getName(), (Matcher)Is.is((Object)"length"));
        }
    }

    @Test
    public void shouldNotFindMethodsWhenThereAreNoMethodsWithThatName() {
        Assert.assertThat((Object)this.stringReflection.findMethods("size", true).length, (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.stringListReflection.findMethods("argleBargle", true).length, (Matcher)Is.is((Object)0));
    }
}

