/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.common.util.Base64;

public class Base64Test {
    @Test
    public void testBasicExamples() throws IOException {
        byte[] originalBytes = new byte[]{-2, -1, 0, 1, 2};
        System.out.println("\n\nOriginal array: ");
        for (int i = 0; i < originalBytes.length; ++i) {
            System.out.print(originalBytes[i] + " ");
        }
        System.out.println();
        String encBytes = Base64.encodeBytes((byte[])originalBytes);
        System.out.println("Bytes, encoded ( " + encBytes.getBytes().length + " bytes):\n" + encBytes);
        byte[] decBytes = Base64.decode((String)encBytes);
        System.out.println("Encoded Bytes -> decoded: ");
        for (int i = 0; i < decBytes.length; ++i) {
            System.out.print(decBytes[i] + " ");
        }
        System.out.println();
    }

    @Test
    public void shouldEncodeStringValue() throws UnsupportedEncodingException, IOException {
        String actualValue = "propertyValue";
        String encoded = Base64.encodeBytes((byte[])actualValue.getBytes("UTF-8"));
        byte[] decoded = Base64.decode((String)encoded);
        String decodedValue = new String(decoded, "UTF-8");
        Assert.assertThat((Object)decodedValue, (Matcher)Is.is((Object)actualValue));
    }

    @Test
    public void shouldEncodeStreamableValue() throws IOException {
        String actualValue = "propertyValue";
        byte[] actualBytes = actualValue.getBytes();
        ByteArrayInputStream actualStream = new ByteArrayInputStream(actualBytes);
        String encoded = Base64.encode((InputStream)actualStream);
        String encoded2 = Base64.encodeBytes((byte[])actualBytes);
        Assert.assertThat((Object)encoded, (Matcher)Is.is((Object)encoded2));
        byte[] decoded = Base64.decode((String)encoded);
        String decodedValue = new String(decoded);
        Assert.assertThat((Object)decodedValue, (Matcher)Is.is((Object)actualValue));
    }

    @Test(expected=NullPointerException.class)
    public void testEncodeNullByteArray() {
        Base64.encodeBytes(null);
    }

    @Test
    public void testEncodeEmptyByteArray() {
        String result = Base64.encodeBytes((byte[])new byte[0]);
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)result.length(), (Matcher)Is.is((Object)0));
    }
}

