/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.util;

import java.util.Locale;
import java.util.concurrent.atomic.AtomicReference;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.i18n.I18n;
import org.modeshape.common.util.log.LogFactory;

@ThreadSafe
public abstract class Logger {
    static final LogFactory LOG_FACTORY = LogFactory.getLogFactory();
    protected static final AtomicReference<Locale> LOGGING_LOCALE = new AtomicReference<Object>(null);

    public static Locale getLoggingLocale() {
        return LOGGING_LOCALE.get();
    }

    public static Locale setLoggingLocale(Locale locale) {
        return LOGGING_LOCALE.getAndSet(locale != null ? locale : Locale.getDefault());
    }

    public static Logger getLogger(Class<?> clazz) {
        return LOG_FACTORY.getLogger(clazz);
    }

    public static Logger getLogger(String name) {
        return LOG_FACTORY.getLogger(name);
    }

    public abstract String getName();

    public void log(Level level, I18n message, Object ... params) {
        if (message == null) {
            return;
        }
        switch (level) {
            case DEBUG: {
                this.debug(message.text(LOGGING_LOCALE.get(), params), new Object[0]);
                break;
            }
            case ERROR: {
                this.error(message, params);
                break;
            }
            case INFO: {
                this.info(message, params);
                break;
            }
            case TRACE: {
                this.trace(message.text(LOGGING_LOCALE.get(), params), new Object[0]);
                break;
            }
            case WARNING: {
                this.warn(message, params);
                break;
            }
        }
    }

    public void log(Level level, Throwable t, I18n message, Object ... params) {
        if (message == null) {
            return;
        }
        switch (level) {
            case DEBUG: {
                this.debug(t, message.text(LOGGING_LOCALE.get(), params), new Object[0]);
                break;
            }
            case ERROR: {
                this.error(t, message, params);
                break;
            }
            case INFO: {
                this.info(t, message, params);
                break;
            }
            case TRACE: {
                this.trace(t, message.text(LOGGING_LOCALE.get(), params), new Object[0]);
                break;
            }
            case WARNING: {
                this.warn(t, message, params);
                break;
            }
        }
    }

    public abstract void debug(String var1, Object ... var2);

    public abstract void debug(Throwable var1, String var2, Object ... var3);

    public abstract void error(I18n var1, Object ... var2);

    public abstract void error(Throwable var1, I18n var2, Object ... var3);

    public abstract void info(I18n var1, Object ... var2);

    public abstract void info(Throwable var1, I18n var2, Object ... var3);

    public abstract void trace(String var1, Object ... var2);

    public abstract void trace(Throwable var1, String var2, Object ... var3);

    public abstract void warn(I18n var1, Object ... var2);

    public abstract void warn(Throwable var1, I18n var2, Object ... var3);

    public abstract boolean isInfoEnabled();

    public abstract boolean isWarnEnabled();

    public abstract boolean isErrorEnabled();

    public abstract boolean isDebugEnabled();

    public abstract boolean isTraceEnabled();

    public Level getLevel() {
        if (this.isTraceEnabled()) {
            return Level.TRACE;
        }
        if (this.isDebugEnabled()) {
            return Level.DEBUG;
        }
        if (this.isInfoEnabled()) {
            return Level.INFO;
        }
        if (this.isWarnEnabled()) {
            return Level.WARNING;
        }
        if (this.isErrorEnabled()) {
            return Level.ERROR;
        }
        return Level.OFF;
    }

    public static enum Level {
        OFF,
        ERROR,
        WARNING,
        INFO,
        DEBUG,
        TRACE;

    }
}

