/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.util.log;

import java.util.Locale;
import java.util.logging.Level;
import org.modeshape.common.i18n.I18n;
import org.modeshape.common.util.Logger;
import org.modeshape.common.util.StringUtil;

public class JdkLoggerImpl
extends Logger {
    private final java.util.logging.Logger logger;

    public JdkLoggerImpl(String category) {
        this.logger = java.util.logging.Logger.getLogger(category);
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    private void log(Level level, String message, Throwable ex) {
        if (this.logger.isLoggable(level)) {
            Throwable dummyException = new Throwable();
            StackTraceElement[] locations = dummyException.getStackTrace();
            String className = "unknown";
            String methodName = "unknown";
            int depth = 2;
            if (locations != null && locations.length > depth) {
                StackTraceElement caller = locations[depth];
                className = caller.getClassName();
                methodName = caller.getMethodName();
            }
            if (ex == null) {
                this.logger.logp(level, className, methodName, message);
            } else {
                this.logger.logp(level, className, methodName, message, ex);
            }
        }
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isLoggable(Level.FINER);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isLoggable(Level.FINE);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isLoggable(Level.INFO);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isLoggable(Level.WARNING);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    @Override
    public void debug(String message, Object ... params) {
        this.log(Level.FINE, StringUtil.createString(message, params), null);
    }

    @Override
    public void debug(Throwable t, String message, Object ... params) {
        this.log(Level.FINE, StringUtil.createString(message, params), t);
    }

    @Override
    public void error(I18n message, Object ... params) {
        this.log(Level.SEVERE, message.text((Locale)LOGGING_LOCALE.get(), params), null);
    }

    @Override
    public void error(Throwable t, I18n message, Object ... params) {
        this.log(Level.SEVERE, message.text((Locale)LOGGING_LOCALE.get(), params), t);
    }

    @Override
    public void info(I18n message, Object ... params) {
        this.log(Level.INFO, message.text((Locale)LOGGING_LOCALE.get(), params), null);
    }

    @Override
    public void info(Throwable t, I18n message, Object ... params) {
        this.log(Level.INFO, message.text((Locale)LOGGING_LOCALE.get(), params), t);
    }

    @Override
    public void trace(String message, Object ... params) {
        this.log(Level.FINER, StringUtil.createString(message, params), null);
    }

    @Override
    public void trace(Throwable t, String message, Object ... params) {
        this.log(Level.FINER, StringUtil.createString(message, params), t);
    }

    @Override
    public void warn(I18n message, Object ... params) {
        this.log(Level.WARNING, message.text((Locale)LOGGING_LOCALE.get(), params), null);
    }

    @Override
    public void warn(Throwable t, I18n message, Object ... params) {
        this.log(Level.WARNING, message.text((Locale)LOGGING_LOCALE.get(), params), t);
    }
}

