/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.text;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.text.XmlNameEncoder;

public class XmlNameEncoderTest {
    private XmlNameEncoder encoder = new XmlNameEncoder();

    @Before
    public void beforeEach() {
    }

    protected void checkEncoding(String input, String expected) {
        String output = this.encoder.encode(input);
        Assert.assertThat((Object)output, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertEquals((Object)expected, (Object)output);
        Assert.assertThat((Object)output.length(), (Matcher)Is.is((Object)expected.length()));
        Assert.assertThat((Object)output, (Matcher)Is.is((Object)expected));
        this.checkDecoding(output, input);
    }

    protected void checkForNoEncoding(String input) {
        String output = this.encoder.encode(input);
        Assert.assertThat((Object)output, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertEquals((Object)input, (Object)output);
        Assert.assertThat((Object)output.length(), (Matcher)Is.is((Object)input.length()));
        Assert.assertThat((Object)output, (Matcher)Is.is((Object)input));
        this.checkForNoDecoding(input);
    }

    protected void checkForNoDecoding(String input) {
        String output = this.encoder.decode(input);
        Assert.assertThat((Object)output, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertEquals((Object)input, (Object)output);
        Assert.assertThat((Object)output.length(), (Matcher)Is.is((Object)input.length()));
        Assert.assertThat((Object)output, (Matcher)Is.is((Object)input));
    }

    protected void checkDecoding(String input, String output) {
        String decoded = this.encoder.decode(input);
        Assert.assertEquals((Object)output, (Object)decoded);
        Assert.assertThat((Object)decoded.length(), (Matcher)Is.is((Object)output.length()));
        Assert.assertThat((Object)decoded, (Matcher)Is.is((Object)output));
    }

    @Test
    public void shouldNotEncodeUnderscoreIfNotFollowedByLowercaseX() {
        this.checkForNoEncoding("Employee_ID");
        this.checkForNoEncoding("_Employee_");
        this.checkForNoEncoding("Employee__ID");
    }

    @Test
    public void shouldEncodeUnderscoreIfFollowedByLowercaseX() {
        this.checkEncoding("Employee_x", "Employee_x005f_x");
        this.checkEncoding("Employee_x0", "Employee_x005f_x0");
        this.checkEncoding("Employee_x0022_", "Employee_x005f_x0022_");
    }

    @Test
    public void shouldNotDecodeIfNotValidHexadecimalValue() {
        this.checkForNoDecoding("_xH013_");
    }

    @Test
    public void shouldNotDecodeIfNotValidEncodedFormat() {
        this.checkForNoDecoding("_X0022_");
        this.checkForNoDecoding("x0022_");
        this.checkForNoDecoding("_x0022a");
    }

    @Test
    public void shouldNotEncodeDigits() {
        for (char c = '0'; c <= '9'; c = (char)(c + '\u0001')) {
            this.checkForNoEncoding("Employee" + c + "xyz");
        }
    }

    @Test
    public void shouldNotEncodeAlphabeticCharacters() {
        char c;
        for (c = 'A'; c <= 'Z'; c = (char)(c + '\u0001')) {
            this.checkForNoEncoding("Employee" + c + "xyz");
        }
        for (c = 'a'; c <= 'z'; c = (char)(c + '\u0001')) {
            this.checkForNoEncoding("Employee" + c + "xyz");
        }
    }

    @Test
    public void shouldNotEncodePeriodOrDashOrUnderscoreCharacters() {
        this.checkForNoEncoding("Employee.xyz");
        this.checkForNoEncoding("Employee-xyz");
        this.checkForNoEncoding("Employee:xyz");
        this.checkForNoEncoding("Employee_abc");
    }

    @Test
    public void shouldDecodeIfCompleteHexadecimal() {
        this.checkDecoding("Employee_", "Employee_");
        this.checkDecoding("Employee_x", "Employee_x");
        this.checkDecoding("Employee_x0", "Employee_x0");
        this.checkDecoding("Employee_x00", "Employee_x00");
        this.checkDecoding("Employee_x002", "Employee_x002");
        this.checkDecoding("Employee_x0022", "Employee_x0022");
        this.checkDecoding("_", "_");
        this.checkDecoding("_x", "_x");
        this.checkDecoding("_x0", "_x0");
        this.checkDecoding("_x00", "_x00");
        this.checkDecoding("_x002", "_x002");
        this.checkDecoding("_x0022", "_x0022");
    }

    @Test
    public void shouldEncodeUnderscoreOnlyWhenFollowedByX() {
        this.checkEncoding("Employee_xyz", "Employee_x005f_xyz");
        this.checkEncoding("Employee_ayz", "Employee_ayz");
    }

    @Test
    public void shouldEncodeNonAlphaNumericCharacters() {
        this.checkEncoding("Employee!xyz", "Employee_x0021_xyz");
        this.checkEncoding("Employee\"xyz", "Employee_x0022_xyz");
        this.checkEncoding("Employee#xyz", "Employee_x0023_xyz");
        this.checkEncoding("Employee$xyz", "Employee_x0024_xyz");
        this.checkEncoding("Employee%xyz", "Employee_x0025_xyz");
        this.checkEncoding("Employee&xyz", "Employee_x0026_xyz");
        this.checkEncoding("Employee'xyz", "Employee_x0027_xyz");
        this.checkEncoding("Employee(xyz", "Employee_x0028_xyz");
        this.checkEncoding("Employee)xyz", "Employee_x0029_xyz");
        this.checkEncoding("Employee*xyz", "Employee_x002a_xyz");
        this.checkEncoding("Employee+xyz", "Employee_x002b_xyz");
        this.checkEncoding("Employee,xyz", "Employee_x002c_xyz");
        this.checkEncoding("Employee/xyz", "Employee_x002f_xyz");
        this.checkEncoding("Employee\u0b9bxyz", "Employee_x0b9b_xyz");
    }
}

