/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.logging.slf4j;

import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.StringUtil;
import org.slf4j.LoggerFactory;

final class SLF4JLoggerImpl
extends Logger {
    private final org.slf4j.Logger logger;

    public SLF4JLoggerImpl(String category) {
        this.logger = LoggerFactory.getLogger((String)category);
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    @Override
    public void warn(Throwable t, I18nResource message, Object ... params) {
        if (!this.isWarnEnabled()) {
            return;
        }
        if (t == null) {
            this.warn(message, params);
            return;
        }
        if (message == null) {
            this.logger.warn(null, t);
            return;
        }
        this.logger.warn(message.text(SLF4JLoggerImpl.getLoggingLocale(), params), t);
    }

    @Override
    public void warn(I18nResource message, Object ... params) {
        if (!this.isWarnEnabled()) {
            return;
        }
        if (message == null) {
            return;
        }
        this.logger.warn(message.text(SLF4JLoggerImpl.getLoggingLocale(), params));
    }

    @Override
    public void debug(String message, Object ... params) {
        if (!this.isDebugEnabled()) {
            return;
        }
        if (message == null) {
            return;
        }
        this.logger.debug(StringUtil.createString(message, params));
    }

    @Override
    public void debug(Throwable t, String message, Object ... params) {
        if (!this.isDebugEnabled()) {
            return;
        }
        if (t == null) {
            this.debug(message, params);
            return;
        }
        if (message == null) {
            this.logger.debug(null, t);
            return;
        }
        this.logger.debug(StringUtil.createString(message, params), t);
    }

    @Override
    public void error(I18nResource message, Object ... params) {
        if (!this.isErrorEnabled()) {
            return;
        }
        if (message == null) {
            return;
        }
        this.logger.error(message.text(SLF4JLoggerImpl.getLoggingLocale(), params));
    }

    @Override
    public void error(Throwable t, I18nResource message, Object ... params) {
        if (!this.isErrorEnabled()) {
            return;
        }
        if (t == null) {
            this.error(message, params);
            return;
        }
        if (message == null) {
            this.logger.error(null, t);
            return;
        }
        this.logger.error(message.text(SLF4JLoggerImpl.getLoggingLocale(), params), t);
    }

    @Override
    public void info(I18nResource message, Object ... params) {
        if (!this.isInfoEnabled()) {
            return;
        }
        if (message == null) {
            return;
        }
        this.logger.info(message.text(SLF4JLoggerImpl.getLoggingLocale(), params));
    }

    @Override
    public void info(Throwable t, I18nResource message, Object ... params) {
        if (!this.isInfoEnabled()) {
            return;
        }
        if (t == null) {
            this.info(message, params);
            return;
        }
        if (message == null) {
            this.logger.info(null, t);
            return;
        }
        this.logger.info(message.text(SLF4JLoggerImpl.getLoggingLocale(), params), t);
    }

    @Override
    public void trace(String message, Object ... params) {
        if (!this.isTraceEnabled()) {
            return;
        }
        if (message == null) {
            return;
        }
        this.logger.trace(StringUtil.createString(message, params));
    }

    @Override
    public void trace(Throwable t, String message, Object ... params) {
        if (!this.isTraceEnabled()) {
            return;
        }
        if (t == null) {
            this.trace(message, params);
            return;
        }
        if (message == null) {
            this.logger.trace(null, t);
            return;
        }
        this.logger.trace(StringUtil.createString(message, params), t);
    }
}

