/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.util;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.util.NamedThreadFactory;
import org.modeshape.common.util.ThreadPoolFactory;

@ThreadSafe
public class ThreadPools
implements ThreadPoolFactory {
    private static final int DEFAULT_MAX_THREAD_COUNT = 4;
    private static final int DEFAULT_SCHEDULED_THREAD_COUNT = 1;
    private final ConcurrentMap<String, ExecutorService> poolsByName = new ConcurrentHashMap<String, ExecutorService>();

    @Override
    public ExecutorService getThreadPool(String name) {
        return this.getOrCreateNewPool(name, Executors.newFixedThreadPool(4, new NamedThreadFactory(name)));
    }

    @Override
    public ExecutorService getCachedTreadPool(String name) {
        return this.getOrCreateNewPool(name, Executors.newCachedThreadPool(new NamedThreadFactory(name)));
    }

    @Override
    public ExecutorService getScheduledThreadPool(String name) {
        return this.getOrCreateNewPool(name, Executors.newScheduledThreadPool(1, new NamedThreadFactory(name)));
    }

    private ExecutorService getOrCreateNewPool(String name, ExecutorService executorService) {
        ExecutorService executor = (ExecutorService)this.poolsByName.get(name);
        if (executor == null) {
            executor = this.poolsByName.putIfAbsent(name, executorService);
            if (executor != null) {
                executor.shutdownNow();
            }
            executor = executorService;
        }
        return executor;
    }

    @Override
    public void releaseThreadPool(ExecutorService executor) {
        Iterator entryIterator = this.poolsByName.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map.Entry entry = entryIterator.next();
            ExecutorService executorService = (ExecutorService)entry.getValue();
            if (!executor.equals(executorService)) continue;
            executorService.shutdown();
            entryIterator.remove();
            return;
        }
    }
}

