/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.logging;

import java.util.logging.Level;
import org.modeshape.common.CommonI18n;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.logging.jdk.JdkLoggerFactory;
import org.modeshape.common.logging.log4j.Log4jLoggerFactory;
import org.modeshape.common.logging.slf4j.SLF4JLoggerFactory;
import org.modeshape.common.util.ClassUtil;

public abstract class LogFactory {
    public static final String CUSTOM_LOG_FACTORY_CLASSNAME = "org.modeshape.common.logging.CustomLoggerFactory";
    private static LogFactory LOGFACTORY;

    private static boolean isSLF4JAvailable() {
        try {
            ClassUtil.loadClassStrict("org.slf4j.LoggerFactory");
            ClassUtil.loadClassStrict("org.slf4j.Logger");
            ClassUtil.loadClassStrict("org.slf4j.impl.StaticLoggerBinder");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static boolean isLog4jAvailable() {
        try {
            ClassUtil.loadClassStrict("org.apache.log4j.Logger");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static boolean isCustomLoggerAvailable() {
        try {
            ClassUtil.loadClassStrict(CUSTOM_LOG_FACTORY_CLASSNAME);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    static LogFactory getLogFactory() {
        return LOGFACTORY;
    }

    Logger getLogger(Class<?> clazz) {
        return Logger.getLogger(clazz.getName());
    }

    protected abstract Logger getLogger(String var1);

    static {
        if (LogFactory.isSLF4JAvailable()) {
            LOGFACTORY = new SLF4JLoggerFactory();
        } else if (LogFactory.isLog4jAvailable()) {
            LOGFACTORY = new Log4jLoggerFactory();
        } else if (LogFactory.isCustomLoggerAvailable()) {
            try {
                Class<?> customClass = Class.forName(CUSTOM_LOG_FACTORY_CLASSNAME);
                LOGFACTORY = (LogFactory)customClass.newInstance();
            }
            catch (Throwable e) {
                LOGFACTORY = new JdkLoggerFactory();
                java.util.logging.Logger jdkLogger = java.util.logging.Logger.getLogger(LogFactory.class.getName());
                String msg = CommonI18n.errorInitializingCustomLoggerFactory.text(CUSTOM_LOG_FACTORY_CLASSNAME);
                jdkLogger.log(Level.WARNING, msg, e);
            }
        } else {
            LOGFACTORY = new JdkLoggerFactory();
        }
    }
}

