/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.collection;

import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import org.modeshape.common.collection.EmptyIterator;
import org.modeshape.common.collection.ImmutableMapEntry;
import org.modeshape.common.collection.Multimap;

public abstract class AbstractMultimap<K, V>
implements Multimap<K, V> {
    private final Map<K, Collection<V>> data;
    private int totalSize;
    private transient Set<K> keysView;
    private transient Map<K, Collection<V>> mapView;
    private transient Collection<V> valuesCollection;
    private transient Collection<Map.Entry<K, V>> entriesCollection;

    protected AbstractMultimap(Map<K, Collection<V>> entries) {
        assert (entries != null);
        this.data = entries;
    }

    protected Map<K, Collection<V>> rawData() {
        return this.data;
    }

    protected abstract Collection<V> createCollection();

    protected abstract Collection<V> createUnmodifiableEmptyCollection();

    protected Collection<V> createUnmodifiable(Collection<V> original) {
        if (original instanceof List) {
            return Collections.unmodifiableList((List)original);
        }
        if (original instanceof Set) {
            return Collections.unmodifiableSet((Set)original);
        }
        return Collections.unmodifiableCollection(original);
    }

    @Override
    public int size() {
        return this.totalSize;
    }

    void incrementSize(int n) {
        this.totalSize += n;
    }

    void decrementSize(int n) {
        this.totalSize -= n;
        assert (this.totalSize >= 0);
    }

    @Override
    public boolean isEmpty() {
        return this.totalSize == 0;
    }

    @Override
    public boolean containsKey(K key) {
        return this.data.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        for (Collection<V> collection : this.data.values()) {
            if (!collection.contains(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsEntry(Object key, Object value) {
        Collection<V> values = this.data.get(key);
        return values == null ? false : values.contains(value);
    }

    @Override
    public Collection<V> get(K key) {
        Collection<V> collection = this.data.get(key);
        if (collection == null) {
            collection = this.createCollection();
        }
        return this.wrapCollection(key, collection);
    }

    @Override
    public boolean put(K key, V value) {
        if (this.getOrCreateCollection(key).add(value)) {
            this.incrementSize(1);
            return true;
        }
        return false;
    }

    protected Collection<V> getOrCreateCollection(K key) {
        Collection<V> values = this.data.get(key);
        if (values == null) {
            values = this.createCollection();
            this.data.put(key, values);
        }
        return values;
    }

    @Override
    public boolean remove(K key, V value) {
        Collection<V> values = this.data.get(key);
        if (values == null) {
            return false;
        }
        if (!values.remove(value)) {
            return false;
        }
        this.decrementSize(1);
        if (values.isEmpty()) {
            this.data.remove(key);
        }
        return true;
    }

    @Override
    public Collection<V> removeAll(K key) {
        Collection<V> values = this.data.remove(key);
        if (values == null) {
            return this.createUnmodifiableEmptyCollection();
        }
        Collection<V> copy = this.createCollection();
        copy.addAll(values);
        this.decrementSize(values.size());
        values.clear();
        return this.createUnmodifiable(copy);
    }

    protected boolean removeAllValuesForKey(Object key) {
        Collection<V> values = this.data.remove(key);
        if (values == null) {
            return false;
        }
        this.decrementSize(values.size());
        values.clear();
        return true;
    }

    public int hashCode() {
        return ((Object)this.data).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return ((Object)this.data).equals(obj);
    }

    public String toString() {
        return this.data.toString();
    }

    @Override
    public Set<K> keySet() {
        if (this.keysView == null) {
            this.keysView = this.wrapKeySet();
        }
        return this.keysView;
    }

    @Override
    public void clear() {
        this.totalSize = 0;
        this.data.clear();
    }

    @Override
    public Map<K, Collection<V>> asMap() {
        if (this.mapView == null) {
            this.mapView = this.wrapMap(this.data);
        }
        return this.mapView;
    }

    protected Iterator<Map.Entry<K, V>> createEntryIterator() {
        return new EntryIterator();
    }

    protected Collection<V> wrapCollection(K key, Collection<V> values) {
        if (values instanceof List) {
            return this.wrapList(key, (List)values);
        }
        return new WrappedCollection(key, values);
    }

    protected List<V> wrapList(K key, List<V> values) {
        return new WrappedList(key, values);
    }

    protected Map<K, Collection<V>> wrapMap(Map<K, Collection<V>> map) {
        return new WrappedMap(map);
    }

    protected Set<K> wrapKeySet() {
        if (this.data instanceof SortedMap) {
            return new WrappedSortedKeySet((SortedMap)this.data);
        }
        return new WrappedKeySet(this.data);
    }

    @Override
    public Collection<V> values() {
        if (this.valuesCollection == null) {
            this.valuesCollection = new ValuesCollection();
        }
        return this.valuesCollection;
    }

    @Override
    public Collection<Map.Entry<K, V>> entries() {
        if (this.entriesCollection == null) {
            this.entriesCollection = new EntriesCollection();
        }
        return this.entriesCollection;
    }

    protected class WrappedSortedKeySet
    extends WrappedKeySet
    implements SortedSet<K> {
        private SortedMap<K, Collection<V>> sortedDelegate;

        protected WrappedSortedKeySet(SortedMap<K, Collection<V>> wrapped) {
            super(wrapped);
            this.sortedDelegate = wrapped;
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.sortedDelegate.comparator();
        }

        @Override
        public SortedSet<K> subSet(K fromElement, K toElement) {
            return new WrappedSortedKeySet(this.sortedDelegate.subMap(fromElement, toElement));
        }

        @Override
        public SortedSet<K> headSet(K toElement) {
            return new WrappedSortedKeySet(this.sortedDelegate.headMap(toElement));
        }

        @Override
        public SortedSet<K> tailSet(K fromElement) {
            return new WrappedSortedKeySet(this.sortedDelegate.tailMap(fromElement));
        }

        @Override
        public K first() {
            return this.sortedDelegate.firstKey();
        }

        @Override
        public K last() {
            return this.sortedDelegate.lastKey();
        }
    }

    protected class WrappedKeySet
    extends AbstractSet<K> {
        private final Map<K, Collection<V>> delegate;

        protected WrappedKeySet(Map<K, Collection<V>> wrapped) {
            this.delegate = wrapped;
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public boolean remove(Object o) {
            return AbstractMultimap.this.removeAllValuesForKey(o);
        }

        @Override
        public boolean contains(Object o) {
            return this.delegate.containsKey(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.delegate.keySet().containsAll(c);
        }

        @Override
        public void clear() {
            this.delegate.clear();
            AbstractMultimap.this.totalSize = 0;
        }

        @Override
        public Iterator<K> iterator() {
            final Map delegate = this.delegate;
            return new Iterator<K>(){
                private final Iterator<Map.Entry<K, Collection<V>>> entryIter;
                private Map.Entry<K, Collection<V>> currentEntry;
                {
                    this.entryIter = delegate.entrySet().iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.entryIter.hasNext();
                }

                @Override
                public K next() {
                    this.currentEntry = this.entryIter.next();
                    return this.currentEntry.getKey();
                }

                @Override
                public void remove() {
                    this.entryIter.remove();
                    Collection values = this.currentEntry.getValue();
                    AbstractMultimap.this.decrementSize(values.size());
                    values.clear();
                }
            };
        }
    }

    protected class WrappedMap
    extends AbstractMap<K, Collection<V>> {
        private transient Set<Map.Entry<K, Collection<V>>> entries;
        private Map<K, Collection<V>> delegate;

        protected WrappedMap(Map<K, Collection<V>> wrapped) {
            this.delegate = wrapped;
        }

        @Override
        public Set<Map.Entry<K, Collection<V>>> entrySet() {
            if (this.entries == null) {
                this.entries = new WrappedEntrySet();
            }
            return this.entries;
        }

        protected Map<K, Collection<V>> delegate() {
            return this.delegate;
        }

        @Override
        public int hashCode() {
            return ((Object)this.delegate).hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            return ((Object)this.delegate).equals(o);
        }

        @Override
        public String toString() {
            return this.delegate.toString();
        }

        @Override
        public Collection<V> get(Object key) {
            return AbstractMultimap.this.get(key);
        }

        @Override
        public Collection<V> remove(Object key) {
            Collection values = AbstractMultimap.this.rawData().remove(key);
            if (values != null) {
                Collection copy = AbstractMultimap.this.createCollection();
                copy.addAll(values);
                AbstractMultimap.this.decrementSize(values.size());
                values.clear();
                values = copy;
            }
            return values;
        }

        protected class WrappedMapEntryIterator
        implements Iterator<Map.Entry<K, Collection<V>>> {
            private final Iterator<Map.Entry<K, Collection<V>>> delegateIterator;
            private Collection<V> currentValues;

            protected WrappedMapEntryIterator() {
                this.delegateIterator = WrappedMap.this.delegate().entrySet().iterator();
                this.currentValues = null;
            }

            @Override
            public boolean hasNext() {
                return this.delegateIterator.hasNext();
            }

            @Override
            public Map.Entry<K, Collection<V>> next() {
                Map.Entry currentEntry = this.delegateIterator.next();
                this.currentValues = currentEntry.getValue();
                Object key = currentEntry.getKey();
                return new ImmutableMapEntry(key, AbstractMultimap.this.wrapCollection(key, this.currentValues));
            }

            @Override
            public void remove() {
                this.delegateIterator.remove();
                AbstractMultimap.this.decrementSize(this.currentValues.size());
                this.currentValues.clear();
            }
        }

        protected class WrappedEntrySet
        extends AbstractSet<Map.Entry<K, Collection<V>>> {
            protected WrappedEntrySet() {
            }

            @Override
            public Iterator<Map.Entry<K, Collection<V>>> iterator() {
                return new WrappedMapEntryIterator();
            }

            @Override
            public int size() {
                return WrappedMap.this.delegate().size();
            }

            @Override
            public boolean contains(Object o) {
                return WrappedMap.this.delegate().entrySet().contains(o);
            }

            @Override
            public boolean remove(Object o) {
                if (!this.contains(o)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)o;
                AbstractMultimap.this.removeAllValuesForKey(entry.getKey());
                return true;
            }
        }
    }

    protected class WrappedList
    extends WrappedCollection
    implements List<V> {
        protected WrappedList(K key, Collection<V> values) {
            super(key, values);
        }

        protected List<V> delegate() {
            return (List)super.delegate();
        }

        @Override
        public boolean addAll(int index, Collection<? extends V> c) {
            if (c.isEmpty()) {
                return false;
            }
            Collection delegate = this.delegate();
            int sizeBefore = delegate.size();
            if (!delegate.addAll(index, c)) {
                return false;
            }
            AbstractMultimap.this.incrementSize(delegate.size() - sizeBefore);
            if (sizeBefore == 0) {
                this.addToMap();
            }
            return true;
        }

        @Override
        public V get(int index) {
            return this.delegate().get(index);
        }

        @Override
        public V set(int index, V element) {
            return this.delegate().set(index, element);
        }

        @Override
        public void add(int index, V element) {
            Collection values = this.delegate();
            boolean wasEmpty = values.isEmpty();
            values.add(index, element);
            AbstractMultimap.this.incrementSize(1);
            if (wasEmpty) {
                this.addToMap();
            }
        }

        @Override
        public V remove(int index) {
            Object removed = this.delegate().remove(index);
            AbstractMultimap.this.decrementSize(1);
            this.removeIfEmpty();
            return removed;
        }

        @Override
        public int indexOf(Object o) {
            return this.delegate().indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.delegate().lastIndexOf(o);
        }

        @Override
        public ListIterator<V> listIterator() {
            return new DelegateListIterator();
        }

        @Override
        public ListIterator<V> listIterator(int index) {
            return new DelegateListIterator(index);
        }

        @Override
        public List<V> subList(int fromIndex, int toIndex) {
            List valueSublist = this.delegate().subList(fromIndex, toIndex);
            return AbstractMultimap.this.wrapList(this.getKey(), valueSublist);
        }

        /*
         * Signature claims super is org.modeshape.common.collection.AbstractMultimap$WrappedCollection.DelegateIterator, not org.modeshape.common.collection.AbstractMultimap$WrappedCollection$DelegateIterator - discarding signature.
         */
        protected class DelegateListIterator
        extends WrappedCollection.DelegateIterator
        implements ListIterator {
            protected DelegateListIterator() {
            }

            protected DelegateListIterator(int index) {
                super(index);
            }

            protected ListIterator<V> iterator() {
                return (ListIterator)super.iterator();
            }

            @Override
            public boolean hasPrevious() {
                return this.iterator().hasPrevious();
            }

            public void add(V e) {
                this.iterator().add(e);
                AbstractMultimap.this.incrementSize(1);
            }

            @Override
            public int nextIndex() {
                return this.iterator().nextIndex();
            }

            public V previous() {
                return this.iterator().previous();
            }

            @Override
            public int previousIndex() {
                return this.iterator().previousIndex();
            }

            public void set(V e) {
                this.iterator().set(e);
            }
        }
    }

    protected class WrappedCollection
    implements Collection<V> {
        private Collection<V> delegate;
        private final K key;

        protected WrappedCollection(K key, Collection<V> values) {
            this.key = key;
            this.delegate = values;
        }

        public K getKey() {
            return this.key;
        }

        protected Collection<V> delegate() {
            Collection rawValues;
            if ((this.delegate == null || this.delegate.isEmpty()) && (rawValues = AbstractMultimap.this.rawData().get(this.key)) != null) {
                this.delegate = rawValues;
            }
            return this.delegate;
        }

        protected final void removeIfEmpty() {
            if (this.delegate != null && this.delegate.isEmpty()) {
                AbstractMultimap.this.removeAll(this.key);
                this.delegate = null;
            }
        }

        protected final void addToMap() {
            AbstractMultimap.this.rawData().put(this.key, this.delegate);
        }

        @Override
        public int size() {
            return this.delegate().size();
        }

        @Override
        public boolean isEmpty() {
            return this.delegate().isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.delegate().contains(o);
        }

        @Override
        public Iterator<V> iterator() {
            return this.delegate().iterator();
        }

        @Override
        public Object[] toArray() {
            return this.delegate().toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.delegate().toArray(a);
        }

        @Override
        public boolean add(V e) {
            Collection values = this.delegate();
            boolean wasEmpty = values.isEmpty();
            if (!values.add(e)) {
                return false;
            }
            AbstractMultimap.this.incrementSize(1);
            if (wasEmpty) {
                this.addToMap();
            }
            return true;
        }

        @Override
        public boolean remove(Object o) {
            if (!this.delegate().remove(o)) {
                return false;
            }
            AbstractMultimap.this.decrementSize(1);
            this.removeIfEmpty();
            return true;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.delegate().containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends V> c) {
            if (c.isEmpty()) {
                return false;
            }
            Collection delegate = this.delegate();
            int sizeBefore = delegate.size();
            if (!delegate.addAll(c)) {
                return false;
            }
            AbstractMultimap.this.incrementSize(delegate.size() - sizeBefore);
            if (sizeBefore == 0) {
                this.addToMap();
            }
            return true;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            if (c.isEmpty()) {
                return false;
            }
            Collection delegate = this.delegate();
            int sizeBefore = delegate.size();
            if (!delegate.removeAll(c)) {
                return false;
            }
            AbstractMultimap.this.incrementSize(delegate.size() - sizeBefore);
            this.removeIfEmpty();
            return true;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            if (c.isEmpty()) {
                return false;
            }
            Collection delegate = this.delegate();
            int sizeBefore = delegate.size();
            if (!delegate.retainAll(c)) {
                return false;
            }
            int diff = delegate.size() - sizeBefore;
            AbstractMultimap.this.incrementSize(diff);
            return true;
        }

        @Override
        public void clear() {
            Collection delegate = this.delegate();
            int sizeBefore = delegate.size();
            delegate.clear();
            AbstractMultimap.this.decrementSize(sizeBefore);
            this.removeIfEmpty();
        }

        @Override
        public int hashCode() {
            return ((Object)this.delegate()).hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            return ((Object)this.delegate()).equals(obj);
        }

        public String toString() {
            return this.delegate().toString();
        }

        protected class DelegateIterator
        implements Iterator<V> {
            private final Collection<V> source;
            private final Iterator<V> iterator;

            protected DelegateIterator() {
                this.source = WrappedCollection.this.delegate();
                this.iterator = this.source instanceof List ? ((List)this.source).listIterator() : this.source.iterator();
            }

            protected DelegateIterator(int index) {
                this.source = WrappedCollection.this.delegate();
                this.iterator = this.source instanceof List ? ((List)this.source).listIterator(index) : this.source.iterator();
            }

            protected Iterator<V> iterator() {
                if (this.source != WrappedCollection.this.delegate()) {
                    throw new ConcurrentModificationException();
                }
                return this.iterator;
            }

            @Override
            public boolean hasNext() {
                return this.iterator().hasNext();
            }

            @Override
            public V next() {
                return this.iterator.next();
            }

            @Override
            public void remove() {
                this.iterator.remove();
                AbstractMultimap.this.decrementSize(1);
                WrappedCollection.this.removeIfEmpty();
            }
        }
    }

    protected final class EntriesCollection
    extends AbstractCollection<Map.Entry<K, V>> {
        protected EntriesCollection() {
        }

        @Override
        public int size() {
            return AbstractMultimap.this.size();
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public void clear() {
            AbstractMultimap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry that = (Map.Entry)o;
            return AbstractMultimap.this.containsEntry(that.getKey(), that.getValue());
        }
    }

    protected final class EntryIterator
    implements Iterator<Map.Entry<K, V>> {
        private final Iterator<Map.Entry<K, Collection<V>>> iter;
        K currentKey;
        Collection<V> currentValues;
        Iterator<V> currentValuesIterator;

        EntryIterator() {
            this.iter = AbstractMultimap.this.rawData().entrySet().iterator();
            if (this.iter.hasNext()) {
                this.nextKey();
            } else {
                this.currentValuesIterator = new EmptyIterator();
            }
        }

        protected void nextKey() {
            Map.Entry entry = this.iter.next();
            this.currentKey = entry.getKey();
            this.currentValues = entry.getValue();
            this.currentValuesIterator = this.currentValues.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext() || this.currentValuesIterator.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            if (!this.currentValuesIterator.hasNext()) {
                this.nextKey();
            }
            return new ImmutableMapEntry(this.currentKey, this.currentValuesIterator.next());
        }

        @Override
        public void remove() {
            this.currentValuesIterator.remove();
            if (this.currentValues.isEmpty()) {
                this.iter.remove();
            }
            --AbstractMultimap.this.totalSize;
        }
    }

    protected final class ValueIterator
    implements Iterator<V> {
        private final Iterator<Map.Entry<K, V>> entryIterator;

        protected ValueIterator() {
            this.entryIterator = AbstractMultimap.this.createEntryIterator();
        }

        @Override
        public boolean hasNext() {
            return this.entryIterator.hasNext();
        }

        @Override
        public V next() {
            return this.entryIterator.next().getValue();
        }

        @Override
        public void remove() {
            this.entryIterator.remove();
        }
    }

    protected final class ValuesCollection
    extends AbstractCollection<V> {
        protected ValuesCollection() {
        }

        @Override
        public int size() {
            return AbstractMultimap.this.size();
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public void clear() {
            AbstractMultimap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            return AbstractMultimap.this.containsValue(o);
        }
    }
}

