/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.text;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.text.XmlValueEncoder;

public class XmlValueEncoderTest {
    private XmlValueEncoder encoder = new XmlValueEncoder();

    @Before
    public void beforeEach() {
    }

    protected void checkEncoding(String input, String expected) {
        String output = this.encoder.encode(input);
        Assert.assertThat((Object)output, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertEquals((Object)expected, (Object)output);
        Assert.assertThat((Object)output.length(), (Matcher)Is.is((Object)expected.length()));
        Assert.assertThat((Object)output, (Matcher)Is.is((Object)expected));
        this.checkDecoding(output, input);
    }

    protected void checkForNoEncoding(String input) {
        String output = this.encoder.encode(input);
        Assert.assertThat((Object)output, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertEquals((Object)input, (Object)output);
        Assert.assertThat((Object)output.length(), (Matcher)Is.is((Object)input.length()));
        Assert.assertThat((Object)output, (Matcher)Is.is((Object)input));
        this.checkForNoDecoding(input);
    }

    protected void checkForNoDecoding(String input) {
        String output = this.encoder.decode(input);
        Assert.assertThat((Object)output, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertEquals((Object)input, (Object)output);
        Assert.assertThat((Object)output.length(), (Matcher)Is.is((Object)input.length()));
        Assert.assertThat((Object)output, (Matcher)Is.is((Object)input));
    }

    protected void checkDecoding(String input, String output) {
        String decoded = this.encoder.decode(input);
        Assert.assertEquals((Object)output, (Object)decoded);
        Assert.assertThat((Object)decoded.length(), (Matcher)Is.is((Object)output.length()));
        Assert.assertThat((Object)decoded, (Matcher)Is.is((Object)output));
    }

    @Test
    public void shouldEncodeStringWithNoSpecialChars() {
        this.checkForNoEncoding("The quick brown fox jumped over the lazy dog.?+=!@#$%^*()_+-[]{}|\\");
    }

    @Test
    public void shouldEncodeStringWithSpecialChars() {
        this.checkEncoding("<>&'\"", "&lt;&gt;&amp;&#039;&quot;");
    }

    @Test
    public void shouldHandleTrivialCase() {
        Assert.assertNull((Object)this.encoder.encode(null));
        Assert.assertNull((Object)this.encoder.decode(null));
        this.checkEncoding("", "");
    }

    @Test
    public void shouldDecodeStringWithInvalidMappings() {
        this.checkDecoding("&amp", "&amp");
        this.checkDecoding("&quot", "&quot");
        this.checkDecoding("&gt", "&gt");
        this.checkDecoding("&lt", "&lt");
        this.checkDecoding("amp;", "amp;");
        this.checkDecoding("quot;", "quot;");
        this.checkDecoding("gt;", "gt;");
        this.checkDecoding("lt;", "lt;");
        this.checkDecoding("&;", "&;");
        this.checkDecoding("&amp;&", "&&");
    }
}

