/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.modeshape.common.SystemFailureException;
import org.modeshape.common.text.TextEncoder;
import org.modeshape.common.text.XmlValueEncoder;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class StreamingContentHandler
extends DefaultHandler {
    public static final String DEFAULT_ENCODING = "UTF-8";
    private final TextEncoder VALUE_ENCODER = new XmlValueEncoder();
    private final Collection<String> unexportableNamespaces;
    private final OutputStreamWriter writer;
    private final Map<String, String> mappedPrefixes;
    private final String declaration;

    public StreamingContentHandler(OutputStream os) {
        this(os, Collections.emptyList());
    }

    public StreamingContentHandler(OutputStream os, Collection<String> unexportableNamespaces) {
        try {
            this.writer = new OutputStreamWriter(os, DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new SystemFailureException(e);
        }
        this.unexportableNamespaces = unexportableNamespaces;
        this.mappedPrefixes = new HashMap<String, String>();
        this.declaration = "version=\"1.0\" encoding=\"UTF-8\"";
    }

    public StreamingContentHandler(OutputStream os, Collection<String> unexportableNamespaces, String encoding) throws UnsupportedEncodingException {
        this.writer = new OutputStreamWriter(os, encoding);
        this.unexportableNamespaces = unexportableNamespaces;
        this.mappedPrefixes = new HashMap<String, String>();
        if (encoding == null || encoding.length() == 0) {
            encoding = DEFAULT_ENCODING;
        }
        this.declaration = "version=\"1.0\" encoding=\"" + encoding + "\"";
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.emit(this.VALUE_ENCODER.encode(new String(ch, start, length)));
    }

    @Override
    public void startDocument() throws SAXException {
        this.emit("<?xml " + this.declaration + "?>");
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        this.emit("<");
        this.emit(name);
        for (Map.Entry<String, String> mapping : this.mappedPrefixes.entrySet()) {
            this.emit(" xmlns:");
            this.emit(mapping.getKey());
            this.emit("=\"");
            this.emit(mapping.getValue());
            this.emit("\"");
        }
        this.mappedPrefixes.clear();
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                this.emit(" ");
                this.emit(attributes.getQName(i));
                this.emit("=\"");
                this.emit(this.VALUE_ENCODER.encode(attributes.getValue(i)));
                this.emit("\"");
            }
        }
        this.emit(">");
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        this.emit("</");
        this.emit(name);
        this.emit(">");
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
        if (!this.unexportableNamespaces.contains(prefix)) {
            this.mappedPrefixes.put(prefix, uri);
        }
    }

    private void emit(String text) throws SAXException {
        try {
            this.writer.write(text);
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }
}

