/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.i18n;

import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.modeshape.common.CommonI18n;
import org.modeshape.common.SystemFailureException;
import org.modeshape.common.i18n.I18n;

public final class I18nTest {
    @BeforeClass
    public static void beforeClass() {
        Locale.setDefault(Locale.US);
    }

    @Before
    public void beforeEach() throws Exception {
        this.clearFields(TestI18n.class);
        this.clearFields(TestI18nDuplicateProperty.class);
        this.clearFields(TestI18nFinal.class);
        this.clearFields(TestI18nFinalField.class);
        this.clearFields(TestI18nInterface.class);
        this.clearFields(TestI18nMissingLocalization.class);
        this.clearFields(TestI18nMissingProperty.class);
        this.clearFields(TestI18nNotPublicField.class);
        this.clearFields(TestI18nNotStaticField.class);
        this.clearFields(TestI18nPrivate.class);
        this.clearFields(TestI18nUnusedProperty.class);
        for (Map.Entry localeToMapEntry : I18n.LOCALE_TO_CLASS_TO_PROBLEMS_MAP.entrySet()) {
            Iterator iter = ((Map)localeToMapEntry.getValue()).entrySet().iterator();
            while (iter.hasNext()) {
                if (iter.next().getKey() == CommonI18n.class) continue;
                iter.remove();
            }
        }
    }

    private void clearFields(Class<?> i18nClass) throws Exception {
        for (Field fld : i18nClass.getDeclaredFields()) {
            if (fld.getType() != I18n.class || (fld.getModifiers() & 1) != 1 || (fld.getModifiers() & 8) != 8 || (fld.getModifiers() & 0x10) == 16) continue;
            fld.set(null, null);
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailToGetLocalizationProblemLocalesIfNoClassSupplied() {
        I18n.getLocalizationProblemLocales(null);
    }

    @Test
    public void shouldNeverReturnNullWhenGettingLocalizationProblemLocales() {
        Assert.assertThat((Object)I18n.getLocalizationProblemLocales(TestI18n.class), (Matcher)IsNull.notNullValue());
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailToGetLocalizationProblemsForDefaultLocaleIfNoClassSupplied() {
        I18n.getLocalizationProblems(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailToGetLocalizationProblemsForSuppliedLocaleIfNoClassSupplied() {
        I18n.getLocalizationProblems(null, (Locale)Locale.US);
    }

    @Test
    public void shouldNeverReturnNullWhenGettingLocalizationProblemsForDefaultLocale() {
        Assert.assertThat((Object)I18n.getLocalizationProblems(TestI18n.class), (Matcher)IsNull.notNullValue());
    }

    @Test
    public void shouldNeverReturnNullWhenGettingLocalizationProblemsForSuppliedLocale() {
        Assert.assertThat((Object)I18n.getLocalizationProblems(TestI18n.class, (Locale)Locale.US), (Matcher)IsNull.notNullValue());
    }

    @Test
    public void shouldNotHaveLocalizationProblemsAfterInitializationButBeforeLocalization() {
        I18n.initialize(TestI18nUnusedProperty.class);
        Assert.assertThat((Object)I18n.getLocalizationProblems(TestI18nUnusedProperty.class, null).isEmpty(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)I18n.getLocalizationProblemLocales(TestI18nUnusedProperty.class).isEmpty(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldGetLocalizationProblemsForDefaultLocaleIfNoLocaleSupplied() {
        I18n.initialize(TestI18nUnusedProperty.class);
        TestI18nUnusedProperty.testMessage.text(new Object[]{"test"});
        Assert.assertThat((Object)I18n.getLocalizationProblems(TestI18nUnusedProperty.class, null).isEmpty(), (Matcher)Is.is((Object)false));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailToInitializeIfNoClassSupplied() {
        I18n.initialize(null);
    }

    @Test(expected=SystemFailureException.class)
    public void shouldFailToInitializeFinalI18nField() {
        try {
            I18n.initialize(TestI18nFinalField.class);
        }
        catch (SystemFailureException err) {
            Assert.assertThat((Object)err.getMessage(), (Matcher)Is.is((Object)CommonI18n.i18nFieldFinal.text(new Object[]{"testMessage", TestI18nFinalField.class})));
            System.err.println((Object)err);
            throw err;
        }
    }

    @Test(expected=SystemFailureException.class)
    public void shouldFailToInitializeNonPublicI18nField() {
        try {
            I18n.initialize(TestI18nNotPublicField.class);
        }
        catch (SystemFailureException err) {
            Assert.assertThat((Object)err.getMessage(), (Matcher)Is.is((Object)CommonI18n.i18nFieldNotPublic.text(new Object[]{"testMessage", TestI18nNotPublicField.class})));
            System.err.println((Object)err);
            throw err;
        }
    }

    @Test(expected=SystemFailureException.class)
    public void shouldFailToInitializeNonStaticI18nField() {
        try {
            I18n.initialize(TestI18nNotStaticField.class);
        }
        catch (SystemFailureException err) {
            Assert.assertThat((Object)err.getMessage(), (Matcher)Is.is((Object)CommonI18n.i18nFieldNotStatic.text(new Object[]{"testMessage", TestI18nNotStaticField.class})));
            System.err.println((Object)err);
            throw err;
        }
    }

    @Test
    public void shouldInitializeFinalClasses() {
        I18n.initialize(TestI18nFinal.class);
        Assert.assertThat((Object)TestI18nFinal.testMessage, (Matcher)IsInstanceOf.instanceOf(I18n.class));
    }

    @Test
    public void shouldInitializePrivateClasses() {
        I18n.initialize(TestI18nPrivate.class);
        Assert.assertThat((Object)TestI18nPrivate.testMessage, (Matcher)IsInstanceOf.instanceOf(I18n.class));
    }

    @Test
    public void shouldInitializeI18nFields() {
        I18n.initialize(TestI18n.class);
        Assert.assertThat((Object)TestI18n.testMessage, (Matcher)IsInstanceOf.instanceOf(I18n.class));
    }

    @Test
    public void shouldNotInitializeNonI18nFields() {
        I18n.initialize(TestI18n.class);
        Assert.assertThat((Object)TestI18n.nonI18n, (Matcher)IsNull.nullValue());
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailToInitializeInterfaces() {
        try {
            I18n.initialize(TestI18nInterface.class);
        }
        catch (IllegalArgumentException err) {
            Assert.assertThat((Object)err.getMessage(), (Matcher)Is.is((Object)CommonI18n.i18nClassInterface.text(new Object[]{TestI18nInterface.class.getName()})));
            System.err.println(err);
            throw err;
        }
    }

    @Test
    public void shouldProvideIdempotentInitialization() {
        I18n.initialize(TestI18n.class);
        Assert.assertThat((Object)TestI18n.testMessage1.text(new Object[]{"test"}), (Matcher)Is.is((Object)"test"));
        I18n.initialize(TestI18n.class);
        Assert.assertThat((Object)TestI18n.testMessage1.text(new Object[]{"test"}), (Matcher)Is.is((Object)"test"));
    }

    @Test
    public void shouldNotBeLocalizedAfterInitialization() {
        I18n.initialize(TestI18nDuplicateProperty.class);
        Assert.assertThat(TestI18nDuplicateProperty.testMessage.localeToTextMap.get(Locale.getDefault()), (Matcher)IsNull.nullValue());
        Assert.assertThat(TestI18nDuplicateProperty.testMessage.localeToProblemMap.get(Locale.getDefault()), (Matcher)IsNull.nullValue());
    }

    @Test
    public void shouldHaveIdThatMatchesFieldName() {
        I18n.initialize(TestI18n.class);
        Assert.assertThat((Object)TestI18n.testMessage.id(), (Matcher)Is.is((Object)"testMessage"));
    }

    @Test
    public void shouldNotBeLocalizedIfAskedForId() {
        I18n.initialize(TestI18nDuplicateProperty.class);
        TestI18nDuplicateProperty.testMessage.id();
        Assert.assertThat(TestI18nDuplicateProperty.testMessage.localeToTextMap.get(Locale.getDefault()), (Matcher)IsNull.nullValue());
        Assert.assertThat(TestI18nDuplicateProperty.testMessage.localeToProblemMap.get(Locale.getDefault()), (Matcher)IsNull.nullValue());
    }

    @Test
    public void shouldBeLocalizedIfAskedIfHasProblem() {
        I18n.initialize(TestI18nDuplicateProperty.class);
        TestI18nDuplicateProperty.testMessage.hasProblem();
        Assert.assertThat(TestI18nDuplicateProperty.testMessage.localeToTextMap.get(Locale.getDefault()), (Matcher)IsNull.notNullValue());
        Assert.assertThat(TestI18nDuplicateProperty.testMessage.localeToProblemMap.get(Locale.getDefault()), (Matcher)IsNull.notNullValue());
    }

    @Test
    public void shouldBeLocalizedIfAskedForProblem() {
        I18n.initialize(TestI18nDuplicateProperty.class);
        TestI18nDuplicateProperty.testMessage.problem();
        Assert.assertThat(TestI18nDuplicateProperty.testMessage.localeToTextMap.get(Locale.getDefault()), (Matcher)IsNull.notNullValue());
        Assert.assertThat(TestI18nDuplicateProperty.testMessage.localeToProblemMap.get(Locale.getDefault()), (Matcher)IsNull.notNullValue());
    }

    @Test
    public void shouldBeLocalizedIfConvertedToString() {
        I18n.initialize(TestI18nDuplicateProperty.class);
        TestI18nDuplicateProperty.testMessage.toString();
        Assert.assertThat(TestI18nDuplicateProperty.testMessage.localeToTextMap.get(Locale.getDefault()), (Matcher)IsNull.notNullValue());
        Assert.assertThat(TestI18nDuplicateProperty.testMessage.localeToProblemMap.get(Locale.getDefault()), (Matcher)IsNull.notNullValue());
    }

    @Test
    public void shouldContainAngleBracketedProblemInTextIfMissingLocalization() {
        I18n.initialize(TestI18nMissingLocalization.class);
        String text = TestI18nMissingLocalization.testMessage.text(new Object[0]);
        Assert.assertThat((Object)text, (Matcher)Is.is((Object)('<' + CommonI18n.i18nLocalizationProblems.text(new Object[]{TestI18nMissingLocalization.class, Locale.getDefault()}) + '>')));
        System.out.println("Text: " + text);
    }

    @Test
    public void shouldHaveProblemIfMissingLocalization() {
        I18n.initialize(TestI18nMissingLocalization.class);
        Assert.assertThat((Object)TestI18nMissingLocalization.testMessage.hasProblem(), (Matcher)Is.is((Object)true));
        String problem = TestI18nMissingLocalization.testMessage.problem();
        Assert.assertThat((Object)problem, (Matcher)Is.is((Object)CommonI18n.i18nLocalizationProblems.text(new Object[]{TestI18nMissingLocalization.class, Locale.getDefault()})));
        System.out.println("Problem: " + problem);
    }

    @Test
    public void shouldHaveLocalicationProblemIfMissingLocalization() {
        I18n.initialize(TestI18nMissingLocalization.class);
        TestI18nMissingLocalization.testMessage.text(new Object[0]);
        Assert.assertThat((Object)I18n.getLocalizationProblems(TestI18nMissingLocalization.class).size(), (Matcher)Is.is((Object)1));
        Assert.assertThat(I18n.getLocalizationProblems(TestI18nMissingLocalization.class).iterator().next(), (Matcher)Is.is((Object)CommonI18n.i18nLocalizationFileNotFound.text(new Object[]{TestI18nMissingLocalization.class.getName()})));
        Assert.assertThat((Object)I18n.getLocalizationProblemLocales(TestI18nMissingLocalization.class).size(), (Matcher)Is.is((Object)1));
        Assert.assertThat(I18n.getLocalizationProblemLocales(TestI18nMissingLocalization.class).iterator().next(), (Matcher)Is.is((Object)Locale.getDefault()));
    }

    @Test
    public void shouldHaveTextIfPropertyDuplicate() {
        I18n.initialize(TestI18nDuplicateProperty.class);
        String text = TestI18nDuplicateProperty.testMessage.text(new Object[]{"test"});
        Assert.assertThat((Object)Character.valueOf(text.charAt(0)), (Matcher)IsNot.not((Object)Character.valueOf('<')));
        System.out.println("Text: " + text);
    }

    @Test
    public void shouldHaveProblemIfPropertyDuplicate() {
        I18n.initialize(TestI18nDuplicateProperty.class);
        Assert.assertThat((Object)TestI18nDuplicateProperty.testMessage.hasProblem(), (Matcher)Is.is((Object)true));
        String problem = TestI18nDuplicateProperty.testMessage.problem();
        Assert.assertThat((Object)problem, (Matcher)IsNull.notNullValue());
        System.out.println("Problem: " + problem);
    }

    @Test
    public void shouldNotHaveLocalicationProblemIfPropertyDuplicate() {
        I18n.initialize(TestI18nDuplicateProperty.class);
        TestI18nDuplicateProperty.testMessage.text(new Object[]{"test"});
        Assert.assertThat((Object)I18n.getLocalizationProblems(TestI18nDuplicateProperty.class).isEmpty(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)I18n.getLocalizationProblemLocales(TestI18nDuplicateProperty.class).isEmpty(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldContainAngleBracketedProblemInTextIfPropertyMissing() {
        I18n.initialize(TestI18nMissingProperty.class);
        String text = TestI18nMissingProperty.testMessage1.text(new Object[]{"test"});
        Assert.assertThat((Object)Character.valueOf(text.charAt(0)), (Matcher)Is.is((Object)Character.valueOf('<')));
        System.out.println("Text: " + text);
    }

    @Test
    public void shouldHaveProblemIfPropertyMissing() {
        I18n.initialize(TestI18nMissingProperty.class);
        Assert.assertThat((Object)TestI18nMissingProperty.testMessage1.hasProblem(), (Matcher)Is.is((Object)true));
        String problem = TestI18nMissingProperty.testMessage1.problem();
        Assert.assertThat((Object)problem, (Matcher)IsNull.notNullValue());
        System.out.println("Problem: " + problem);
    }

    @Test
    public void shouldNotHaveLocalicationProblemIfPropertyMissing() {
        I18n.initialize(TestI18nMissingProperty.class);
        TestI18nMissingProperty.testMessage1.text(new Object[]{"test"});
        Assert.assertThat((Object)I18n.getLocalizationProblems(TestI18nMissingProperty.class).isEmpty(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)I18n.getLocalizationProblemLocales(TestI18nMissingProperty.class).isEmpty(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldHaveLocalicationProblemIfPropertyUnused() {
        I18n.initialize(TestI18nUnusedProperty.class);
        TestI18nUnusedProperty.testMessage.text(new Object[]{"test"});
        Assert.assertThat((Object)I18n.getLocalizationProblems(TestI18nUnusedProperty.class).size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)I18n.getLocalizationProblemLocales(TestI18nUnusedProperty.class).size(), (Matcher)Is.is((Object)1));
        Assert.assertThat(I18n.getLocalizationProblemLocales(TestI18nUnusedProperty.class).iterator().next(), (Matcher)Is.is((Object)Locale.getDefault()));
    }

    @Test
    public void shouldHaveTextMatchingLocalizationFilePropertyValue() {
        I18n.initialize(TestI18n.class);
        Assert.assertThat((Object)TestI18n.testMessage.text(new Object[0]), (Matcher)Is.is((Object)"Test Message"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailIfTooFewArgumentsSuppliedToText() {
        I18n.initialize(TestI18n.class);
        try {
            TestI18n.testMessage1.text(new Object[0]);
        }
        catch (IllegalArgumentException err) {
            System.err.println(err);
            throw err;
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailIfTooManyArgumentsSuppliedToText() {
        I18n.initialize(TestI18n.class);
        try {
            TestI18n.testMessage1.text(new Object[]{"Test", "Message"});
        }
        catch (IllegalArgumentException err) {
            System.err.println(err);
            throw err;
        }
    }

    @Test
    public void shouldContainArgumentsInRightOrderInText() {
        I18n.initialize(TestI18n.class);
        Assert.assertThat((Object)TestI18n.testMessage2.text(new Object[]{"Test", "Message"}), (Matcher)Is.is((Object)"Message Test"));
    }

    @Test
    public void shouldAllowReuseOfArgumentsInText() {
        I18n.initialize(TestI18n.class);
        Assert.assertThat((Object)TestI18n.testMessage3.text(new Object[]{"Test", "Message"}), (Matcher)Is.is((Object)"Message Test Message"));
    }

    @Test
    public void shouldContainLocaleSpecificText() {
        I18n.initialize(TestI18n.class);
        Assert.assertThat((Object)TestI18n.testMessage.text(Locale.FRENCH, new Object[0]), (Matcher)Is.is((Object)"Message de Test"));
    }

    @Test
    public void shouldContainTextForDefaultLocaleIfMissingLocalizationForSuppliedLocale() {
        I18n.initialize(TestI18n.class);
        Assert.assertThat((Object)TestI18n.testMessage.text(Locale.CHINESE, new Object[0]), (Matcher)Is.is((Object)"Test Message"));
    }

    private static class TestI18nMissingLocalization {
        public static I18n testMessage;

        private TestI18nMissingLocalization() {
        }
    }

    private static class TestI18nUnusedProperty {
        public static I18n testMessage;

        private TestI18nUnusedProperty() {
        }
    }

    private static class TestI18nPrivate {
        public static I18n testMessage;

        private TestI18nPrivate() {
        }
    }

    public static class TestI18nNotStaticField {
        public I18n testMessage;
    }

    public static class TestI18nNotPublicField {
        static I18n testMessage;
    }

    private static class TestI18nMissingProperty {
        public static I18n testMessage;
        public static I18n testMessage1;

        private TestI18nMissingProperty() {
        }
    }

    public static interface TestI18nInterface {
        public static final I18n testMessage = null;
    }

    public static class TestI18nFinalField {
        public static final I18n testMessage = null;
    }

    public static final class TestI18nFinal {
        public static I18n testMessage;
    }

    private static class TestI18nDuplicateProperty {
        public static I18n testMessage;

        private TestI18nDuplicateProperty() {
        }
    }

    public static class TestI18n {
        public static I18n testMessage;
        public static I18n testMessage1;
        public static I18n testMessage2;
        public static I18n testMessage3;
        public static Object nonI18n;
    }
}

