/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.text;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.common.text.Position;

public class PositionTest {
    private int combinedIndex(int firstIndex, int secondIndex) {
        Position first = new Position(firstIndex, 1, 0);
        Position second = new Position(secondIndex, 1, 0);
        int firstPlusSecond = first.add(second).getIndexInContent();
        int secondPlusFirst = second.add(first).getIndexInContent();
        Assert.assertThat((Object)firstPlusSecond, (Matcher)Is.is((Object)secondPlusFirst));
        return firstPlusSecond;
    }

    @Test
    public void shouldAddNoContentPositionToValidPosition() {
        Assert.assertThat((Object)this.combinedIndex(-1, 0), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.combinedIndex(-1, 1), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.combinedIndex(-1, 10), (Matcher)Is.is((Object)10));
    }

    @Test
    public void shouldAddValidPositionToNoContentPosition() {
        Assert.assertThat((Object)this.combinedIndex(0, -1), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.combinedIndex(1, -1), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.combinedIndex(10, -1), (Matcher)Is.is((Object)10));
    }

    @Test
    public void shouldAddValidPositionToValidPosition() {
        Assert.assertThat((Object)this.combinedIndex(1, 1), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)this.combinedIndex(10, 1), (Matcher)Is.is((Object)11));
        Assert.assertThat((Object)this.combinedIndex(1, 10), (Matcher)Is.is((Object)11));
        Assert.assertThat((Object)this.combinedIndex(10, 10), (Matcher)Is.is((Object)20));
    }

    @Test
    public void shouldAddStartingPositionToStartingPosition() {
        Assert.assertThat((Object)this.combinedIndex(0, 0), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldAddNoContentPositionToNoContentPosition() {
        Assert.assertThat((Object)this.combinedIndex(-1, -1), (Matcher)Is.is((Object)-1));
        Assert.assertThat((Object)this.combinedIndex(-10, -1), (Matcher)Is.is((Object)-1));
        Assert.assertThat((Object)this.combinedIndex(-1, -10), (Matcher)Is.is((Object)-1));
    }
}

