/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.util;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.util.TimeBasedKeys;

public class TimeBasedKeysTest {
    protected TimeBasedKeys counter = TimeBasedKeys.create((int)32);
    private boolean print;

    @Before
    public void beforeEach() {
        this.print = false;
    }

    @Test
    public void shouldCorrectlyCalculateFirstAndLastCounterFor1BitCounter() {
        TimeBasedKeys counter = TimeBasedKeys.create((int)1);
        Assert.assertEquals((long)0L, (long)counter.getCounterStartingAt(0L));
        Assert.assertEquals((long)1L, (long)counter.getCounterEndingAt(0L));
    }

    @Test
    public void shouldCorrectlyCalculateFirstAndLastCounterFor2Bit() {
        TimeBasedKeys counter = TimeBasedKeys.create((int)2);
        Assert.assertEquals((long)0L, (long)counter.getCounterStartingAt(0L));
        Assert.assertEquals((long)3L, (long)counter.getCounterEndingAt(0L));
    }

    @Test
    public void shouldCorrectlyCalculateFirstAndLastCounterFor3Bit() {
        TimeBasedKeys counter = TimeBasedKeys.create((int)3);
        Assert.assertEquals((long)0L, (long)counter.getCounterStartingAt(0L));
        Assert.assertEquals((long)7L, (long)counter.getCounterEndingAt(0L));
    }

    @Test
    public void shouldCorrectlyCalculateFirstAndLastCounterFor4Bit() {
        TimeBasedKeys counter = TimeBasedKeys.create((int)4);
        Assert.assertEquals((long)0L, (long)counter.getCounterStartingAt(0L));
        Assert.assertEquals((long)15L, (long)counter.getCounterEndingAt(0L));
    }

    @Test
    public void shouldCorrectlyCalculateFirstAndLastCounterFor5Bit() {
        TimeBasedKeys counter = TimeBasedKeys.create((int)5);
        Assert.assertEquals((long)0L, (long)counter.getCounterStartingAt(0L));
        Assert.assertEquals((long)31L, (long)counter.getCounterEndingAt(0L));
    }

    @Test
    public void shouldCorrectlyCalculateFirstAndLastCounterFor6Bit() {
        TimeBasedKeys counter = TimeBasedKeys.create((int)6);
        Assert.assertEquals((long)0L, (long)counter.getCounterStartingAt(0L));
        Assert.assertEquals((long)63L, (long)counter.getCounterEndingAt(0L));
    }

    @Test
    public void shouldCorrectlyCalculateFirstAndLastCounterFor7Bit() {
        TimeBasedKeys counter = TimeBasedKeys.create((int)7);
        Assert.assertEquals((long)0L, (long)counter.getCounterStartingAt(0L));
        Assert.assertEquals((long)127L, (long)counter.getCounterEndingAt(0L));
    }

    @Test
    public void shouldCorrectlyCalculateFirstAndLastCounterFor8Bit() {
        TimeBasedKeys counter = TimeBasedKeys.create((int)8);
        Assert.assertEquals((long)0L, (long)counter.getCounterStartingAt(0L));
        Assert.assertEquals((long)255L, (long)counter.getCounterEndingAt(0L));
    }

    @Test
    public void shouldCorrectlyCalculateFirstAndLastCounterFor16Bit() {
        long maxValue = (long)Math.pow(2.0, 16.0) - 1L;
        TimeBasedKeys counter = TimeBasedKeys.create((int)16);
        Assert.assertEquals((long)0L, (long)counter.getCounterStartingAt(0L));
        Assert.assertEquals((long)maxValue, (long)counter.getCounterEndingAt(0L));
    }

    @Test
    public void shouldObtain10MillionCountersThreadSafe() {
        this.print(this.counter.nextKey());
        for (int i = 0; i != 10000000; ++i) {
            this.counter.nextKey();
        }
        this.print(this.counter.nextKey());
    }

    @Test
    public void shouldObtain10MillionCountersFromThreadSafeUsingMultipleThreads() {
        this.print(this.counter.nextKey());
        for (int j = 0; j != 100; ++j) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i != 100000; ++i) {
                        TimeBasedKeysTest.this.counter.nextKey();
                    }
                }
            }).run();
        }
        this.print(this.counter.nextKey());
    }

    protected void print(String str) {
        if (this.print) {
            System.out.println(str);
        }
    }

    protected void print(long value) {
        if (this.print) {
            System.out.println(value);
        }
    }
}

