/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.logging.log4j;

import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.StringUtil;

final class Log4jLoggerImpl
extends Logger {
    private final org.apache.log4j.Logger logger;

    public Log4jLoggerImpl(String name) {
        this.logger = org.apache.log4j.Logger.getLogger((String)name);
    }

    @Override
    public void debug(String message, Object ... params) {
        if (!this.isDebugEnabled()) {
            return;
        }
        this.logger.debug((Object)StringUtil.createString(message, params));
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    @Override
    public void debug(Throwable t, String message, Object ... params) {
        if (StringUtil.isBlank(message)) {
            return;
        }
        if (!this.isDebugEnabled()) {
            return;
        }
        this.logger.debug((Object)StringUtil.createString(message, params), t);
    }

    @Override
    public void error(I18nResource message, Object ... params) {
        if (message == null) {
            return;
        }
        if (!this.isErrorEnabled()) {
            return;
        }
        this.logger.error((Object)message.text(Log4jLoggerImpl.getLoggingLocale(), params));
    }

    @Override
    public void error(Throwable t, I18nResource message, Object ... params) {
        if (message == null) {
            return;
        }
        if (!this.isErrorEnabled()) {
            return;
        }
        this.logger.error((Object)message.text(Log4jLoggerImpl.getLoggingLocale(), params), t);
    }

    @Override
    public void info(I18nResource message, Object ... params) {
        if (message == null) {
            return;
        }
        if (!this.isInfoEnabled()) {
            return;
        }
        this.logger.info((Object)message.text(Log4jLoggerImpl.getLoggingLocale(), params));
    }

    @Override
    public void info(Throwable t, I18nResource message, Object ... params) {
        if (message == null) {
            return;
        }
        if (!this.isInfoEnabled()) {
            return;
        }
        this.logger.info((Object)message.text(Log4jLoggerImpl.getLoggingLocale(), params), t);
    }

    @Override
    public void trace(String message, Object ... params) {
        if (StringUtil.isBlank(message)) {
            return;
        }
        if (!this.isTraceEnabled()) {
            return;
        }
        this.logger.trace((Object)StringUtil.createString(message, params));
    }

    @Override
    public void trace(Throwable t, String message, Object ... params) {
        if (StringUtil.isBlank(message)) {
            return;
        }
        if (!this.isTraceEnabled()) {
            return;
        }
        this.logger.trace((Object)StringUtil.createString(message, params), t);
    }

    @Override
    public void warn(I18nResource message, Object ... params) {
        if (message == null) {
            return;
        }
        if (!this.isWarnEnabled()) {
            return;
        }
        this.logger.warn((Object)message.text(Log4jLoggerImpl.getLoggingLocale(), params));
    }

    @Override
    public void warn(Throwable t, I18nResource message, Object ... params) {
        if (message == null) {
            return;
        }
        if (!this.isWarnEnabled()) {
            return;
        }
        this.logger.warn((Object)message.text(Log4jLoggerImpl.getLoggingLocale(), params), t);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isEnabledFor((Priority)Level.INFO);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isEnabledFor((Priority)Level.WARN);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isEnabledFor((Priority)Level.ERROR);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isEnabledFor((Priority)Level.DEBUG);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isEnabledFor((Priority)Level.TRACE);
    }
}

