/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.text;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.text.Inflector;

public class InflectorTest {
    private Inflector inflector;

    @Before
    public void beforeEach() {
        this.inflector = new Inflector();
    }

    public void singularToPlural(Object singular, String expectedPlural) {
        String actualPlural = this.inflector.pluralize(singular);
        Assert.assertEquals((Object)expectedPlural, (Object)actualPlural);
        String actualSingular = this.inflector.singularize((Object)expectedPlural);
        Assert.assertEquals((Object)singular, (Object)actualSingular);
        Assert.assertEquals((Object)singular, (Object)this.inflector.singularize(singular));
        Assert.assertEquals((Object)expectedPlural, (Object)this.inflector.pluralize((Object)expectedPlural));
    }

    public void upperCamelCase(String word, String expectedCamelized, char ... delimiterChars) {
        String actualCamelized = this.inflector.camelCase(word, true, delimiterChars);
        Assert.assertEquals((Object)expectedCamelized, (Object)actualCamelized);
        Assert.assertEquals((Object)expectedCamelized, (Object)this.inflector.upperCamelCase(word, delimiterChars));
        if (delimiterChars == null || delimiterChars.length == 0) {
            String actualUnderscored = this.inflector.underscore(expectedCamelized, new char[0]);
            Assert.assertEquals((Object)word, (Object)actualUnderscored);
        }
    }

    public void lowerCamelCase(String word, String expectedCamelized, char ... delimiterChars) {
        String actualCamelized = this.inflector.camelCase(word, false, delimiterChars);
        Assert.assertEquals((Object)expectedCamelized, (Object)actualCamelized);
        Assert.assertEquals((Object)expectedCamelized, (Object)this.inflector.lowerCamelCase(word, delimiterChars));
        if (delimiterChars == null || delimiterChars.length == 0) {
            String actualUnderscored = this.inflector.underscore(expectedCamelized, new char[0]);
            Assert.assertEquals((Object)word, (Object)actualUnderscored);
        }
    }

    public void underscore(String word, String expectedUnderscored, char ... delimiterChars) {
        String actualUnderscored = this.inflector.underscore(word, delimiterChars);
        Assert.assertEquals((Object)expectedUnderscored, (Object)actualUnderscored);
    }

    public void capitalize(String words, String expectedValue) {
        String actualValue = this.inflector.capitalize(words);
        Assert.assertEquals((Object)expectedValue, (Object)actualValue);
    }

    public void humanize(String word, String expectedValue, String ... removableTokens) {
        String actualValue = this.inflector.humanize(word, removableTokens);
        Assert.assertEquals((Object)expectedValue, (Object)actualValue);
    }

    public void titleCase(String word, String expectedValue, String ... removableTokens) {
        String actualValue = this.inflector.titleCase(word, removableTokens);
        Assert.assertEquals((Object)expectedValue, (Object)actualValue);
    }

    public void ordinalize(int number, String expectedValue) {
        String actualValue = this.inflector.ordinalize(number);
        Assert.assertEquals((Object)expectedValue, (Object)actualValue);
    }

    @Test
    public void shouldReplaceAllWithUppercase() {
        Assert.assertEquals((Object)"hEllO", (Object)Inflector.replaceAllWithUppercase((String)"hello", (String)"([aeiou])", (int)1));
        Assert.assertEquals((Object)"hLlo", (Object)Inflector.replaceAllWithUppercase((String)"hello", (String)"([aeiou])(l)", (int)2));
    }

    @Test
    public void shouldPluralizeAndSingularize() {
        this.singularToPlural("class", "classes");
        this.singularToPlural("glass", "glasses");
        this.singularToPlural("package", "packages");
        this.singularToPlural("setting", "settings");
        this.singularToPlural("sample", "samples");
        this.singularToPlural("message", "messages");
        this.singularToPlural("content", "contents");
        this.singularToPlural("ball", "balls");
        this.singularToPlural("axis", "axes");
        this.singularToPlural("octopus", "octopi");
        this.singularToPlural("virus", "viri");
        this.singularToPlural("alien", "aliens");
        this.singularToPlural("status", "statuses");
        this.singularToPlural("bus", "buses");
        this.singularToPlural("buffalo", "buffaloes");
        this.singularToPlural("tomato", "tomatoes");
        this.singularToPlural("quiz", "quizzes");
        this.singularToPlural("party", "parties");
        this.singularToPlural("half", "halves");
        this.singularToPlural("stadium", "stadiums");
        this.singularToPlural("search", "searches");
        this.singularToPlural("switch", "switches");
        this.singularToPlural("fix", "fixes");
        this.singularToPlural("box", "boxes");
        this.singularToPlural("process", "processes");
        this.singularToPlural("address", "addresses");
        this.singularToPlural("case", "cases");
        this.singularToPlural("stack", "stacks");
        this.singularToPlural("wish", "wishes");
        this.singularToPlural("fish", "fish");
        this.singularToPlural("category", "categories");
        this.singularToPlural("query", "queries");
        this.singularToPlural("ability", "abilities");
        this.singularToPlural("agency", "agencies");
        this.singularToPlural("movie", "movies");
        this.singularToPlural("archive", "archives");
        this.singularToPlural("index", "indices");
        this.singularToPlural("wife", "wives");
        this.singularToPlural("safe", "saves");
        this.singularToPlural("half", "halves");
        this.singularToPlural("move", "moves");
        this.singularToPlural("salesperson", "salespeople");
        this.singularToPlural("person", "people");
        this.singularToPlural("spokesman", "spokesmen");
        this.singularToPlural("man", "men");
        this.singularToPlural("woman", "women");
        this.singularToPlural("basis", "bases");
        this.singularToPlural("diagnosis", "diagnoses");
        this.singularToPlural("datum", "data");
        this.singularToPlural("medium", "media");
        this.singularToPlural("analysis", "analyses");
        this.singularToPlural("node_child", "node_children");
        this.singularToPlural("child", "children");
        this.singularToPlural("experience", "experiences");
        this.singularToPlural("day", "days");
        this.singularToPlural("comment", "comments");
        this.singularToPlural("foobar", "foobars");
        this.singularToPlural("newsletter", "newsletters");
        this.singularToPlural("old_news", "old_news");
        this.singularToPlural("news", "news");
        this.singularToPlural("series", "series");
        this.singularToPlural("species", "species");
        this.singularToPlural("quiz", "quizzes");
        this.singularToPlural("perspective", "perspectives");
        this.singularToPlural("ox", "oxen");
        this.singularToPlural("photo", "photos");
        this.singularToPlural("buffalo", "buffaloes");
        this.singularToPlural("tomato", "tomatoes");
        this.singularToPlural("dwarf", "dwarves");
        this.singularToPlural("elf", "elves");
        this.singularToPlural("information", "information");
        this.singularToPlural("equipment", "equipment");
        this.singularToPlural("bus", "buses");
        this.singularToPlural("status", "statuses");
        this.singularToPlural("status_code", "status_codes");
        this.singularToPlural("mouse", "mice");
        this.singularToPlural("louse", "lice");
        this.singularToPlural("house", "houses");
        this.singularToPlural("octopus", "octopi");
        this.singularToPlural("virus", "viri");
        this.singularToPlural("alias", "aliases");
        this.singularToPlural("portfolio", "portfolios");
        this.singularToPlural("vertex", "vertices");
        this.singularToPlural("matrix", "matrices");
        this.singularToPlural("axis", "axes");
        this.singularToPlural("testis", "testes");
        this.singularToPlural("crisis", "crises");
        this.singularToPlural("rice", "rice");
        this.singularToPlural("shoe", "shoes");
        this.singularToPlural("horse", "horses");
        this.singularToPlural("prize", "prizes");
        this.singularToPlural("edge", "edges");
    }

    @Test
    public void shouldConvertToCamelCase() {
        this.lowerCamelCase("edge", "edge", new char[0]);
        this.lowerCamelCase("active_record", "activeRecord", new char[0]);
        this.lowerCamelCase("product", "product", new char[0]);
        this.lowerCamelCase("special_guest", "specialGuest", new char[0]);
        this.lowerCamelCase("application_controller", "applicationController", new char[0]);
        this.lowerCamelCase("area51_controller", "area51Controller", new char[0]);
        this.lowerCamelCase("the-first_name", "theFirstName", '-');
        this.upperCamelCase("edge", "Edge", new char[0]);
        this.upperCamelCase("active_record", "ActiveRecord", new char[0]);
        this.upperCamelCase("product", "Product", new char[0]);
        this.upperCamelCase("special_guest", "SpecialGuest", new char[0]);
        this.upperCamelCase("application_controller", "ApplicationController", new char[0]);
        this.upperCamelCase("area51_controller", "Area51Controller", new char[0]);
        this.upperCamelCase("the-first_name", "TheFirstName", '-');
    }

    @Test
    public void shouldConvertToUnderscore() {
        this.underscore("activeRecord", "active_record", new char[0]);
        this.underscore("ActiveRecord", "active_record", new char[0]);
        this.underscore("ACTIVERecord", "active_record", new char[0]);
        this.underscore("firstName", "first_name", new char[0]);
        this.underscore("FirstName", "first_name", new char[0]);
        this.underscore("name", "name", new char[0]);
        this.underscore("The.firstName", "the_first_name", '.');
    }

    @Test
    public void shouldCapitalize() {
        this.capitalize("active record", "Active record");
        this.capitalize("first name", "First name");
        this.capitalize("name", "Name");
        this.capitalize("the first name", "The first name");
        this.capitalize("employee_salary", "Employee_salary");
        this.capitalize("underground", "Underground");
    }

    @Test
    public void shouldHumanize() {
        this.humanize("active_record", "Active record", new String[0]);
        this.humanize("first_name", "First name", new String[0]);
        this.humanize("name", "Name", new String[0]);
        this.humanize("the_first_name", "The first name", new String[0]);
        this.humanize("employee_salary", "Employee salary", new String[0]);
        this.humanize("underground", "Underground", new String[0]);
        this.humanize("id", "Id", new String[0]);
        this.humanize("employee_id", "Employee", new String[0]);
        this.humanize("employee_value_string", "Employee string", "value");
    }

    @Test
    public void shouldConvertToTitleCase() {
        this.titleCase("active_record", "Active Record", new String[0]);
        this.titleCase("first_name", "First Name", new String[0]);
        this.titleCase("name", "Name", new String[0]);
        this.titleCase("the_first_name", "The First Name", new String[0]);
        this.titleCase("employee_salary", "Employee Salary", new String[0]);
        this.titleCase("underground", "Underground", new String[0]);
        this.titleCase("id", "Id", new String[0]);
        this.titleCase("employee_id", "Employee", new String[0]);
        this.titleCase("employee_value_string", "Employee String", "value");
    }

    @Test
    public void shouldOrdinalize() {
        this.ordinalize(1, "1st");
        this.ordinalize(2, "2nd");
        this.ordinalize(3, "3rd");
        this.ordinalize(4, "4th");
        this.ordinalize(5, "5th");
        this.ordinalize(6, "6th");
        this.ordinalize(7, "7th");
        this.ordinalize(8, "8th");
        this.ordinalize(9, "9th");
        this.ordinalize(10, "10th");
        this.ordinalize(11, "11th");
        this.ordinalize(12, "12th");
        this.ordinalize(13, "13th");
        this.ordinalize(14, "14th");
        this.ordinalize(15, "15th");
        this.ordinalize(16, "16th");
        this.ordinalize(17, "17th");
        this.ordinalize(18, "18th");
        this.ordinalize(19, "19th");
        this.ordinalize(20, "20th");
        this.ordinalize(21, "21st");
        this.ordinalize(22, "22nd");
        this.ordinalize(23, "23rd");
        this.ordinalize(24, "24th");
        this.ordinalize(25, "25th");
        this.ordinalize(26, "26th");
        this.ordinalize(27, "27th");
        this.ordinalize(28, "28th");
        this.ordinalize(29, "29th");
        this.ordinalize(30, "30th");
        this.ordinalize(31, "31st");
        this.ordinalize(32, "32nd");
        this.ordinalize(33, "33rd");
        this.ordinalize(34, "34th");
        this.ordinalize(35, "35th");
        this.ordinalize(36, "36th");
        this.ordinalize(37, "37th");
        this.ordinalize(38, "38th");
        this.ordinalize(39, "39th");
        this.ordinalize(100, "100th");
        this.ordinalize(101, "101st");
        this.ordinalize(102, "102nd");
        this.ordinalize(103, "103rd");
        this.ordinalize(104, "104th");
        this.ordinalize(200, "200th");
        this.ordinalize(201, "201st");
        this.ordinalize(202, "202nd");
        this.ordinalize(203, "203rd");
        this.ordinalize(204, "204th");
        this.ordinalize(1000, "1000th");
        this.ordinalize(1001, "1001st");
        this.ordinalize(1002, "1002nd");
        this.ordinalize(1003, "1003rd");
        this.ordinalize(1004, "1004th");
        this.ordinalize(10000, "10000th");
        this.ordinalize(10001, "10001st");
        this.ordinalize(10002, "10002nd");
        this.ordinalize(10003, "10003rd");
        this.ordinalize(10004, "10004th");
        this.ordinalize(100000, "100000th");
        this.ordinalize(100001, "100001st");
        this.ordinalize(100002, "100002nd");
        this.ordinalize(100003, "100003rd");
        this.ordinalize(100004, "100004th");
    }
}

