/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.util;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.CheckArg;

public final class DelegatingClassLoader
extends URLClassLoader {
    private static final Logger LOGGER = Logger.getLogger(DelegatingClassLoader.class);
    private final List<? extends ClassLoader> delegates;

    public DelegatingClassLoader(ClassLoader parent, List<? extends ClassLoader> delegates) {
        super(new URL[0], parent);
        CheckArg.isNotNull(delegates, "delegates");
        this.delegates = delegates;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        for (ClassLoader classLoader : this.delegates) {
            try {
                return classLoader.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                LOGGER.debug(e, "Cannot load class using delegate: " + classLoader.getClass().toString(), new Object[0]);
            }
        }
        return super.findClass(name);
    }

    @Override
    public URL findResource(String name) {
        for (ClassLoader classLoader : this.delegates) {
            try {
                return classLoader.getResource(name);
            }
            catch (Exception e) {
                LOGGER.debug(e, "Cannot load resource using delegate: " + classLoader.getClass().toString(), new Object[0]);
            }
        }
        return super.findResource(name);
    }
}

