/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.junit;

import java.lang.annotation.Annotation;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.modeshape.common.junit.SkipLongRunning;
import org.modeshape.common.junit.SkipOnOS;
import org.modeshape.common.util.StringUtil;

public class SkipTestRule
implements TestRule {
    public Statement apply(Statement base, Description description) {
        boolean skipLongRunning;
        SkipLongRunning skipLongRunningAnnotation = this.hasAnnotation(description, SkipLongRunning.class);
        if (skipLongRunningAnnotation != null && (skipLongRunning = Boolean.valueOf(System.getProperty("skipLongRunningTests")).booleanValue())) {
            return SkipTestRule.emptyStatement(skipLongRunningAnnotation.value(), description);
        }
        SkipOnOS skipOnOSAnnotation = this.hasAnnotation(description, SkipOnOS.class);
        if (skipOnOSAnnotation != null) {
            String[] oses = skipOnOSAnnotation.value();
            String osName = System.getProperty("os.name");
            if (!StringUtil.isBlank((String)osName)) {
                for (String os : oses) {
                    if (!osName.toLowerCase().startsWith(os.toLowerCase())) continue;
                    return SkipTestRule.emptyStatement(skipOnOSAnnotation.description(), description);
                }
            }
        }
        return base;
    }

    private <T extends Annotation> T hasAnnotation(Description description, Class<T> annotationClass) {
        Annotation annotation = description.getAnnotation(annotationClass);
        if (annotation != null) {
            return (T)annotation;
        }
        if (description.isTest() && description.getTestClass().isAnnotationPresent(annotationClass)) {
            return description.getTestClass().getAnnotation(annotationClass);
        }
        return null;
    }

    private static Statement emptyStatement(final String reason, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                StringBuilder messageBuilder = new StringBuilder(description.testCount());
                messageBuilder.append("Skipped ").append(description.toString());
                if (!StringUtil.isBlank((String)reason)) {
                    messageBuilder.append(" because: ").append(reason);
                }
                System.out.println(messageBuilder.toString());
            }
        };
    }
}

