/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.text;

import java.security.NoSuchAlgorithmException;
import org.modeshape.common.text.TextEncoder;
import org.modeshape.common.util.Base64;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.SecureHash;

public class SecureHashTextEncoder
implements TextEncoder {
    private final SecureHash.Algorithm algorithm;
    private final int maxLength;

    public SecureHashTextEncoder(SecureHash.Algorithm algorithm) {
        this(algorithm, Integer.MAX_VALUE);
    }

    public SecureHashTextEncoder(SecureHash.Algorithm algorithm, int maxLength) {
        CheckArg.isNotNull((Object)algorithm, "algorithm");
        this.algorithm = algorithm;
        this.maxLength = maxLength < 1 ? Integer.MAX_VALUE : maxLength;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public SecureHash.Algorithm getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public String encode(String text) {
        try {
            byte[] hash = SecureHash.getHash(this.algorithm, text.getBytes());
            String result = Base64.encodeBytes(hash);
            return result.length() < this.maxLength ? result : result.substring(0, this.maxLength);
        }
        catch (NoSuchAlgorithmException e) {
            return text;
        }
    }
}

