/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.collection.ring;

import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.LockSupport;
import org.modeshape.common.collection.ring.Cursor;
import org.modeshape.common.collection.ring.GarbageCollectingConsumer;
import org.modeshape.common.collection.ring.Pointer;
import org.modeshape.common.collection.ring.PointerBarrier;
import org.modeshape.common.collection.ring.Pointers;
import org.modeshape.common.collection.ring.WaitStrategy;
import org.modeshape.common.util.CheckArg;

public class SingleProducerCursor
implements Cursor {
    private static final AtomicReferenceFieldUpdater<SingleProducerCursor, Pointer[]> STAY_BEHIND_UPDATER = AtomicReferenceFieldUpdater.newUpdater(SingleProducerCursor.class, Pointer[].class, "stayBehinds");
    private final int bufferSize;
    protected final Pointer current = new Pointer(Pointer.INITIAL_VALUE);
    protected final WaitStrategy waitStrategy;
    private long nextPosition = Pointer.INITIAL_VALUE;
    private long slowestConsumerPosition = Pointer.INITIAL_VALUE;
    protected volatile long finalPosition = Long.MAX_VALUE;
    protected volatile Pointer[] stayBehinds = new Pointer[0];

    public SingleProducerCursor(int bufferSize, WaitStrategy waitStrategy) {
        CheckArg.isPositive(bufferSize, "cursor.getBufferSize()");
        CheckArg.isPowerOfTwo(bufferSize, "cursor.getBufferSize()");
        this.bufferSize = bufferSize;
        this.waitStrategy = waitStrategy;
    }

    @Override
    public long getCurrent() {
        return this.nextPosition;
    }

    @Override
    public int getBufferSize() {
        return this.bufferSize;
    }

    @Override
    public long claim() {
        return this.claimUpTo(1);
    }

    @Override
    public long claim(int number) {
        return this.claimUpTo(number);
    }

    protected long claimUpTo(int number) {
        assert (number > 0);
        long nextPosition = this.nextPosition;
        long maxPosition = nextPosition + (long)number;
        long wrapPoint = maxPosition - (long)this.bufferSize;
        long cachedSlowestConsumerPosition = this.slowestConsumerPosition;
        if (wrapPoint > cachedSlowestConsumerPosition || cachedSlowestConsumerPosition > nextPosition) {
            long minPosition;
            while (wrapPoint > (minPosition = this.positionOfSlowestPointer(nextPosition))) {
                LockSupport.parkNanos(1L);
                this.waitStrategy.signalAllWhenBlocking();
            }
            this.slowestConsumerPosition = minPosition;
        }
        this.nextPosition = maxPosition;
        return maxPosition;
    }

    protected long positionOfSlowestPointer(long minimumPosition) {
        return Pointers.getMinimum(this.stayBehinds, minimumPosition);
    }

    protected long positionOfSlowestConsumer() {
        return this.slowestConsumerPosition;
    }

    @Override
    public boolean publish(long position) {
        if (this.finalPosition != Long.MAX_VALUE) {
            return false;
        }
        this.current.set(position);
        this.waitStrategy.signalAllWhenBlocking();
        return true;
    }

    @Override
    public long getHighestPublishedPosition(long lowerPosition, long upperPosition) {
        return upperPosition;
    }

    @Override
    public PointerBarrier newBarrier() {
        return new PointerBarrier(){
            private boolean closed = false;

            @Override
            public long waitFor(long position) throws InterruptedException, TimeoutException {
                if (position > SingleProducerCursor.this.finalPosition) {
                    return -1L;
                }
                long availableSequence = SingleProducerCursor.this.waitStrategy.waitFor(position, SingleProducerCursor.this.current, SingleProducerCursor.this.current, this);
                if (availableSequence < position) {
                    return availableSequence;
                }
                return SingleProducerCursor.this.getHighestPublishedPosition(position, availableSequence);
            }

            @Override
            public boolean isComplete() {
                return this.closed || SingleProducerCursor.this.isComplete();
            }

            @Override
            public void close() {
                this.closed = true;
            }
        };
    }

    @Override
    public void signalConsumers() {
        this.waitStrategy.signalAllWhenBlocking();
    }

    @Override
    public void complete() {
        this.finalPosition = this.current.get();
        this.waitStrategy.signalAllWhenBlocking();
    }

    @Override
    public boolean isComplete() {
        return this.finalPosition == this.current.get();
    }

    @Override
    public Pointer newPointer() {
        Pointer result = new Pointer(this.current.get());
        this.stayBehind(result);
        return result;
    }

    @Override
    public void stayBehind(Pointer ... pointers) {
        Pointers.add(this, STAY_BEHIND_UPDATER, this, pointers);
    }

    @Override
    public boolean ignore(Pointer pointer) {
        return Pointers.remove(this, STAY_BEHIND_UPDATER, pointer);
    }

    @Override
    public GarbageCollectingConsumer createGarbageCollectingConsumer(GarbageCollectingConsumer.Collectable collectable) {
        return new GarbageCollectingConsumer(this, this.current, this.waitStrategy, collectable);
    }
}

