/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.commons.impl;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.apache.chemistry.opencmis.commons.data.ContentStream;

public class IOUtils {
    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(ContentStream contentStream) {
        if (contentStream != null) {
            IOUtils.closeQuietly(contentStream.getStream());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void consumeAndClose(InputStream stream) {
        try {
            byte[] buffer = new byte[4096];
            while (stream.read(buffer) > -1) {
            }
        }
        catch (IOException iOException) {
        }
        finally {
            IOUtils.closeQuietly(stream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void consumeAndClose(Reader reader) {
        try {
            char[] buffer = new char[4096];
            while (reader.read(buffer) > -1) {
            }
        }
        catch (IOException iOException) {
        }
        finally {
            IOUtils.closeQuietly(reader);
        }
    }
}

