/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.filesystem;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.modeshape.common.i18n.I18n;
import org.modeshape.common.util.FileUtil;
import org.modeshape.common.util.IoUtil;
import org.modeshape.connector.filesystem.CustomPropertiesFactory;
import org.modeshape.connector.filesystem.FileSystemI18n;
import org.modeshape.connector.filesystem.FileSystemSource;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.JcrLexicon;
import org.modeshape.graph.JcrNtLexicon;
import org.modeshape.graph.Location;
import org.modeshape.graph.ModeShapeLexicon;
import org.modeshape.graph.NodeConflictBehavior;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.connector.path.AbstractWritablePathWorkspace;
import org.modeshape.graph.connector.path.DefaultPathNode;
import org.modeshape.graph.connector.path.PathNode;
import org.modeshape.graph.connector.path.PathRepositorySource;
import org.modeshape.graph.connector.path.WritablePathRepository;
import org.modeshape.graph.connector.path.WritablePathWorkspace;
import org.modeshape.graph.connector.path.cache.WorkspaceCache;
import org.modeshape.graph.mimetype.MimeTypeDetector;
import org.modeshape.graph.property.Binary;
import org.modeshape.graph.property.BinaryFactory;
import org.modeshape.graph.property.DateTimeFactory;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NameFactory;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.PropertyFactory;
import org.modeshape.graph.request.InvalidRequestException;

public class FileSystemRepository
extends WritablePathRepository {
    private static final String DEFAULT_MIME_TYPE = "application/octet";
    protected final FileSystemSource source;
    private File repositoryRoot;

    public FileSystemRepository(FileSystemSource source) {
        super((PathRepositorySource)source);
        this.source = source;
        this.initialize();
    }

    protected void initialize() {
        String repositoryRootPath = this.source.getWorkspaceRootPath();
        String sourceName = this.getSourceName();
        if (repositoryRootPath != null) {
            this.repositoryRoot = new File(repositoryRootPath);
            if (!this.repositoryRoot.exists()) {
                throw new IllegalStateException(FileSystemI18n.pathForWorkspaceRootDoesNotExist.text(new Object[]{repositoryRootPath, sourceName}));
            }
            if (!this.repositoryRoot.isDirectory()) {
                throw new IllegalStateException(FileSystemI18n.pathForWorkspaceRootIsNotDirectory.text(new Object[]{repositoryRootPath, sourceName}));
            }
            if (!this.repositoryRoot.canRead()) {
                throw new IllegalStateException(FileSystemI18n.pathForWorkspaceRootCannotBeRead.text(new Object[]{repositoryRootPath, sourceName}));
            }
        }
        if (!this.workspaces.isEmpty()) {
            return;
        }
        String defaultWorkspaceName = this.getDefaultWorkspaceName();
        ExecutionContext context = this.source.getRepositoryContext().getExecutionContext();
        for (String workspaceName : this.source.getPredefinedWorkspaceNames()) {
            this.doCreateWorkspace(context, workspaceName);
        }
        if (!this.workspaces.containsKey(defaultWorkspaceName)) {
            this.doCreateWorkspace(context, defaultWorkspaceName);
        }
    }

    public WorkspaceCache getCache(String workspaceName) {
        return this.source.getPathRepositoryCache().getCache(workspaceName);
    }

    private WritablePathWorkspace doCreateWorkspace(ExecutionContext context, String name) {
        File directory = this.getWorkspaceDirectory(name);
        FileSystemWorkspace workspace = new FileSystemWorkspace(name, context, directory);
        this.workspaces.putIfAbsent(name, workspace);
        return (WritablePathWorkspace)this.workspaces.get(name);
    }

    protected WritablePathWorkspace createWorkspace(ExecutionContext context, String name) {
        if (!this.source.isCreatingWorkspacesAllowed()) {
            String msg = FileSystemI18n.unableToCreateWorkspaces.text(new Object[]{this.getSourceName(), name});
            throw new InvalidRequestException(msg);
        }
        return this.doCreateWorkspace(context, name);
    }

    protected File getWorkspaceDirectory(String workspaceName) {
        File directory;
        if (workspaceName == null) {
            workspaceName = this.source.getDefaultWorkspaceName();
        }
        File file = directory = this.repositoryRoot == null ? new File(workspaceName) : new File(this.repositoryRoot, workspaceName);
        if (directory.exists() && directory.isDirectory() && directory.canRead()) {
            return directory;
        }
        return null;
    }

    public class FileSystemWorkspace
    extends AbstractWritablePathWorkspace {
        private final ExecutionContext context;
        private final File workspaceRoot;

        public FileSystemWorkspace(String name, ExecutionContext context, File workspaceRoot) {
            super(name, FileSystemRepository.this.source.getRootNodeUuid());
            this.workspaceRoot = workspaceRoot;
            this.context = context;
        }

        public PathNode createNode(ExecutionContext context, PathNode parentNode, Name name, Map<Name, Property> properties, NodeConflictBehavior conflictBehavior) {
            NameFactory nameFactory = context.getValueFactories().getNameFactory();
            PathFactory pathFactory = context.getValueFactories().getPathFactory();
            NamespaceRegistry registry = context.getNamespaceRegistry();
            Path parentPath = parentNode.getPath();
            File parentFile = this.fileFor(parentPath);
            Path newPath = pathFactory.create(parentPath, new Name[]{name});
            String newName = name.getString(registry);
            File newFile = new File(parentFile, newName);
            Property primaryTypeProp = properties.get(JcrLexicon.PRIMARY_TYPE);
            Name primaryType = primaryTypeProp == null ? JcrNtLexicon.FOLDER : (Name)nameFactory.create(primaryTypeProp.getFirstValue());
            CustomPropertiesFactory customPropertiesFactory = FileSystemRepository.this.source.customPropertiesFactory();
            if (JcrNtLexicon.FILE.equals(primaryType)) {
                if (!parentFile.canWrite()) {
                    I18n msg = FileSystemI18n.parentIsReadOnly;
                    throw new RepositorySourceException(FileSystemRepository.this.getSourceName(), msg.text(new Object[]{parentPath, this.getName(), FileSystemRepository.this.getSourceName()}));
                }
                try {
                    this.ensureValidPathLength(newFile);
                    boolean skipWrite = false;
                    if (newFile.exists()) {
                        if (conflictBehavior.equals((Object)NodeConflictBehavior.APPEND)) {
                            I18n msg = FileSystemI18n.sameNameSiblingsAreNotAllowed;
                            throw new InvalidRequestException(msg.text(new Object[]{FileSystemRepository.this.getSourceName(), newName}));
                        }
                        if (conflictBehavior.equals((Object)NodeConflictBehavior.DO_NOT_REPLACE)) {
                            skipWrite = true;
                        }
                    }
                    if (!skipWrite && !newFile.createNewFile()) {
                        I18n msg = FileSystemI18n.fileAlreadyExists;
                        throw new RepositorySourceException(FileSystemRepository.this.getSourceName(), msg.text(new Object[]{parentPath, this.getName(), FileSystemRepository.this.getSourceName()}));
                    }
                }
                catch (IOException ioe) {
                    I18n msg = FileSystemI18n.couldNotCreateFile;
                    throw new RepositorySourceException(FileSystemRepository.this.getSourceName(), msg.text(new Object[]{parentPath, this.getName(), FileSystemRepository.this.getSourceName(), ioe.getMessage()}), (Throwable)ioe);
                }
                customPropertiesFactory.recordFileProperties(context, FileSystemRepository.this.getSourceName(), Location.create((Path)newPath), newFile, properties);
            } else if (JcrNtLexicon.RESOURCE.equals(primaryType) || ModeShapeLexicon.RESOURCE.equals(primaryType)) {
                if (!JcrLexicon.CONTENT.equals(name)) {
                    I18n msg = FileSystemI18n.invalidNameForResource;
                    String nodeName = name.getString();
                    throw new RepositorySourceException(FileSystemRepository.this.getSourceName(), msg.text(new Object[]{parentPath, this.getName(), FileSystemRepository.this.getSourceName(), nodeName}));
                }
                if (!parentFile.isFile()) {
                    I18n msg = FileSystemI18n.invalidPathForResource;
                    throw new RepositorySourceException(FileSystemRepository.this.getSourceName(), msg.text(new Object[]{parentPath, this.getName(), FileSystemRepository.this.getSourceName()}));
                }
                if (!parentFile.canWrite()) {
                    I18n msg = FileSystemI18n.parentIsReadOnly;
                    throw new RepositorySourceException(FileSystemRepository.this.getSourceName(), msg.text(new Object[]{parentPath, this.getName(), FileSystemRepository.this.getSourceName()}));
                }
                boolean updateFileContent = true;
                switch (conflictBehavior) {
                    case APPEND: 
                    case REPLACE: 
                    case UPDATE: {
                        break;
                    }
                    case DO_NOT_REPLACE: {
                        updateFileContent = false;
                    }
                }
                if (updateFileContent) {
                    FileOutputStream fos = null;
                    try {
                        File temp = File.createTempFile("dna", null);
                        fos = new FileOutputStream(temp);
                        Property dataProp = properties.get(JcrLexicon.DATA);
                        if (dataProp == null) {
                            I18n msg = FileSystemI18n.missingRequiredProperty;
                            String dataPropName = JcrLexicon.DATA.getString();
                            throw new RepositorySourceException(FileSystemRepository.this.getSourceName(), msg.text(new Object[]{parentPath, this.getName(), FileSystemRepository.this.getSourceName(), dataPropName}));
                        }
                        BinaryFactory binaryFactory = context.getValueFactories().getBinaryFactory();
                        Binary binary = (Binary)binaryFactory.create(properties.get(JcrLexicon.DATA).getFirstValue());
                        IoUtil.write((InputStream)binary.getStream(), (OutputStream)fos);
                        if (!FileUtil.delete((File)parentFile)) {
                            I18n msg = FileSystemI18n.deleteFailed;
                            throw new RepositorySourceException(FileSystemRepository.this.getSourceName(), msg.text(new Object[]{parentPath, this.getName(), FileSystemRepository.this.getSourceName()}));
                        }
                        if (!temp.renameTo(parentFile)) {
                            I18n msg = FileSystemI18n.couldNotUpdateData;
                            throw new RepositorySourceException(FileSystemRepository.this.getSourceName(), msg.text(new Object[]{parentPath, this.getName(), FileSystemRepository.this.getSourceName()}));
                        }
                    }
                    catch (IOException ioe) {
                        I18n msg = FileSystemI18n.couldNotWriteData;
                        throw new RepositorySourceException(FileSystemRepository.this.getSourceName(), msg.text(new Object[]{parentPath, this.getName(), FileSystemRepository.this.getSourceName(), ioe.getMessage()}), (Throwable)ioe);
                    }
                    finally {
                        try {
                            if (fos != null) {
                                fos.close();
                            }
                        }
                        catch (Exception ex) {}
                    }
                }
                customPropertiesFactory.recordResourceProperties(context, FileSystemRepository.this.getSourceName(), Location.create((Path)parentPath), newFile, properties);
            } else if (JcrNtLexicon.FOLDER.equals(primaryType) || primaryType == null) {
                this.ensureValidPathLength(newFile);
                if (!newFile.mkdir()) {
                    I18n msg = FileSystemI18n.couldNotCreateFile;
                    throw new RepositorySourceException(FileSystemRepository.this.getSourceName(), msg.text(new Object[]{parentPath, this.getName(), FileSystemRepository.this.getSourceName(), primaryType == null ? "null" : primaryType.getString(registry)}));
                }
                customPropertiesFactory.recordDirectoryProperties(context, FileSystemRepository.this.getSourceName(), Location.create((Path)newPath), newFile, properties);
            } else {
                I18n msg = FileSystemI18n.unsupportedPrimaryType;
                throw new RepositorySourceException(FileSystemRepository.this.getSourceName(), msg.text(new Object[]{primaryType.getString(registry), parentPath, this.getName(), FileSystemRepository.this.getSourceName()}));
            }
            PathNode node = this.getNode(newPath);
            ArrayList<Path.Segment> newChildren = new ArrayList<Path.Segment>(parentNode.getChildSegments().size() + 1);
            newChildren.addAll(parentNode.getChildSegments());
            newChildren.add(node.getPath().getLastSegment());
            WorkspaceCache cache = FileSystemRepository.this.getCache(this.getName());
            cache.set((PathNode)new DefaultPathNode(parentNode.getPath(), parentNode.getUuid(), parentNode.getProperties(), newChildren));
            cache.set(node);
            return node;
        }

        public boolean removeNode(ExecutionContext context, Path nodePath) {
            if (!nodePath.isRoot() && JcrLexicon.CONTENT.equals(nodePath.getLastSegment().getName())) {
                File nodeFile = this.fileFor(nodePath.getParent());
                if (!nodeFile.exists()) {
                    return false;
                }
                FileOutputStream fos = null;
                try {
                    fos = new FileOutputStream(nodeFile);
                    IoUtil.write((String)"", (OutputStream)fos);
                }
                catch (IOException ioe) {
                    throw new RepositorySourceException(FileSystemRepository.this.getSourceName(), FileSystemI18n.deleteFailed.text(new Object[]{nodePath, this.getName(), FileSystemRepository.this.getSourceName()}));
                }
                finally {
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (IOException ioe) {}
                    }
                }
            }
            File nodeFile = this.fileFor(nodePath);
            if (!nodeFile.exists()) {
                return false;
            }
            FileUtil.delete((File)nodeFile);
            return true;
        }

        public PathNode setProperties(ExecutionContext context, Path nodePath, Map<Name, Property> properties) {
            File file;
            PathNode targetNode = this.getNode(nodePath);
            if (targetNode == null) {
                return null;
            }
            if (FileSystemRepository.this.source.getCustomPropertiesFactory() == null) {
                return targetNode;
            }
            Property primaryTypeProp = targetNode.getProperty(JcrLexicon.PRIMARY_TYPE);
            Name primaryTypeName = (Name)primaryTypeProp.getFirstValue();
            CustomPropertiesFactory customPropertiesFactory = FileSystemRepository.this.source.customPropertiesFactory();
            Location location = Location.create((Path)nodePath, (UUID)targetNode.getUuid());
            if (JcrNtLexicon.FILE.equals(primaryTypeName)) {
                customPropertiesFactory.recordFileProperties(context, FileSystemRepository.this.getSourceName(), location, this.fileFor(nodePath), properties);
            } else if (ModeShapeLexicon.RESOURCE.equals(primaryTypeName)) {
                file = this.fileFor(nodePath.getParent());
                customPropertiesFactory.recordResourceProperties(context, FileSystemRepository.this.getSourceName(), location, file, properties);
            } else {
                file = this.fileFor(nodePath);
                customPropertiesFactory.recordDirectoryProperties(context, FileSystemRepository.this.getSourceName(), location, file, properties);
            }
            PathNode node = this.getNode(nodePath);
            FileSystemRepository.this.getCache(this.getName()).set(node);
            return node;
        }

        public PathNode moveNode(ExecutionContext context, PathNode node, Name desiredNewName, WritablePathWorkspace originalWorkspace, PathNode newParent, PathNode beforeNode) {
            if (beforeNode != null) {
                throw new InvalidRequestException(FileSystemI18n.nodeOrderingNotSupported.text(new Object[]{FileSystemRepository.this.getSourceName()}));
            }
            PathNode movedNode = super.moveNode(context, node, desiredNewName, originalWorkspace, newParent, beforeNode);
            FileSystemRepository.this.getCache(this.getName()).invalidate(node.getPath());
            return movedNode;
        }

        public Path getLowestExistingPath(Path path) {
            File file = this.workspaceRoot;
            for (Path.Segment segment : path) {
                String localName = segment.getName().getLocalName();
                if (segment.getIndex() > 1) break;
                String defaultNamespaceUri = this.context.getNamespaceRegistry().getDefaultNamespaceUri();
                if (!segment.getName().getNamespaceUri().equals(defaultNamespaceUri)) break;
                if ((file = new File(file, localName)).exists() && file.canRead()) continue;
                Path lowest = path;
                while (lowest.getLastSegment() != segment) {
                    lowest = lowest.getParent();
                }
                return lowest.getParent();
            }
            return path;
        }

        public PathNode getNode(Path path) {
            WorkspaceCache cache = FileSystemRepository.this.getCache(this.getName());
            PathNode node = cache.get(path);
            if (node != null) {
                return node;
            }
            HashMap<Name, Property> properties = new HashMap<Name, Property>();
            PropertyFactory factory = this.context.getPropertyFactory();
            PathFactory pathFactory = this.context.getValueFactories().getPathFactory();
            DateTimeFactory dateFactory = this.context.getValueFactories().getDateFactory();
            MimeTypeDetector mimeTypeDetector = this.context.getMimeTypeDetector();
            CustomPropertiesFactory customPropertiesFactory = FileSystemRepository.this.source.customPropertiesFactory();
            NamespaceRegistry registry = this.context.getNamespaceRegistry();
            Location location = Location.create((Path)path);
            if (!path.isRoot() && JcrLexicon.CONTENT.equals(path.getLastSegment().getName())) {
                File file = this.fileFor(path.getParent());
                if (file == null) {
                    return null;
                }
                String mimeType = null;
                InputStream contents = null;
                try {
                    contents = new BufferedInputStream(new FileInputStream(file));
                    mimeType = mimeTypeDetector.mimeTypeOf(file.getName(), contents);
                    if (mimeType == null) {
                        mimeType = FileSystemRepository.DEFAULT_MIME_TYPE;
                    }
                    properties.put(JcrLexicon.MIMETYPE, factory.create(JcrLexicon.MIMETYPE, new Object[]{mimeType}));
                }
                catch (IOException e) {
                    I18n msg = FileSystemI18n.couldNotReadData;
                    throw new RepositorySourceException(FileSystemRepository.this.getSourceName(), msg.text(new Object[]{FileSystemRepository.this.getSourceName(), this.getName(), path.getString(registry)}));
                }
                finally {
                    if (contents != null) {
                        try {
                            contents.close();
                        }
                        catch (IOException e) {}
                    }
                }
                Collection<Property> customProps = customPropertiesFactory.getResourceProperties(this.context, location, file, mimeType);
                for (Property customProp : customProps) {
                    properties.put(customProp.getName(), customProp);
                }
                properties.put(JcrLexicon.PRIMARY_TYPE, factory.create(JcrLexicon.PRIMARY_TYPE, new Object[]{ModeShapeLexicon.RESOURCE}));
                properties.put(JcrLexicon.LAST_MODIFIED, factory.create(JcrLexicon.LAST_MODIFIED, new Object[]{dateFactory.create(file.lastModified())}));
                BinaryFactory binaryFactory = this.context.getValueFactories().getBinaryFactory();
                properties.put(JcrLexicon.DATA, factory.create(JcrLexicon.DATA, new Object[]{binaryFactory.create(file)}));
                return new DefaultPathNode(path, null, properties, Collections.emptyList());
            }
            File file = this.fileFor(path);
            if (file == null) {
                return null;
            }
            if (file.isDirectory()) {
                Object[] childNames = file.list(FileSystemRepository.this.source.filenameFilter());
                Arrays.sort(childNames);
                ArrayList<Path.Segment> childSegments = new ArrayList<Path.Segment>(childNames.length);
                for (Object childName : childNames) {
                    childSegments.add(pathFactory.createSegment((String)childName));
                }
                Collection<Property> customProps = customPropertiesFactory.getDirectoryProperties(this.context, location, file);
                for (Property customProp : customProps) {
                    properties.put(customProp.getName(), customProp);
                }
                if (path.isRoot()) {
                    properties.put(JcrLexicon.PRIMARY_TYPE, factory.create(JcrLexicon.PRIMARY_TYPE, new Object[]{ModeShapeLexicon.ROOT}));
                    return new DefaultPathNode(path, FileSystemRepository.this.source.getRootNodeUuid(), properties, childSegments);
                }
                properties.put(JcrLexicon.PRIMARY_TYPE, factory.create(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.FOLDER}));
                return new DefaultPathNode(path, FileSystemRepository.this.source.getRootNodeUuid(), properties, childSegments);
            }
            Collection<Property> customProps = customPropertiesFactory.getFileProperties(this.context, location, file);
            for (Property customProp : customProps) {
                properties.put(customProp.getName(), customProp);
            }
            properties.put(JcrLexicon.PRIMARY_TYPE, factory.create(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.FILE}));
            properties.put(JcrLexicon.CREATED, factory.create(JcrLexicon.CREATED, new Object[]{dateFactory.create(file.lastModified())}));
            node = new DefaultPathNode(path, null, properties, Collections.singletonList(pathFactory.createSegment(JcrLexicon.CONTENT)));
            cache.set(node);
            return node;
        }

        protected File fileFor(Path path) {
            assert (path != null);
            if (path.isRoot()) {
                return this.workspaceRoot;
            }
            if (path.getLastSegment().getName().equals(JcrLexicon.CONTENT)) {
                path = path.getParent();
            }
            File file = this.workspaceRoot;
            for (Path.Segment segment : path) {
                String localName = segment.getName().getLocalName();
                if (segment.getIndex() > 1) {
                    I18n msg = FileSystemI18n.sameNameSiblingsAreNotAllowed;
                    throw new RepositorySourceException(FileSystemRepository.this.getSourceName(), msg.text(new Object[]{FileSystemRepository.this.getSourceName()}));
                }
                String defaultNamespaceUri = this.context.getNamespaceRegistry().getDefaultNamespaceUri();
                if (!segment.getName().getNamespaceUri().equals(defaultNamespaceUri)) {
                    I18n msg = FileSystemI18n.onlyTheDefaultNamespaceIsAllowed;
                    throw new RepositorySourceException(FileSystemRepository.this.getSourceName(), msg.text(new Object[]{FileSystemRepository.this.getSourceName()}));
                }
                if ((file = new File(file, localName)).exists() && file.canRead()) continue;
                return null;
            }
            assert (file != null);
            return file;
        }

        protected void ensureValidPathLength(File root) {
            this.ensureValidPathLength(root, 0);
        }

        protected void ensureValidPathLength(File root, int delta) {
            try {
                int len = root.getCanonicalPath().length();
                if (len > FileSystemRepository.this.source.getMaxPathLength() - delta) {
                    String msg = FileSystemI18n.maxPathLengthExceeded.text(new Object[]{FileSystemRepository.this.source.getMaxPathLength(), FileSystemRepository.this.getSourceName(), root.getCanonicalPath(), delta});
                    throw new RepositorySourceException(FileSystemRepository.this.getSourceName(), msg);
                }
                if (root.isDirectory()) {
                    for (File child : root.listFiles(FileSystemRepository.this.source.filenameFilter())) {
                        this.ensureValidPathLength(child, delta);
                    }
                }
            }
            catch (IOException ioe) {
                throw new RepositorySourceException(FileSystemRepository.this.getSourceName(), FileSystemI18n.getCanonicalPathFailed.text(new Object[0]), (Throwable)ioe);
            }
        }
    }
}

