/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.filesystem;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.connector.filesystem.InclusionExclusionFilenameFilter;

public class InclusionExclusionFilenameFilterTest {
    private InclusionExclusionFilenameFilter filter;

    @Before
    public void setUp() {
        this.filter = new InclusionExclusionFilenameFilter();
    }

    @Test
    public void testEmptyFilter() {
        Assert.assertTrue((boolean)this.filter.accept(null, "anystring"));
    }

    @Test
    public void testInclusionOnly() {
        this.filter.setInclusionPattern("(.+)\\.mode");
        Assert.assertTrue((boolean)this.filter.accept(null, "myfile.mode"));
        Assert.assertFalse((boolean)this.filter.accept(null, "anotherfile.txt"));
    }

    @Test
    public void testExclusionOnly() {
        this.filter.setExclusionPattern("(.+)\\.mode");
        Assert.assertFalse((boolean)this.filter.accept(null, "myfile.mode"));
        Assert.assertTrue((boolean)this.filter.accept(null, "anotherfile.txt"));
    }

    @Test
    public void testInclusionExclusion() {
        this.filter.setInclusionPattern("(.+)\\.mode");
        this.filter.setExclusionPattern("ignore_me(.+)\\.mode");
        Assert.assertTrue((boolean)this.filter.accept(null, "validfile.mode"));
        Assert.assertFalse((boolean)this.filter.accept(null, "ignore_meinvalidfile.mode"));
    }
}

