/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.filesystem;

import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.modeshape.connector.filesystem.BasePropertiesFactory;
import org.modeshape.connector.filesystem.FileSystemI18n;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Location;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.ValueFactory;

public class ThrowProperties
extends BasePropertiesFactory {
    private static final long serialVersionUID = 1L;

    @Override
    public Collection<Property> getDirectoryProperties(ExecutionContext context, Location location, File directory) {
        return NO_PROPERTIES_COLLECTION;
    }

    @Override
    public Collection<Property> getFileProperties(ExecutionContext context, Location location, File file) {
        return NO_PROPERTIES_COLLECTION;
    }

    @Override
    public Collection<Property> getResourceProperties(ExecutionContext context, Location location, File file, String mimeType) {
        return NO_PROPERTIES_COLLECTION;
    }

    @Override
    public Set<Name> recordDirectoryProperties(ExecutionContext context, String sourceName, Location location, File file, Map<Name, Property> properties) throws RepositorySourceException {
        int numProperties = properties.size();
        if (numProperties != 0) {
            ValueFactory strings = context.getValueFactories().getStringFactory();
            StringBuilder names = new StringBuilder();
            boolean first = true;
            for (Property property : properties.values()) {
                if (this.STANDARD_PROPERTIES_FOR_FILE_OR_FOLDER.contains(property.getName())) continue;
                if (first) {
                    first = false;
                } else {
                    names.append(",");
                }
                String name = (String)strings.create(property.getName());
                names.append(name);
            }
            String msg = null;
            msg = properties.size() == 1 ? FileSystemI18n.couldNotStoreProperties.text(new Object[]{names, file.getPath(), sourceName}) : FileSystemI18n.couldNotStoreProperty.text(new Object[]{names, file.getPath(), sourceName});
            throw new RepositorySourceException(sourceName, msg);
        }
        return NO_NAMES;
    }

    @Override
    public Set<Name> recordFileProperties(ExecutionContext context, String sourceName, Location location, File file, Map<Name, Property> properties) throws RepositorySourceException {
        int numProperties = properties.size();
        if (numProperties != 0) {
            ValueFactory strings = context.getValueFactories().getStringFactory();
            StringBuilder names = new StringBuilder();
            boolean first = true;
            for (Property property : properties.values()) {
                if (this.STANDARD_PROPERTIES_FOR_FILE_OR_FOLDER.contains(property.getName())) continue;
                if (first) {
                    first = false;
                } else {
                    names.append(",");
                }
                String name = (String)strings.create(property.getName());
                names.append(name);
            }
            String msg = null;
            msg = properties.size() == 1 ? FileSystemI18n.couldNotStoreProperties.text(new Object[]{names, file.getPath(), sourceName}) : FileSystemI18n.couldNotStoreProperty.text(new Object[]{names, file.getPath(), sourceName});
            throw new RepositorySourceException(sourceName, msg);
        }
        return NO_NAMES;
    }

    @Override
    public Set<Name> recordResourceProperties(ExecutionContext context, String sourceName, Location location, File file, Map<Name, Property> properties) throws RepositorySourceException {
        int numProperties = properties.size();
        if (numProperties != 0) {
            ValueFactory strings = context.getValueFactories().getStringFactory();
            StringBuilder names = new StringBuilder();
            boolean first = true;
            for (Property property : properties.values()) {
                if (this.STANDARD_PROPERTIES_FOR_CONTENT.contains(property.getName())) continue;
                if (first) {
                    first = false;
                } else {
                    names.append(",");
                }
                String name = (String)strings.create(property.getName());
                names.append(name);
            }
            String msg = null;
            msg = properties.size() == 1 ? FileSystemI18n.couldNotStoreProperties.text(new Object[]{names, file.getPath(), sourceName}) : FileSystemI18n.couldNotStoreProperty.text(new Object[]{names, file.getPath(), sourceName});
            throw new RepositorySourceException(sourceName, msg);
        }
        return NO_NAMES;
    }
}

