/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.infinispan;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.manager.CacheManager;
import org.modeshape.connector.infinispan.InfinispanNode;
import org.modeshape.connector.infinispan.InfinispanSource;
import org.modeshape.connector.infinispan.InfinispanTransaction;
import org.modeshape.connector.infinispan.InfinispanWorkspace;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.connector.base.BaseRepositorySource;
import org.modeshape.graph.connector.base.Repository;

@ThreadSafe
public class InfinispanRepository
extends Repository<InfinispanNode, InfinispanWorkspace> {
    private final CacheManager cacheManager;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Set<String> predefinedWorkspaceNames;

    public InfinispanRepository(InfinispanSource source, CacheManager cacheManager) {
        super((BaseRepositorySource)source);
        this.cacheManager = cacheManager;
        assert (this.cacheManager != null);
        HashSet<String> workspaceNames = new HashSet<String>();
        for (String workspaceName : source.getPredefinedWorkspaceNames()) {
            workspaceNames.add(workspaceName);
        }
        this.predefinedWorkspaceNames = Collections.unmodifiableSet(workspaceNames);
        this.initialize();
    }

    public Set<String> getWorkspaceNames() {
        HashSet<String> names = new HashSet<String>(super.getWorkspaceNames());
        names.addAll(this.predefinedWorkspaceNames);
        return Collections.unmodifiableSet(names);
    }

    protected CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void shutdown() {
        this.cacheManager.stop();
    }

    public InfinispanTransaction startTransaction(ExecutionContext context, boolean readonly) {
        Lock lock = readonly ? this.lock.readLock() : this.lock.writeLock();
        lock.lock();
        return new InfinispanTransaction(this, this.getRootNodeUuid(), lock);
    }
}

