/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.commands.write;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.commands.Visitor;
import org.jboss.cache.commands.write.AbstractVersionedDataCommand;
import org.jboss.cache.optimistic.DataVersion;
import org.jboss.cache.transaction.GlobalTransaction;

public class RemoveNodeCommand
extends AbstractVersionedDataCommand {
    public static final int METHOD_ID = 5;
    public static final int VERSIONED_METHOD_ID = 40;
    protected static final Log log = LogFactory.getLog(RemoveNodeCommand.class);
    protected static final boolean trace = log.isTraceEnabled();
    private boolean skipSendingNodeEvents = false;
    protected Fqn parentFqn;
    protected NodeSPI targetNode;

    public RemoveNodeCommand(GlobalTransaction globalTransaction, Fqn fqn) {
        this.globalTransaction = globalTransaction;
        this.fqn = fqn;
    }

    public RemoveNodeCommand() {
    }

    public Object perform(InvocationContext ctx) {
        if (trace) {
            log.trace("perform(" + this.globalTransaction + ", " + this.fqn + ")");
        }
        this.targetNode = this.peekVersioned(ctx);
        if (this.targetNode == null || this.targetNode.isDeleted()) {
            if (trace) {
                log.trace("node " + this.fqn + " not found");
            }
            return false;
        }
        this.notifyBeforeRemove(this.targetNode, ctx);
        boolean found = this.targetNode.isValid() && !this.targetNode.isDeleted();
        this.recursivelyMarkAsRemoved(this.targetNode, ctx);
        this.targetNode.clearDataDirect();
        this.notifyAfterRemove(ctx);
        return found;
    }

    protected void recursivelyMarkAsRemoved(NodeSPI node, InvocationContext ctx) {
        node.markAsDeleted(true);
        Fqn parentFqn = node.getFqn();
        Map<Fqn, NodeSPI> nodes = ctx.getLookedUpNodes();
        for (Map.Entry<Fqn, NodeSPI> entry : nodes.entrySet()) {
            if (!entry.getKey().isChildOf(parentFqn)) continue;
            entry.getValue().markAsDeleted(true);
        }
    }

    private void notifyBeforeRemove(NodeSPI n, InvocationContext ctx) {
        if (!this.skipSendingNodeEvents) {
            this.notifier.notifyNodeRemoved(this.fqn, true, n.getDataDirect(), ctx);
        }
    }

    private void notifyAfterRemove(InvocationContext ctx) {
        if (!this.skipSendingNodeEvents) {
            this.notifier.notifyNodeRemoved(this.fqn, false, null, ctx);
        }
    }

    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitRemoveNodeCommand(ctx, this);
    }

    public boolean isSkipSendingNodeEvents() {
        return this.skipSendingNodeEvents;
    }

    public int getCommandId() {
        return this.isVersioned() ? 40 : 5;
    }

    public Object[] getParameters() {
        if (this.isVersioned()) {
            return new Object[]{this.globalTransaction, this.fqn, true, this.skipSendingNodeEvents, this.dataVersion};
        }
        return new Object[]{this.globalTransaction, this.fqn, true, this.skipSendingNodeEvents};
    }

    public void setParameters(int commandId, Object[] args) {
        this.globalTransaction = (GlobalTransaction)args[0];
        this.fqn = (Fqn)args[1];
        this.skipSendingNodeEvents = (Boolean)args[3];
        if (this.isVersionedId(commandId)) {
            this.dataVersion = (DataVersion)args[4];
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RemoveNodeCommand that = (RemoveNodeCommand)o;
        if (this.skipSendingNodeEvents != that.skipSendingNodeEvents) {
            return false;
        }
        return !(this.globalTransaction != null ? !this.globalTransaction.equals(that.globalTransaction) : that.globalTransaction != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.globalTransaction != null ? this.globalTransaction.hashCode() : 0);
        result = 31 * result + (this.skipSendingNodeEvents ? 1 : 0);
        return result;
    }

    protected boolean isVersionedId(int id) {
        return id == 40;
    }

    public void setSkipSendingNodeEvents(boolean skipSendingNodeEvents) {
        this.skipSendingNodeEvents = skipSendingNodeEvents;
    }

    public String toString() {
        return "RemoveNodeCommand{fqn=" + this.fqn + ", dataVersion=" + this.dataVersion + ", globalTransaction=" + this.globalTransaction + ", skipSendingNodeEvents=" + this.skipSendingNodeEvents + ", parentFqn=" + this.parentFqn + ", targetNode=" + this.targetNode + '}';
    }
}

