/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.config;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.CacheStatus;
import org.jboss.cache.config.CloneableConfigurationComponent;
import org.jboss.cache.config.ConfigurationException;
import org.jboss.cache.config.Dynamic;
import org.jboss.cache.factories.ComponentRegistry;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.factories.annotations.Start;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConfigurationComponent
implements CloneableConfigurationComponent {
    private static final long serialVersionUID = 4879873994727821938L;
    protected transient Log log = LogFactory.getLog(this.getClass());
    private transient CacheSPI cache;
    private final Set<ConfigurationComponent> children = Collections.synchronizedSet(new HashSet());
    private transient ComponentRegistry cr;
    private boolean accessible;

    protected ConfigurationComponent() {
    }

    public void passCacheToChildConfig(ConfigurationComponent child) {
        if (child != null) {
            child.setCache(this.cache);
        }
    }

    protected void addChildConfig(ConfigurationComponent child) {
        if (child != null && this.children.add(child)) {
            child.setCache(this.cache);
        }
    }

    protected void addChildConfigs(Collection<? extends ConfigurationComponent> toAdd) {
        if (toAdd != null) {
            for (ConfigurationComponent configurationComponent : toAdd) {
                this.addChildConfig(configurationComponent);
            }
        }
    }

    protected void removeChildConfig(ConfigurationComponent child) {
        this.children.remove(child);
    }

    protected void removeChildConfigs(Collection<? extends ConfigurationComponent> toRemove) {
        if (toRemove != null) {
            for (ConfigurationComponent configurationComponent : toRemove) {
                this.removeChildConfig(configurationComponent);
            }
        }
    }

    protected void replaceChildConfig(ConfigurationComponent oldConfig, ConfigurationComponent newConfig) {
        this.removeChildConfig(oldConfig);
        this.addChildConfig(newConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void replaceChildConfigs(Collection<? extends ConfigurationComponent> oldConfigs, Collection<? extends ConfigurationComponent> newConfigs) {
        Set<ConfigurationComponent> set = this.children;
        synchronized (set) {
            this.removeChildConfigs(oldConfigs);
            this.addChildConfigs(newConfigs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testImmutability(String fieldName) {
        try {
            if (!this.accessible && this.cache != null && this.cache.getCacheStatus() != null && this.cache.getCacheStatus() == CacheStatus.STARTED && !this.getClass().getDeclaredField(fieldName).isAnnotationPresent(Dynamic.class)) {
                throw new ConfigurationException("Attempted to modify a non-Dynamic configuration element [" + fieldName + "] after the cache has started!");
            }
        }
        catch (NoSuchFieldException e) {
            this.log.warn("Field " + fieldName + " not found!!");
        }
        finally {
            this.accessible = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCache(CacheSPI cache) {
        this.cache = cache;
        Set<ConfigurationComponent> set = this.children;
        synchronized (set) {
            for (ConfigurationComponent child : this.children) {
                child.setCache(cache);
            }
        }
    }

    @Inject
    void injectDependencies(ComponentRegistry cr) {
        this.cr = cr;
    }

    @Start
    void start() {
        this.setCache(this.cr.getComponent(CacheSPI.class));
    }

    @Override
    public CloneableConfigurationComponent clone() throws CloneNotSupportedException {
        ConfigurationComponent c = (ConfigurationComponent)super.clone();
        c.setCache(null);
        return c;
    }
}

