/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.config.parsing;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.ConfigurationException;
import org.jboss.cache.config.parsing.RootElementBuilder;
import org.jboss.cache.config.parsing.XmlConfigurationParser;
import org.jboss.cache.config.parsing.XmlConfigurationParser2x;
import org.jboss.cache.util.FileLookup;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheConfigsXmlParser {
    public static final String DOCUMENT_ROOT = "cache-configs";
    public static final String CONFIG_ROOT = "cache-config";
    public static final String QUALIFIED_CONFIG_ROOT = "registry:cache-config";
    public static final String CONFIG_NAME = "name";
    private static final Log log = LogFactory.getLog(CacheConfigsXmlParser.class);

    public Map<String, Configuration> parseConfigs(String fileName) throws CloneNotSupportedException {
        FileLookup fileLookup = new FileLookup();
        InputStream is = fileLookup.lookupFile(fileName);
        if (is == null) {
            throw new ConfigurationException("Unable to find config file " + fileName + " either in classpath or on the filesystem!");
        }
        return this.parseConfigs(is, fileName);
    }

    public Map<String, Configuration> parseConfigs(InputStream stream, String fileName) throws CloneNotSupportedException {
        Element root = this.getDocumentRoot(stream);
        NodeList list = root.getElementsByTagName(CONFIG_ROOT);
        if (!(list != null && list.getLength() != 0 || (list = root.getElementsByTagName(QUALIFIED_CONFIG_ROOT)) != null && list.getLength() != 0)) {
            throw new ConfigurationException("Can't find cache-config or registry:cache-config tag");
        }
        HashMap<String, Configuration> result = new HashMap<String, Configuration>();
        for (int i = 0; i < list.getLength(); ++i) {
            Configuration c;
            Node node = list.item(i);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            String name = element.getAttribute(CONFIG_NAME);
            if (name == null || name.trim().length() == 0) {
                throw new ConfigurationException("Element " + element + " has no name attribute");
            }
            XmlConfigurationParser parser = new XmlConfigurationParser();
            if (parser.isValidElementRoot(element)) {
                c = parser.parseElementIgnoringRoot(element);
            } else {
                if (fileName == null) {
                    log.debug("Detected legacy configuration file format when parsing configuration XML from input stream [" + stream + "].  Migrating to the new (3.x) file format is recommended.  See FAQs for details.");
                } else {
                    log.debug("Detected legacy configuration file format when parsing configuration file [" + fileName + "].  Migrating to the new (3.x) file format is recommended.  See FAQs for details.");
                }
                XmlConfigurationParser2x oldParser = new XmlConfigurationParser2x();
                c = oldParser.parseConfiguration(element);
            }
            c = c.clone();
            result.put(name.trim(), c);
        }
        return result;
    }

    private Element getDocumentRoot(InputStream stream) {
        RootElementBuilder rootElementBuilder = new RootElementBuilder(false);
        return rootElementBuilder.readRoot(stream);
    }
}

