/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.config.parsing;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.config.ConfigurationException;
import org.jboss.util.xml.JBossEntityResolver;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class RootElementBuilder {
    private static final JBossEntityResolver resolver = new JBossEntityResolver();
    public static final Map<String, String> ALLOWED_CORE_NAMESPACES = new HashMap<String, String>(4, 1.0f);
    public static final Map<String, String> ALLOWED_REPO_NAMESPACES = new HashMap<String, String>(4, 1.0f);
    public static final String DEFAULT_CORE_NS = "urn:jboss:jbosscache-core:config:3.2";
    public static final String DEFAULT_REPO_NS = "urn:jboss:jbosscache-core:cache-repo:3.2";
    private static final Log log;
    private ErrorHandler errorHandler;
    private boolean isValidating;
    public static final String VALIDATING_SYSTEM_PROPERTY = "jbosscache.config.validate";

    public RootElementBuilder(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
        this.isValidating = System.getProperty(VALIDATING_SYSTEM_PROPERTY) == null || Boolean.getBoolean(VALIDATING_SYSTEM_PROPERTY);
    }

    public RootElementBuilder(ErrorHandler errorHandler, boolean validating) {
        this.errorHandler = errorHandler;
        this.isValidating = validating;
    }

    public RootElementBuilder() {
        this(new FailureErrorHandler());
    }

    public RootElementBuilder(boolean validating) {
        this(new FailureErrorHandler(), validating);
    }

    private String[] namespaces() {
        ArrayList<String> ns = new ArrayList<String>(ALLOWED_CORE_NAMESPACES.size() + ALLOWED_REPO_NAMESPACES.size());
        for (String candidate : ALLOWED_CORE_NAMESPACES.keySet()) {
            ns.add(candidate);
        }
        for (String candidate : ALLOWED_REPO_NAMESPACES.keySet()) {
            ns.add(candidate);
        }
        return ns.toArray(new String[ns.size()]);
    }

    public Element readRoot(InputStream config) {
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setNamespaceAware(true);
            if (this.isValidating) {
                docBuilderFactory.setValidating(true);
                docBuilderFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
                docBuilderFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", this.namespaces());
            }
            DocumentBuilder parser = docBuilderFactory.newDocumentBuilder();
            parser.setEntityResolver(resolver);
            parser.setErrorHandler(this.errorHandler);
            Document doc = parser.parse(config);
            Element root = doc.getDocumentElement();
            root.normalize();
            return root;
        }
        catch (Exception e) {
            throw new ConfigurationException("Could not parse the config file", e);
        }
    }

    public boolean isValidating() {
        return this.isValidating;
    }

    static {
        ALLOWED_CORE_NAMESPACES.put(DEFAULT_CORE_NS, "jbosscache-config-3.2.xsd");
        ALLOWED_CORE_NAMESPACES.put("urn:jboss:jbosscache-core:config:3.1", "jbosscache-config-3.1.xsd");
        ALLOWED_CORE_NAMESPACES.put("urn:jboss:jbosscache-core:config:3.0", "jbosscache-config-3.0.xsd");
        ALLOWED_REPO_NAMESPACES.put(DEFAULT_REPO_NS, "jbosscache-registry-3.2.xsd");
        ALLOWED_REPO_NAMESPACES.put("urn:jboss:jbosscache-core:cache-repo:3.1", "jbosscache-registry-3.1.xsd");
        ALLOWED_REPO_NAMESPACES.put("urn:jboss:jbosscache-core:cache-repo:3.0", "jbosscache-registry-3.0.xsd");
        for (Map.Entry<String, String> entry : ALLOWED_CORE_NAMESPACES.entrySet()) {
            JBossEntityResolver.registerEntity(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, String> entry : ALLOWED_REPO_NAMESPACES.entrySet()) {
            JBossEntityResolver.registerEntity(entry.getKey(), entry.getValue());
        }
        log = LogFactory.getLog(RootElementBuilder.class);
    }

    private static class FailureErrorHandler
    implements ErrorHandler {
        private FailureErrorHandler() {
        }

        public void warning(SAXParseException exception) throws SAXException {
            this.logAndThrowException(exception);
        }

        public void error(SAXParseException exception) throws SAXException {
            this.logAndThrowException(exception);
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            this.logAndThrowException(exception);
        }

        private void logAndThrowException(SAXParseException exception) {
            log.error("Configuration warning: " + exception.getMessage());
            throw new ConfigurationException("Incorrect configuration file. Use '-Djbosscache.config.validate=false' to disable validation.", exception);
        }
    }
}

