/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.eviction.EvictionQueue;
import org.jboss.cache.eviction.NodeEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LRUQueue
implements EvictionQueue {
    private static Log log = LogFactory.getLog(LRUQueue.class);
    private Map<Fqn, NodeEntry> maxAgeQueue = new LinkedHashMap<Fqn, NodeEntry>();
    private Map<Fqn, NodeEntry> lruQueue = new LinkedHashMap<Fqn, NodeEntry>(16, 0.75f, true);
    private long alternatingCount = 0L;
    private int numElements = 0;

    protected LRUQueue() {
    }

    protected void reorderByLRU(Fqn fqn) {
        this.lruQueue.get(fqn);
    }

    @Override
    public NodeEntry getFirstNodeEntry() {
        NodeEntry ne;
        if (this.alternatingCount % 2L == 0L) {
            ne = this.getFirstLRUNodeEntry();
            if (ne == null) {
                ne = this.getFirstMaxAgeNodeEntry();
            }
        } else {
            ne = this.getFirstMaxAgeNodeEntry();
            if (ne == null) {
                ne = this.getFirstLRUNodeEntry();
            }
        }
        ++this.alternatingCount;
        return ne;
    }

    public NodeEntry getFirstLRUNodeEntry() {
        if (this.lruQueue.size() > 0) {
            return this.lruQueue.values().iterator().next();
        }
        return null;
    }

    public NodeEntry getFirstMaxAgeNodeEntry() {
        if (this.maxAgeQueue.size() > 0) {
            return this.maxAgeQueue.values().iterator().next();
        }
        return null;
    }

    @Override
    public NodeEntry getNodeEntry(Fqn fqn) {
        return this.lruQueue.get(fqn);
    }

    @Override
    public NodeEntry getNodeEntry(String fqn) {
        return this.getNodeEntry(Fqn.fromString(fqn));
    }

    @Override
    public boolean containsNodeEntry(NodeEntry entry) {
        return this.maxAgeQueue.containsKey(entry.getFqn());
    }

    protected void removeNodeEntryFromLRU(NodeEntry entry) {
        Fqn fqn = entry.getFqn();
        this.lruQueue.remove(fqn);
    }

    protected void removeNodeEntryFromMaxAge(NodeEntry entry) {
        Fqn fqn = entry.getFqn();
        this.maxAgeQueue.remove(fqn);
    }

    @Override
    public void removeNodeEntry(NodeEntry entry) {
        if (!this.containsNodeEntry(entry)) {
            return;
        }
        Fqn fqn = entry.getFqn();
        NodeEntry ne1 = this.lruQueue.remove(fqn);
        NodeEntry ne2 = this.maxAgeQueue.remove(fqn);
        if (ne1 == null || ne2 == null) {
            throw new RuntimeException("The queues are out of sync.");
        }
        this.numElements -= ne1.getNumberOfElements();
    }

    @Override
    public void addNodeEntry(NodeEntry entry) {
        if (!this.containsNodeEntry(entry)) {
            Fqn fqn = entry.getFqn();
            entry.queue = this;
            this.maxAgeQueue.put(fqn, entry);
            this.lruQueue.put(fqn, entry);
            this.numElements += entry.getNumberOfElements();
        }
    }

    @Override
    public int getNumberOfNodes() {
        if (log.isTraceEnabled()) {
            log.trace("LRUQUeue.size() = " + this.maxAgeQueue.size());
        }
        return this.maxAgeQueue.size();
    }

    @Override
    public int getNumberOfElements() {
        return this.numElements;
    }

    @Override
    public void clear() {
        this.maxAgeQueue.clear();
        this.lruQueue.clear();
        this.numElements = 0;
    }

    @Override
    public void modifyElementCount(int difference) {
        this.numElements += difference;
    }

    @Override
    public Iterator<NodeEntry> iterator() {
        return this.lruQueue.values().iterator();
    }

    protected final Iterator<NodeEntry> iterateMaxAgeQueue() {
        return this.maxAgeQueue.values().iterator();
    }

    protected final Iterator<NodeEntry> iterateLRUQueue() {
        return this.lruQueue.values().iterator();
    }
}

