/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.ArrayList;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DataContainer;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.NodeFactory;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.commands.write.MoveCommand;
import org.jboss.cache.commands.write.PutDataMapCommand;
import org.jboss.cache.commands.write.PutForExternalReadCommand;
import org.jboss.cache.commands.write.PutKeyValueCommand;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.factories.annotations.Start;
import org.jboss.cache.interceptors.OptimisticInterceptor;
import org.jboss.cache.notifications.Notifier;
import org.jboss.cache.optimistic.DataVersion;
import org.jboss.cache.optimistic.DefaultDataVersion;
import org.jboss.cache.optimistic.TransactionWorkspace;
import org.jboss.cache.optimistic.WorkspaceNode;
import org.jboss.cache.transaction.GlobalTransaction;

@Deprecated
public class OptimisticCreateIfNotExistsInterceptor
extends OptimisticInterceptor {
    private NodeFactory nodeFactory;
    private DataContainer dataContainer;
    private CacheSPI cache;
    private long lockAcquisitionTimeout;

    @Inject
    void injectDependencies(NodeFactory nodeFactory, DataContainer dataContainer, CacheSPI cacheSPI) {
        this.nodeFactory = nodeFactory;
        this.dataContainer = dataContainer;
        this.cache = cacheSPI;
    }

    @Start
    void init() {
        this.lockAcquisitionTimeout = this.configuration.getLockAcquisitionTimeout();
    }

    public Object visitPutDataMapCommand(InvocationContext ctx, PutDataMapCommand command) throws Throwable {
        this.createNode(ctx, command.getFqn(), false);
        return this.invokeNextInterceptor(ctx, command);
    }

    public Object visitPutForExternalReadCommand(InvocationContext ctx, PutForExternalReadCommand command) throws Throwable {
        this.createNode(ctx, command.getFqn(), false);
        return this.invokeNextInterceptor(ctx, command);
    }

    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        this.createNode(ctx, command.getFqn(), false);
        return this.invokeNextInterceptor(ctx, command);
    }

    public Object visitMoveCommand(InvocationContext ctx, MoveCommand command) throws Throwable {
        ArrayList<Fqn> fqns = new ArrayList<Fqn>();
        fqns.add(command.getTo());
        NodeSPI node = this.dataContainer.peek(command.getFqn(), true, true);
        this.greedyGetFqns(fqns, node, command.getTo());
        if (this.trace) {
            this.log.trace("Adding Fqns " + fqns + " for a move() operation.");
        }
        for (Fqn f : fqns) {
            this.createNode(ctx, f, true);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    private void createNode(InvocationContext ctx, Fqn targetFqn, boolean suppressNotification) throws CacheException {
        if (this.dataContainer.peek(targetFqn, false, false) != null) {
            return;
        }
        if (targetFqn == null) {
            return;
        }
        boolean debug = this.log.isDebugEnabled();
        GlobalTransaction gtx = this.getGlobalTransaction(ctx);
        TransactionWorkspace workspace = this.getTransactionWorkspace(ctx);
        ArrayList<Fqn> nodesCreated = new ArrayList<Fqn>();
        DataVersion version = null;
        if (ctx.getOptionOverrides() != null && ctx.getOptionOverrides().getDataVersion() != null) {
            version = ctx.getOptionOverrides().getDataVersion();
            workspace.setVersioningImplicit(false);
        }
        WorkspaceNode workspaceNode = workspace.getNode(Fqn.ROOT);
        if (debug) {
            this.log.debug("GlobalTransaction: " + gtx + "; Root: " + workspaceNode);
        }
        if (workspaceNode == null) {
            NodeSPI node = this.dataContainer.getRoot();
            workspaceNode = this.lockAndCreateWorkspaceNode(this.nodeFactory, node, workspace, gtx, this.lockAcquisitionTimeout);
            workspace.addNode(workspaceNode);
            this.log.debug("Created root node in workspace.");
        } else {
            this.log.debug("Found root node in workspace.");
        }
        int targetFqnSize = targetFqn.size();
        int currentDepth = 1;
        for (Object childName : targetFqn.peekElements()) {
            WorkspaceNode peekInWorkspace;
            NodeSPI currentNode;
            boolean isTargetFqn = currentDepth == targetFqnSize;
            ++currentDepth;
            if (debug) {
                this.log.debug("Attempting to get child " + childName);
            }
            if ((currentNode = workspaceNode.getNode().getChildDirect(childName)) == null && (peekInWorkspace = workspace.getNode(Fqn.fromRelativeElements(workspaceNode.getFqn(), childName))) != null && peekInWorkspace.isCreated()) {
                currentNode = peekInWorkspace.getNode();
                if (peekInWorkspace.isRemoved()) {
                    peekInWorkspace.setRemoved(false);
                    workspaceNode.addChild(peekInWorkspace);
                }
            }
            if (currentNode == null) {
                if (this.trace) {
                    this.log.trace("Creating new child, since it doesn't exist in the cache.");
                }
                if (workspaceNode.isRemoved()) {
                    if (this.trace) {
                        this.log.trace("Parent node doesn't exist in workspace or has been deleted.  Adding to workspace.");
                    }
                    workspace.addNode(workspaceNode);
                    if (!(workspaceNode.getVersion() instanceof DefaultDataVersion)) {
                        workspaceNode.setVersioningImplicit(false);
                    }
                } else if (this.trace) {
                    this.log.trace("Parent node exists: " + workspaceNode);
                }
                DataVersion versionToPassIn = null;
                if (isTargetFqn && !workspace.isVersioningImplicit()) {
                    versionToPassIn = version;
                }
                NodeSPI newUnderlyingChildNode = workspaceNode.createChild(childName, workspaceNode.getNode(), this.cache, versionToPassIn);
                workspaceNode = this.lockAndCreateWorkspaceNode(this.nodeFactory, newUnderlyingChildNode, workspace, gtx, this.lockAcquisitionTimeout);
                workspaceNode.setVersioningImplicit(versionToPassIn == null || !isTargetFqn);
                if (this.trace) {
                    this.log.trace("setting versioning of " + workspaceNode.getFqn() + " to be " + (workspaceNode.isVersioningImplicit() ? "implicit" : "explicit"));
                }
                workspace.addNode(workspaceNode);
                workspaceNode.markAsCreated();
                nodesCreated.add(workspaceNode.getFqn());
                continue;
            }
            workspaceNode = workspace.getNode(currentNode.getFqn());
            if (workspaceNode == null) {
                if (this.trace) {
                    this.log.trace("Child node " + currentNode.getFqn() + " doesn't exist in workspace or has been deleted.  Adding to workspace in gtx " + gtx);
                }
                workspaceNode = this.lockAndCreateWorkspaceNode(this.nodeFactory, currentNode, workspace, gtx, this.lockAcquisitionTimeout);
                if (!currentNode.isValid()) {
                    workspaceNode.markAsCreated();
                }
                if (isTargetFqn && !workspace.isVersioningImplicit()) {
                    workspaceNode.setVersion(version);
                    workspaceNode.setVersioningImplicit(false);
                } else {
                    workspaceNode.setVersioningImplicit(true);
                }
                if (this.trace) {
                    this.log.trace("setting versioning of " + workspaceNode.getFqn() + " to be " + (workspaceNode.isVersioningImplicit() ? "implicit" : "explicit"));
                }
                workspace.addNode(workspaceNode);
                continue;
            }
            if (workspaceNode.isRemoved()) {
                if (this.trace) {
                    this.log.trace("Found node but it is deleted in this workspace.  Needs resurrecting.");
                }
                this.undeleteWorkspaceNode(workspaceNode, workspace);
                continue;
            }
            if (!this.trace) continue;
            this.log.trace("Found child node in the workspace: " + currentNode);
        }
        if (!suppressNotification && nodesCreated.size() > 0) {
            Notifier n = this.cache.getNotifier();
            for (Fqn temp : nodesCreated) {
                n.notifyNodeCreated(temp, true, ctx);
                n.notifyNodeCreated(temp, false, ctx);
                if (!this.trace) continue;
                this.log.trace("Notifying cache of node created in workspace " + temp);
            }
        }
    }
}

