/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.LinkedList;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OrderedSynchronizationHandler
implements Synchronization {
    static final Log log = LogFactory.getLog(OrderedSynchronizationHandler.class);
    private Transaction tx = null;
    private final LinkedList<Synchronization> handlers = new LinkedList();

    public OrderedSynchronizationHandler(Transaction tx) throws SystemException, RollbackException {
        this.tx = tx;
        tx.registerSynchronization(this);
    }

    public void registerAtHead(Synchronization handler) {
        this.register(handler, true);
    }

    public void registerAtTail(Synchronization handler) {
        this.register(handler, false);
    }

    void register(Synchronization handler, boolean head) {
        if (handler != null && !this.handlers.contains(handler)) {
            if (head) {
                this.handlers.addFirst(handler);
            } else {
                this.handlers.addLast(handler);
            }
        }
    }

    public void beforeCompletion() {
        for (Synchronization sync : this.handlers) {
            sync.beforeCompletion();
        }
    }

    public void afterCompletion(int status) {
        RuntimeException exceptionInAfterCompletion = null;
        for (Synchronization sync : this.handlers) {
            try {
                sync.afterCompletion(status);
            }
            catch (Throwable t) {
                log.error("failed calling afterCompletion() on " + sync, t);
                exceptionInAfterCompletion = (RuntimeException)t;
            }
        }
        if (exceptionInAfterCompletion != null) {
            throw exceptionInAfterCompletion;
        }
    }

    public String toString() {
        return "tx=" + this.getTxAsString() + ", handlers=" + this.handlers;
    }

    private String getTxAsString() {
        if (this.tx == null) {
            return null;
        }
        return this.tx.getClass().getName() + "@" + System.identityHashCode(this.tx);
    }
}

