/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.lock;

import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.factories.annotations.NonVolatile;
import org.jboss.cache.factories.annotations.Start;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.lock.LockStrategy;
import org.jboss.cache.lock.LockStrategyNone;
import org.jboss.cache.lock.LockStrategyReadCommitted;
import org.jboss.cache.lock.LockStrategyReadUncommitted;
import org.jboss.cache.lock.LockStrategyRepeatableRead;
import org.jboss.cache.lock.LockStrategySerializable;

@NonVolatile
public class LockStrategyFactory {
    private IsolationLevel lockingLevel = IsolationLevel.REPEATABLE_READ;
    private Configuration configuration;

    @Inject
    public void injectDependencies(Configuration configuration) {
        this.configuration = configuration;
    }

    @Start(priority=1)
    public void start() {
        this.lockingLevel = this.configuration.getNodeLockingScheme() == Configuration.NodeLockingScheme.OPTIMISTIC ? IsolationLevel.REPEATABLE_READ : this.configuration.getIsolationLevel();
    }

    public LockStrategy getLockStrategy() {
        return this.getLockStrategy(this.lockingLevel);
    }

    public LockStrategy getLockStrategy(IsolationLevel lockingLevel) {
        if (lockingLevel == null) {
            return new LockStrategyNone();
        }
        switch (lockingLevel) {
            case NONE: {
                return new LockStrategyNone();
            }
            case SERIALIZABLE: {
                return new LockStrategySerializable();
            }
            case READ_UNCOMMITTED: {
                return new LockStrategyReadUncommitted();
            }
            case READ_COMMITTED: {
                return new LockStrategyReadCommitted();
            }
        }
        return new LockStrategyRepeatableRead();
    }

    public void setIsolationLevel(IsolationLevel level) {
        this.lockingLevel = level;
    }
}

