/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.mvcc;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheException;
import org.jboss.cache.DataContainer;
import org.jboss.cache.Fqn;
import org.jboss.cache.InternalNode;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.NodeFactory;
import org.jboss.cache.NodeNotExistsException;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.factories.annotations.NonVolatile;
import org.jboss.cache.factories.annotations.Start;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.lock.LockManager;
import org.jboss.cache.lock.LockType;
import org.jboss.cache.lock.TimeoutException;
import org.jboss.cache.mvcc.NodeReference;
import org.jboss.cache.mvcc.ReadCommittedNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonVolatile
public class MVCCNodeHelper {
    DataContainer dataContainer;
    NodeFactory nodeFactory;
    private static final Log log = LogFactory.getLog(MVCCNodeHelper.class);
    private static final boolean trace = log.isTraceEnabled();
    private long defaultLockAcquisitionTimeout;
    private LockManager lockManager;
    private Configuration configuration;
    private boolean writeSkewCheck;
    private boolean lockParentForChildInsertRemove;

    @Inject
    public void injectDependencies(DataContainer dataContainer, NodeFactory nodeFactory, LockManager lockManager, Configuration configuration) {
        this.nodeFactory = nodeFactory;
        this.dataContainer = dataContainer;
        this.configuration = configuration;
        this.lockManager = lockManager;
    }

    @Start
    public void start() {
        this.defaultLockAcquisitionTimeout = this.configuration.getLockAcquisitionTimeout();
        this.writeSkewCheck = this.configuration.isWriteSkewCheck();
        this.lockParentForChildInsertRemove = this.configuration.isLockParentForChildInsertRemove();
    }

    public void wrapNodesForReading(InvocationContext ctx, Collection<Fqn> fqns) throws InterruptedException {
        boolean forceWriteLock = ctx.getOptionOverrides().isForceWriteLock();
        for (Fqn f : fqns) {
            this.wrapNodeForReading(ctx, f, forceWriteLock, true);
        }
    }

    public NodeSPI wrapNodeForReading(InvocationContext ctx, Fqn fqn, boolean putInContext) throws InterruptedException {
        return this.wrapNodeForReading(ctx, fqn, ctx.getOptionOverrides().isForceWriteLock(), putInContext);
    }

    private NodeSPI wrapNodeForReading(InvocationContext ctx, Fqn f, boolean writeLockForced, boolean putInContext) throws InterruptedException {
        if (writeLockForced) {
            if (trace) {
                log.trace("Forcing lock on reading node " + f);
            }
            return this.wrapNodeForWriting(ctx, f, true, false, false, false, false);
        }
        NodeSPI n = ctx.lookUpNode(f);
        if (n == null) {
            if (trace) {
                log.trace("Node " + f + " is not in context, fetching from container.");
            }
            InternalNode[] nodes = this.dataContainer.peekInternalNodeAndDirectParent(f, false);
            ReadCommittedNode wrapped = this.nodeFactory.createWrappedNode(nodes[0], nodes[1]);
            if (putInContext && wrapped != null) {
                ctx.putLookedUpNode(f, wrapped);
            }
            return wrapped;
        }
        if (trace) {
            log.trace("Node " + f + " is already in context.");
        }
        return n;
    }

    private boolean acquireLock(InvocationContext ctx, Fqn fqn) throws InterruptedException, TimeoutException {
        if (!ctx.hasLock(fqn)) {
            if (!this.lockManager.lockAndRecord(fqn, LockType.WRITE, ctx)) {
                Object owner = this.lockManager.getWriteOwner(fqn);
                throw new TimeoutException("Unable to acquire lock on Fqn [" + fqn + "] after [" + ctx.getLockAcquisitionTimeout(this.defaultLockAcquisitionTimeout) + "] milliseconds for requestor [" + this.lockManager.getLockOwner(ctx) + "]! Lock held by [" + owner + "]");
            }
            return true;
        }
        return false;
    }

    public ReadCommittedNode wrapNodeForWriting(InvocationContext context, Fqn fqn, boolean lockForWriting, boolean createIfAbsent, boolean includeInvalidNodes, boolean forRemoval, boolean force) throws InterruptedException {
        return this.wrapNodeForWriting(context, fqn, lockForWriting, createIfAbsent, includeInvalidNodes, forRemoval, force, false);
    }

    public ReadCommittedNode wrapNodeForWriting(InvocationContext context, Fqn fqn, boolean lockForWriting, boolean createIfAbsent, boolean includeInvalidNodes, boolean forRemoval, boolean force, boolean childIsNull) throws InterruptedException {
        Fqn parentFqn = null;
        ReadCommittedNode n = (ReadCommittedNode)context.lookUpNode(fqn);
        if (createIfAbsent && n != null && n.isNullNode()) {
            n = null;
        }
        if (n != null) {
            if (lockForWriting && this.acquireLock(context, fqn)) {
                n.markForUpdate(this.dataContainer, this.writeSkewCheck);
            }
            if (n.isDeleted() && createIfAbsent) {
                if (trace) {
                    log.trace("Node is deleted in current scope.  Need to un-delete.");
                }
                n.markAsDeleted(false);
                n.setValid(true, false);
                n.clearData();
                this.wrapNodeForWriting(context, fqn.getParent(), true, true, includeInvalidNodes, false, force);
            }
        } else {
            InternalNode[] nodes = this.dataContainer.peekInternalNodeAndDirectParent(fqn, includeInvalidNodes);
            InternalNode in = nodes[0];
            if (in != null) {
                boolean needToCopy = false;
                if (lockForWriting && this.acquireLock(context, fqn)) {
                    needToCopy = true;
                    nodes = this.dataContainer.peekInternalNodeAndDirectParent(fqn, includeInvalidNodes);
                    in = nodes[0];
                }
                if (in != null) {
                    n = this.nodeFactory.createWrappedNode(in, nodes[1]);
                    context.putLookedUpNode(fqn, n);
                    if (needToCopy) {
                        n.markForUpdate(this.dataContainer, this.writeSkewCheck);
                    }
                } else if (createIfAbsent) {
                    n = this.createAbsentNode(parentFqn, fqn, context);
                }
            } else if (createIfAbsent) {
                n = this.createAbsentNode(parentFqn, fqn, context);
            }
        }
        if (n == null && force) {
            parentFqn = fqn.getParent();
            if (this.isParentLockNeeded(parentFqn, context) && !childIsNull) {
                this.wrapNodeForWriting(context, parentFqn, true, false, includeInvalidNodes, false, force, true);
            }
            this.acquireLock(context, fqn);
        }
        if ((n != null || force) && forRemoval && (parentFqn == null ? (parentFqn = fqn.getParent()) : parentFqn) != null && this.isParentLockNeeded(parentFqn, context) && !childIsNull) {
            this.wrapNodeForWriting(context, parentFqn, true, false, includeInvalidNodes, false, force, n == null);
        }
        return n;
    }

    private ReadCommittedNode createAbsentNode(Fqn parentFqn, Fqn fqn, InvocationContext context) throws InterruptedException {
        parentFqn = fqn.getParent();
        ReadCommittedNode parent = this.wrapNodeForWriting(context, parentFqn, false, true, false, false, false);
        boolean parentLockNeeded = this.isParentLockNeeded(parent.getDelegationTarget());
        if (parentLockNeeded && this.acquireLock(context, parentFqn)) {
            ReadCommittedNode parentRCN = (ReadCommittedNode)context.lookUpNode(parentFqn);
            parentRCN.markForUpdate(this.dataContainer, this.writeSkewCheck);
        }
        this.acquireLock(context, fqn);
        InternalNode in = this.nodeFactory.createChildNode(fqn, null, context, false);
        ReadCommittedNode n = this.nodeFactory.createWrappedNode(in, parent.getDelegationTarget());
        n.setCreated(true);
        n.setDataLoaded(true);
        context.putLookedUpNode(fqn, n);
        n.markForUpdate(this.dataContainer, this.writeSkewCheck);
        return n;
    }

    public NodeSPI wrapNodeForWriting(InvocationContext context, InternalNode node, InternalNode parent) throws InterruptedException {
        Fqn fqn = node.getFqn();
        NodeSPI n = context.lookUpNode(fqn);
        if (n != null) {
            if (this.acquireLock(context, fqn)) {
                n.markForUpdate(this.dataContainer, this.writeSkewCheck);
            }
            if (trace) {
                log.trace("Retrieving wrapped node " + fqn);
            }
        } else {
            boolean needToCopy = false;
            if (this.acquireLock(context, fqn)) {
                needToCopy = true;
            }
            n = this.nodeFactory.createWrappedNode(node, parent);
            context.putLookedUpNode(fqn, n);
            if (needToCopy) {
                n.markForUpdate(this.dataContainer, this.writeSkewCheck);
            }
        }
        return n;
    }

    public List<Fqn> wrapNodesRecursivelyForRemoval(InvocationContext ctx, Fqn fqn) throws InterruptedException {
        boolean needToCopyNode;
        ReadCommittedNode node;
        if (fqn.isRoot()) {
            throw new CacheException("Attempting to remove Fqn.ROOT!");
        }
        Fqn parentFqn = fqn.getParent();
        boolean needToCopyParent = false;
        boolean parentLockNeeded = this.isParentLockNeeded(parentFqn, ctx);
        ReadCommittedNode parent = null;
        if (parentLockNeeded) {
            needToCopyParent = this.acquireLock(ctx, parentFqn);
            parent = this.wrapAndPutInContext(ctx, parentFqn, needToCopyParent);
        }
        if ((node = this.wrapAndPutInContext(ctx, fqn, needToCopyNode = this.acquireLock(ctx, fqn))) == null || node.isNullNode()) {
            return Collections.emptyList();
        }
        if (parentLockNeeded && (needToCopyNode || needToCopyParent)) {
            if (parent == null) {
                throw new NodeNotExistsException("Parent node " + parentFqn + " does not exist!");
            }
            NodeReference ref = null;
            ref = this.configuration.getIsolationLevel() == IsolationLevel.READ_COMMITTED ? new NodeReference(node.getDelegationTarget()) : node.getDelegationTarget();
            parent.getDelegationTarget().addChild(ref);
        }
        ConcurrentMap childMap = node.getDelegationTarget().getChildrenMap();
        LinkedList<Fqn> fqnsToBeRemoved = new LinkedList<Fqn>();
        fqnsToBeRemoved.add(fqn);
        if (!childMap.isEmpty()) {
            for (InternalNode n : childMap.values()) {
                this.lockForWritingRecursive(n.getFqn(), ctx, fqnsToBeRemoved);
            }
        }
        return fqnsToBeRemoved;
    }

    private void lockForWritingRecursive(Fqn fqn, InvocationContext ctx, List<Fqn> fqnList) throws InterruptedException {
        ReadCommittedNode rcn;
        this.acquireLock(ctx, fqn);
        if (fqnList != null) {
            fqnList.add(fqn);
        }
        if ((rcn = this.wrapNodeForWriting(ctx, fqn, true, false, true, false, false)) != null) {
            rcn.markForUpdate(this.dataContainer, this.writeSkewCheck);
            ConcurrentMap children = rcn.getDelegationTarget().getChildrenMap();
            for (InternalNode child : children.values()) {
                this.lockForWritingRecursive(child, rcn.getInternalParent(), ctx, fqnList);
            }
        }
    }

    private void lockForWritingRecursive(InternalNode node, InternalNode parent, InvocationContext ctx, List<Fqn> fqnList) throws InterruptedException {
        NodeSPI rcn;
        Fqn fqn = node.getFqn();
        this.acquireLock(ctx, fqn);
        if (fqnList != null) {
            fqnList.add(fqn);
        }
        if ((rcn = this.wrapNodeForWriting(ctx, node, parent)) != null) {
            rcn.markForUpdate(this.dataContainer, this.writeSkewCheck);
            ConcurrentMap children = node.getChildrenMap();
            for (InternalNode child : children.values()) {
                this.lockForWritingRecursive(child, node, ctx, fqnList);
            }
        }
    }

    private ReadCommittedNode wrapAndPutInContext(InvocationContext ctx, Fqn fqn, boolean forUpdate) {
        ReadCommittedNode node = (ReadCommittedNode)ctx.lookUpNode(fqn);
        if (node == null || node.isNullNode()) {
            InternalNode[] nodes = this.dataContainer.peekInternalNodeAndDirectParent(fqn, false);
            node = this.nodeFactory.createWrappedNodeForRemoval(fqn, nodes[0], nodes[1]);
            ctx.putLookedUpNode(fqn, node);
        }
        if (forUpdate && node != null && !node.isChanged()) {
            node.markForUpdate(this.dataContainer, this.writeSkewCheck);
        }
        return node;
    }

    private boolean isParentLockNeeded(InternalNode parent) {
        return this.lockParentForChildInsertRemove || parent != null && parent.isLockForChildInsertRemove();
    }

    private boolean isParentLockNeeded(Fqn parent, InvocationContext ctx) {
        ReadCommittedNode parentNodeTmp = (ReadCommittedNode)ctx.lookUpNode(parent);
        InternalNode in = parentNodeTmp == null ? this.dataContainer.peekInternalNode(parent, true) : parentNodeTmp.getDelegationTarget();
        return this.isParentLockNeeded(in);
    }
}

