/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.statetransfer;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.InternalNode;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.RegionEmptyException;
import org.jboss.cache.RegionManager;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.factories.annotations.Start;
import org.jboss.cache.loader.CacheLoaderManager;
import org.jboss.cache.marshall.InactiveRegionException;
import org.jboss.cache.marshall.Marshaller;
import org.jboss.cache.marshall.NodeData;
import org.jboss.cache.marshall.NodeDataMarker;
import org.jboss.cache.statetransfer.StateTransferGenerator;
import org.jboss.cache.statetransfer.StateTransferIntegrator;
import org.jboss.cache.statetransfer.StateTransferManager;
import org.jboss.cache.util.CachePrinter;

public class DefaultStateTransferManager
implements StateTransferManager {
    protected static final Log log = LogFactory.getLog(DefaultStateTransferManager.class);
    protected static final boolean trace = log.isTraceEnabled();
    public static final NodeData STREAMING_DELIMITER_NODE = new NodeDataMarker();
    public static final String PARTIAL_STATE_DELIMITER = "_PARTIAL_STATE_DELIMITER";
    protected CacheSPI cache;
    protected Marshaller marshaller;
    protected RegionManager regionManager;
    protected Configuration configuration;
    private CacheLoaderManager cacheLoaderManager;
    boolean fetchTransientState;
    boolean fetchPersistentState;
    protected long stateRetrievalTimeout;
    protected StateTransferIntegrator integrator;
    protected StateTransferGenerator generator;

    @Inject
    public void injectDependencies(CacheSPI cache, Marshaller marshaller, RegionManager regionManager, Configuration configuration, CacheLoaderManager cacheLoaderManager, StateTransferIntegrator integrator, StateTransferGenerator generator) {
        this.cache = cache;
        this.regionManager = regionManager;
        this.marshaller = marshaller;
        this.configuration = configuration;
        this.cacheLoaderManager = cacheLoaderManager;
        this.integrator = integrator;
        this.generator = generator;
    }

    @Start(priority=14)
    public void start() {
        this.fetchTransientState = this.configuration.isFetchInMemoryState();
        this.fetchPersistentState = this.cacheLoaderManager != null && this.cacheLoaderManager.isFetchPersistentState() && !this.configuration.getCacheLoaderConfig().isShared();
        this.stateRetrievalTimeout = this.configuration.getStateRetrievalTimeout();
    }

    public void getState(ObjectOutputStream out, Fqn fqn, long timeout, boolean force, boolean suppressErrors) throws Exception {
        boolean canProvideState;
        boolean bl = canProvideState = this.cache.getCacheStatus().allowInvocations() && !this.regionManager.isInactive(fqn) && this.cache.peek(fqn, false) != null;
        if (trace) {
            log.trace("Can provide state? " + canProvideState);
        }
        if (canProvideState && (this.fetchPersistentState || this.fetchTransientState)) {
            InternalNode subtreeRoot;
            this.marshaller.objectToObjectStream(true, out);
            long startTime = System.currentTimeMillis();
            InternalNode internalNode = subtreeRoot = fqn.isRoot() ? this.cache.getRoot().getDelegationTarget() : this.cache.getNode(fqn).getDelegationTarget();
            if (log.isDebugEnabled()) {
                log.debug("Generating in-memory (transient) state for subtree " + fqn);
            }
            this.generator.generateState(out, subtreeRoot, this.fetchTransientState, this.fetchPersistentState, suppressErrors);
            if (log.isDebugEnabled()) {
                log.debug("Successfully generated state in " + CachePrinter.prettyPrint(System.currentTimeMillis() - startTime));
            }
        } else {
            this.marshaller.objectToObjectStream(false, out);
            CacheException e = null;
            if (!canProvideState) {
                String exceptionMessage = "Cache instance at " + this.cache.getLocalAddress() + " cannot provide state for fqn " + fqn + ".";
                if (!this.cache.getCacheStatus().allowInvocations()) {
                    exceptionMessage = " [Cache is not in the correct status]";
                }
                if (this.regionManager.isInactive(fqn)) {
                    exceptionMessage = exceptionMessage + " Region for fqn " + fqn + " is inactive.";
                    e = new InactiveRegionException(exceptionMessage);
                }
                if (this.cache.peek(fqn, false, false) == null) {
                    e = new RegionEmptyException();
                }
            }
            if (!this.fetchPersistentState && !this.fetchTransientState) {
                e = new CacheException("Cache instance at " + this.cache.getLocalAddress() + " is not configured to provide state");
            }
            this.marshaller.objectToObjectStream(e, out);
            if (e != null) {
                throw e;
            }
        }
    }

    public void setState(ObjectInputStream in, Fqn targetRoot) throws Exception {
        if (trace) {
            log.trace("Setting state on Fqn root " + targetRoot);
        }
        this.cache.getInvocationContext().getOptionOverrides().setSkipCacheStatusCheck(true);
        NodeSPI target = this.cache.getNode(targetRoot);
        if (target == null) {
            if (trace) {
                log.trace("Target node not found, creating it");
            }
            this.cache.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
            this.cache.getInvocationContext().getOptionOverrides().setSkipCacheStatusCheck(true);
            this.cache.put(targetRoot, null);
            this.cache.getInvocationContext().getOptionOverrides().setSkipCacheStatusCheck(true);
            target = this.cache.getNode(targetRoot);
        }
        Object o = this.marshaller.objectFromObjectStream(in);
        Boolean hasState = (Boolean)o;
        if (trace) {
            log.trace("Do we have state to integrate? " + hasState);
        }
        if (!hasState.booleanValue()) {
            throw new CacheException("Cache instance at " + this.cache.getLocalAddress() + " cannot integrate state since state provider could not provide state due to " + this.marshaller.objectFromObjectStream(in));
        }
        this.setState(in, target);
    }

    protected void setState(ObjectInputStream state, NodeSPI targetRoot) throws Exception {
        long startTime = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug("starting state integration at node " + targetRoot + ".  Fetch Persistent State = " + this.fetchPersistentState);
        }
        this.integrator.integrateState(state, targetRoot.getDelegationTarget(), targetRoot.getFqn(), this.fetchPersistentState);
        if (log.isDebugEnabled()) {
            log.debug("successfully integrated state in " + CachePrinter.prettyPrint(System.currentTimeMillis() - startTime));
        }
    }
}

