/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.statetransfer;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.Node;
import org.jboss.cache.NodeFactory;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.Region;
import org.jboss.cache.buddyreplication.BuddyManager;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.eviction.EvictionEvent;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.factories.annotations.Start;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.loader.CacheLoaderManager;
import org.jboss.cache.marshall.NodeData;
import org.jboss.cache.marshall.NodeDataExceptionMarker;
import org.jboss.cache.marshall.NodeDataMarker;
import org.jboss.cache.notifications.event.NodeModifiedEvent;
import org.jboss.cache.statetransfer.StateTransferIntegrator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class LegacyStateTransferIntegrator
implements StateTransferIntegrator {
    private static final Log log = LogFactory.getLog(LegacyStateTransferIntegrator.class);
    private static final boolean trace = log.isTraceEnabled();
    private CacheSPI cache;
    private NodeFactory factory;
    private Set<Fqn> internalFqns;
    private Configuration cfg;
    private boolean usePut;

    @Inject
    public void inject(CacheSPI<?, ?> cache, NodeFactory nodefactory, Configuration cfg) {
        this.cache = cache;
        this.factory = nodefactory;
        this.cfg = cfg;
    }

    @Start(priority=14)
    public void start() {
        this.internalFqns = this.cache.getInternalFqns();
        this.usePut = this.cfg.getCacheLoaderConfig() != null && !this.cfg.getCacheLoaderConfig().isFetchPersistentState() && !this.cfg.getCacheLoaderConfig().isShared();
    }

    @Override
    public void integrateState(ObjectInputStream ois, Object target, Fqn targetFqn, boolean integratePersistentState) throws Exception {
        short version = (Short)this.cache.getMarshaller().objectFromObjectStream(ois);
        log.info("Using version " + version);
        this.integrateTransientState(ois, (NodeSPI)target);
        if (trace) {
            log.trace("Reading marker for nonexistent associated state");
        }
        this.cache.getMarshaller().objectFromObjectStream(ois);
        if (integratePersistentState) {
            this.integratePersistentState(ois, targetFqn);
        }
    }

    protected void integrateTransientState(ObjectInputStream in, NodeSPI target) throws Exception {
        boolean transientSet = false;
        try {
            if (log.isTraceEnabled()) {
                log.trace("integrating transient state for " + target);
            }
            this.integrateTransientState(target, in);
            transientSet = true;
            if (log.isTraceEnabled()) {
                log.trace("transient state successfully integrated");
            }
            this.notifyAllNodesCreated(this.cache.getInvocationContext(), target);
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
        finally {
            if (!transientSet) {
                target.clearDataDirect();
                target.removeChildrenDirect();
            }
        }
    }

    protected void integratePersistentState(ObjectInputStream in, Fqn targetFqn) throws Exception {
        CacheLoaderManager loaderManager;
        CacheLoader loader;
        if (trace) {
            log.trace("Reading persistent state from stream");
        }
        CacheLoader cacheLoader = loader = (loaderManager = this.cache.getCacheLoaderManager()) == null ? null : loaderManager.getCacheLoader();
        if (loader == null) {
            if (log.isTraceEnabled()) {
                log.trace("cache loader is null, will not attempt to integrate persistent state");
            }
        } else {
            if (log.isTraceEnabled()) {
                log.trace("integrating persistent state using " + loader.getClass().getName());
            }
            boolean persistentSet = false;
            try {
                if (targetFqn.isRoot()) {
                    loader.storeEntireState(in);
                } else {
                    loader.storeState(targetFqn, in);
                }
                persistentSet = true;
            }
            catch (ClassCastException cce) {
                log.error("Failed integrating persistent state. One of cacheloaders is not adhering to state stream format. See JBCACHE-738.");
                throw cce;
            }
            finally {
                if (!persistentSet) {
                    log.warn("persistent state integration failed, removing all nodes from loader");
                    loader.remove(targetFqn);
                } else if (log.isTraceEnabled()) {
                    log.trace("persistent state integrated successfully");
                }
            }
        }
    }

    private void notifyAllNodesCreated(InvocationContext ctx, NodeSPI curr) {
        if (curr == null) {
            return;
        }
        ctx.setOriginLocal(false);
        this.cache.getNotifier().notifyNodeCreated(curr.getFqn(), true, ctx);
        this.cache.getNotifier().notifyNodeCreated(curr.getFqn(), false, ctx);
        if (!curr.getKeysDirect().isEmpty()) {
            this.cache.getNotifier().notifyNodeModified(curr.getFqn(), true, NodeModifiedEvent.ModificationType.PUT_MAP, Collections.emptyMap(), ctx);
            this.cache.getNotifier().notifyNodeModified(curr.getFqn(), false, NodeModifiedEvent.ModificationType.PUT_MAP, curr.getDataDirect(), ctx);
        }
        ctx.setOriginLocal(true);
        Set children = curr.getChildrenDirect();
        for (NodeSPI n : children) {
            this.notifyAllNodesCreated(ctx, n);
        }
    }

    private void integrateTransientState(NodeSPI target, ObjectInputStream in) throws Exception {
        if (trace) {
            log.trace("Reading transient state from stream");
        }
        target.removeChildrenDirect();
        List<NodeData> list = this.readNodesAsList(in);
        if (list != null) {
            NodeData nd;
            Iterator<NodeData> nodeDataIterator = list.iterator();
            if (nodeDataIterator.hasNext() && (nd = nodeDataIterator.next()) != null && !nd.isMarker()) {
                Map attributes = nd.getAttributes();
                if (this.usePut) {
                    this.cache.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
                    this.cache.getInvocationContext().getOptionOverrides().setSkipCacheStatusCheck(true);
                    target.clearData();
                    this.cache.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
                    this.cache.getInvocationContext().getOptionOverrides().setSkipCacheStatusCheck(true);
                    target.putAll(attributes);
                } else {
                    target.setInternalState(attributes);
                }
                Fqn tferFqn = nd.getFqn();
                Fqn tgtFqn = target.getFqn();
                boolean move = tgtFqn.isChildOrEquals(BuddyManager.BUDDY_BACKUP_SUBTREE_FQN) && !tferFqn.isChildOrEquals(tgtFqn);
                int offset = move ? tgtFqn.size() - tferFqn.size() : 0;
                this.integrateStateTransferChildren(target, offset, nodeDataIterator);
                this.integrateRetainedNodes(target);
            }
            target.setDataLoaded(false);
            target.setChildrenLoaded(false);
            if (trace) {
                log.trace("Reading marker from stream");
            }
            this.cache.getMarshaller().objectFromObjectStream(in);
        }
    }

    private List<NodeData> readNodesAsList(ObjectInputStream in) throws Exception {
        Object obj = this.cache.getMarshaller().objectFromObjectStream(in);
        if (obj instanceof NodeDataMarker) {
            return null;
        }
        return (List)obj;
    }

    private NodeData integrateStateTransferChildren(NodeSPI parent, int offset, Iterator<NodeData> nodeDataIterator) throws IOException, ClassNotFoundException {
        NodeData nd;
        int parent_level = parent.getFqn().size();
        int target_level = parent_level + 1;
        NodeData nodeData = nd = nodeDataIterator.hasNext() ? nodeDataIterator.next() : null;
        while (nd != null && !nd.isMarker()) {
            NodeSPI target;
            int size;
            Fqn fqn = nd.getFqn();
            if (offset > 0) {
                fqn = Fqn.fromRelativeFqn(parent.getFqn().getAncestor(offset), fqn);
            }
            if ((size = fqn.size()) <= parent_level) {
                return nd;
            }
            if (size > target_level) {
                throw new IllegalStateException("NodeData " + fqn + " is not a direct child of " + parent.getFqn());
            }
            Map attrs = nd.getAttributes();
            if (this.usePut) {
                this.cache.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
                this.cache.getInvocationContext().getOptionOverrides().setSkipCacheStatusCheck(true);
                this.cache.clearData(fqn);
                this.cache.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
                this.cache.getInvocationContext().getOptionOverrides().setSkipCacheStatusCheck(true);
                this.cache.put(fqn, attrs);
                target = this.cache.getNode(fqn);
            } else {
                target = this.factory.createNode(fqn, parent, attrs);
                parent.addChild(fqn.getLastElement(), target);
                Region region = this.cache.getRegion(fqn, false);
                if (region != null && region.getEvictionRegionConfig() != null) {
                    region.registerEvictionEvent(fqn, EvictionEvent.Type.ADD_NODE_EVENT, attrs == null ? 0 : attrs.size());
                }
            }
            nd = this.integrateStateTransferChildren(target, offset, nodeDataIterator);
        }
        if (nd != null && nd.isExceptionMarker()) {
            NodeDataExceptionMarker ndem = (NodeDataExceptionMarker)nd;
            throw new CacheException("State provider node " + ndem.getCacheNodeIdentity() + " threw exception during loadState", ndem.getCause());
        }
        return null;
    }

    private Set<Node> retainInternalNodes(Node target) {
        HashSet<Node> result = new HashSet<Node>();
        Fqn targetFqn = target.getFqn();
        for (Fqn internalFqn : this.internalFqns) {
            Node internalNode;
            if (!internalFqn.isChildOf(targetFqn) || (internalNode = this.getInternalNode(target, internalFqn)) == null) continue;
            result.add(internalNode);
        }
        return result;
    }

    private Node getInternalNode(Node parent, Fqn internalFqn) {
        Object name = internalFqn.get(parent.getFqn().size());
        this.cache.getInvocationContext().getOptionOverrides().setSkipCacheStatusCheck(true);
        Node result = parent.getChild(name);
        if (result != null && internalFqn.size() < result.getFqn().size()) {
            result = this.getInternalNode(result, internalFqn);
        }
        return result;
    }

    private void integrateRetainedNodes(NodeSPI target) {
        Set<Node> retainedNodes = this.retainInternalNodes(target);
        Fqn rootFqn = target.getFqn();
        for (Node retained : retainedNodes) {
            if (!retained.getFqn().isChildOf(rootFqn)) continue;
            this.integrateRetainedNode(target, retained);
        }
    }

    private void integrateRetainedNode(NodeSPI ancestor, Node descendant) {
        Fqn descFqn = descendant.getFqn();
        Fqn ancFqn = ancestor.getFqn();
        Object name = descFqn.get(ancFqn.size());
        NodeSPI child = (NodeSPI)ancestor.getChild(name);
        if (ancFqn.size() == descFqn.size() + 1) {
            if (child == null) {
                ancestor.addChild(name, descendant);
            } else {
                log.warn("Received unexpected internal node " + descFqn + " in transferred state");
            }
        } else {
            if (child == null) {
                child = this.factory.createNode(name, ancestor);
                ancestor.addChild(name, child);
            }
            this.integrateRetainedNode(child, descendant);
        }
    }
}

