/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.builder;

import java.security.PrivilegedAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractBuilder<T>
implements PrivilegedAction<T> {
    private Class<T> factoryClass;
    private String defaultFactory;

    public AbstractBuilder(Class<T> factoryClass, String defaultFactory) {
        if (factoryClass == null) {
            throw new IllegalArgumentException("Null factory class");
        }
        if (defaultFactory == null) {
            throw new IllegalArgumentException("Null default factory");
        }
        this.factoryClass = factoryClass;
        this.defaultFactory = defaultFactory;
    }

    @Override
    public T run() {
        T retObj;
        Object object;
        try {
            String className = System.getProperty(this.factoryClass.getName(), this.defaultFactory);
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
            object = clazz.newInstance();
        }
        catch (Throwable t) {
            throw new RuntimeException("Error constructing " + this.factoryClass.getName(), t);
        }
        try {
            retObj = this.factoryClass.cast(object);
        }
        catch (ClassCastException ex) {
            String objClassName = object.getClass().getName();
            ClassLoader objLoader = object.getClass().getClassLoader();
            String factoryClassName = this.factoryClass.getName();
            ClassLoader factoryLoader = this.factoryClass.getClassLoader();
            String msg = "Cannot cast object '" + objClassName + "' to factory '" + factoryClassName + "'\n" + "  factoryLoader: " + factoryLoader + "\n" + "  objLoader: " + objLoader;
            throw new RuntimeException(msg);
        }
        return retObj;
    }
}

