/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.Properties;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.stack.Protocol;

public class DUPL
extends Protocol {
    protected int incoming_copies = 1;
    protected int outgoing_copies = 1;
    protected boolean copy_unicast_msgs = true;
    protected boolean copy_multicast_msgs = true;

    public DUPL() {
    }

    public DUPL(boolean copy_multicast_msgs, boolean copy_unicast_msgs, int incoming_copies, int outgoing_copies) {
        this.copy_multicast_msgs = copy_multicast_msgs;
        this.copy_unicast_msgs = copy_unicast_msgs;
        this.incoming_copies = incoming_copies;
        this.outgoing_copies = outgoing_copies;
    }

    public String getName() {
        return "DUPL";
    }

    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("incoming_copies");
        if (str != null) {
            this.incoming_copies = Integer.parseInt(str);
            props.remove("incoming_copies");
        }
        if ((str = props.getProperty("outgoing_copies")) != null) {
            this.outgoing_copies = Integer.parseInt(str);
            props.remove("outgoing_copies");
        }
        if ((str = props.getProperty("copy_unicast_msgs")) != null) {
            this.copy_unicast_msgs = Boolean.parseBoolean(str);
            props.remove("copy_unicast_msgs");
        }
        if ((str = props.getProperty("copy_multicast_msgs")) != null) {
            this.copy_multicast_msgs = Boolean.parseBoolean(str);
            props.remove("copy_multicast_msgs");
        }
        if (!props.isEmpty()) {
            this.log.error("the following properties are not recognized: " + props);
            return false;
        }
        return true;
    }

    public Object down(Event evt) {
        boolean copy;
        boolean bl = copy = (this.copy_multicast_msgs || this.copy_unicast_msgs) && this.outgoing_copies > 0;
        if (!copy) {
            return this.down_prot.down(evt);
        }
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                this.copy(msg, this.outgoing_copies, Direction.DOWN);
            }
        }
        return this.down_prot.down(evt);
    }

    public Object up(Event evt) {
        boolean copy;
        boolean bl = copy = (this.copy_multicast_msgs || this.copy_unicast_msgs) && this.incoming_copies > 0;
        if (!copy) {
            return this.up_prot.up(evt);
        }
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                this.copy(msg, this.incoming_copies, Direction.UP);
            }
        }
        return this.up_prot.up(evt);
    }

    private void copy(Message msg, int num_copies, Direction direction) {
        boolean multicast;
        Address dest = msg.getDest();
        boolean bl = multicast = dest == null || dest.isMulticastAddress();
        if (multicast && this.copy_multicast_msgs || !multicast && this.copy_unicast_msgs) {
            block4: for (int i = 0; i < num_copies; ++i) {
                Message copy = msg.copy(true);
                switch (direction) {
                    case UP: {
                        this.up_prot.up(new Event(1, copy));
                        continue block4;
                    }
                    case DOWN: {
                        this.down_prot.down(new Event(1, copy));
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Direction {
        UP,
        DOWN;

    }
}

