/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Event;
import org.jgroups.protocols.TP;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.util.ThreadFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Protocol {
    protected final Properties props = new Properties();
    protected Protocol up_prot = null;
    protected Protocol down_prot = null;
    protected ProtocolStack stack = null;
    protected boolean stats = true;
    protected final Log log = LogFactory.getLog(this.getClass());

    public boolean setProperties(Properties props) {
        if (props != null) {
            this.props.putAll((Map<?, ?>)props);
        }
        return true;
    }

    public boolean setPropertiesInternal(Properties props) {
        this.props.putAll((Map<?, ?>)props);
        String str = props.getProperty("down_thread");
        if (str != null) {
            if (this.log.isWarnEnabled()) {
                this.log.warn("down_thread was deprecated and is ignored");
            }
            props.remove("down_thread");
        }
        if ((str = props.getProperty("down_thread_prio")) != null) {
            if (this.log.isWarnEnabled()) {
                this.log.warn("down_thread_prio was deprecated and is ignored");
            }
            props.remove("down_thread_prio");
        }
        if ((str = props.getProperty("up_thread")) != null) {
            if (this.log.isWarnEnabled()) {
                this.log.warn("up_thread was deprecated and is ignored");
            }
            props.remove("up_thread");
        }
        if ((str = props.getProperty("up_thread_prio")) != null) {
            if (this.log.isWarnEnabled()) {
                this.log.warn("up_thread_prio was deprecated and is ignored");
            }
            props.remove("up_thread_prio");
        }
        if ((str = props.getProperty("stats")) != null) {
            this.stats = Boolean.valueOf(str);
            props.remove("stats");
        }
        return this.setProperties(props);
    }

    public Properties getProperties() {
        return this.props;
    }

    public ProtocolStack getProtocolStack() {
        return this.stack;
    }

    protected TP getTransport() {
        Protocol retval = this;
        while (retval != null && retval.down_prot != null) {
            retval = retval.down_prot;
        }
        return (TP)retval;
    }

    public ThreadFactory getThreadFactory() {
        return this.down_prot != null ? this.down_prot.getThreadFactory() : null;
    }

    public boolean upThreadEnabled() {
        return false;
    }

    public boolean downThreadEnabled() {
        return false;
    }

    public boolean statsEnabled() {
        return this.stats;
    }

    public void enableStats(boolean flag) {
        this.stats = flag;
    }

    public void resetStats() {
    }

    public String printStats() {
        return null;
    }

    public Map<String, Object> dumpStats() {
        return new HashMap<String, Object>();
    }

    public void init() throws Exception {
    }

    public void start() throws Exception {
    }

    public void stop() {
    }

    public void destroy() {
    }

    public Vector<Integer> requiredUpServices() {
        return null;
    }

    public Vector<Integer> requiredDownServices() {
        return null;
    }

    public Vector<Integer> providedUpServices() {
        return null;
    }

    public Vector<Integer> providedDownServices() {
        return null;
    }

    public abstract String getName();

    public Protocol getUpProtocol() {
        return this.up_prot;
    }

    public Protocol getDownProtocol() {
        return this.down_prot;
    }

    public void setUpProtocol(Protocol up_prot) {
        this.up_prot = up_prot;
    }

    public void setDownProtocol(Protocol down_prot) {
        this.down_prot = down_prot;
    }

    public void setProtocolStack(ProtocolStack stack) {
        this.stack = stack;
    }

    public Object up(Event evt) {
        return this.up_prot.up(evt);
    }

    public Object down(Event evt) {
        return this.down_prot.down(evt);
    }
}

