/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jgroups.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortsManager {
    private String filename = "jgroups-ports.txt";
    private String temp_dir = System.getProperty("java.io.tmpdir", "/tmp");
    private static final String file_separator = System.getProperty("file.separator", "/");
    private String absolute_name = this.temp_dir + file_separator + this.filename;
    private long expiry_time = 60000L;

    public PortsManager() {
    }

    public PortsManager(long expiry_time) {
        this.expiry_time = expiry_time;
    }

    public PortsManager(String ports_file) {
        if (ports_file != null) {
            this.absolute_name = ports_file;
        }
    }

    public PortsManager(long expiry_time, String ports_file) {
        this.expiry_time = expiry_time;
        if (ports_file != null) {
            this.absolute_name = ports_file;
        }
    }

    public PortsManager(long expiry_time, String filename, String temp_dir) {
        this.expiry_time = expiry_time;
        this.filename = filename;
        this.temp_dir = temp_dir;
        this.absolute_name = temp_dir + file_separator + filename;
    }

    public long getExpiryTime() {
        return this.expiry_time;
    }

    public void setExpiryTime(long expiry_time) {
        this.expiry_time = expiry_time;
    }

    public int getNextAvailablePort(int start_port) {
        int retval = -1;
        try {
            Map<Integer, Long> map = this.load();
            long current_time = System.currentTimeMillis();
            if (map.isEmpty()) {
                map.put(start_port, current_time);
                this.store(map);
                return start_port;
            }
            Iterator<Map.Entry<Integer, Long>> it = map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Integer, Long> entry = it.next();
                long timestamp = entry.getValue();
                if (current_time - timestamp < this.expiry_time) continue;
                it.remove();
            }
            Set<Integer> ports = map.keySet();
            while (ports.contains(start_port)) {
                ++start_port;
            }
            map.put(start_port, System.currentTimeMillis());
            this.store(map);
            return start_port;
        }
        catch (IOException e) {
            return retval;
        }
    }

    public void removePort(int port) {
        try {
            Map<Integer, Long> map = this.load();
            if (map.isEmpty()) {
                return;
            }
            map.remove(port);
            this.store(map);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void updatePort(int port) {
        try {
            Map<Integer, Long> map = this.load();
            if (map.isEmpty()) {
                return;
            }
            map.put(port, System.currentTimeMillis());
            this.store(map);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void deleteFile() {
        File file = new File(this.absolute_name);
        file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Integer, Long> load() throws IOException {
        HashMap<Integer, Long> hashMap;
        FileInputStream in = null;
        HashMap<Integer, Long> retval = new HashMap<Integer, Long>();
        try {
            in = new FileInputStream(this.absolute_name);
            Properties props = new Properties();
            props.load(in);
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                String keystr = (String)entry.getKey();
                String valstr = (String)entry.getValue();
                int key = Integer.parseInt(keystr);
                long val = Long.parseLong(valstr);
                retval.put(key, val);
            }
            hashMap = retval;
        }
        catch (Throwable t) {
            HashMap<Integer, Long> hashMap2;
            try {
                hashMap2 = retval;
            }
            catch (Throwable throwable) {
                Util.close(in);
                throw throwable;
            }
            Util.close(in);
            return hashMap2;
        }
        Util.close(in);
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store(Map<Integer, Long> map) throws IOException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(this.absolute_name);
            Properties props = new Properties();
            for (Map.Entry<Integer, Long> entry : map.entrySet()) {
                String key = entry.getKey().toString();
                String val = entry.getValue().toString();
                props.put(key, val);
            }
            props.store(out, "Persistent JGroups ports");
        }
        catch (Throwable throwable) {
            Util.close(out);
            throw throwable;
        }
        Util.close(out);
    }
}

