/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.TimeoutException;
import org.jgroups.util.QueueClosedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Queue {
    private Element head = null;
    private Element tail = null;
    private boolean closed = false;
    private int size = 0;
    private final Object mutex = new Object();
    private int num_markers = 0;
    private static final Object endMarker = new Object();
    protected static final Log log = LogFactory.getLog(Queue.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getFirst() {
        Object object = this.mutex;
        synchronized (object) {
            return this.head != null ? this.head.obj : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getLast() {
        Object object = this.mutex;
        synchronized (object) {
            return this.tail != null ? this.tail.obj : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean closed() {
        Object object = this.mutex;
        synchronized (object) {
            return this.closed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Object obj) throws QueueClosedException {
        if (obj == null) {
            if (log.isErrorEnabled()) {
                log.error("argument must not be null");
            }
            return;
        }
        Object object = this.mutex;
        synchronized (object) {
            if (this.closed) {
                throw new QueueClosedException();
            }
            if (this.num_markers > 0) {
                throw new QueueClosedException("queue has been closed. You can not add more elements. Waiting for removal of remaining elements.");
            }
            this.addInternal(obj);
            this.mutex.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(Collection c) throws QueueClosedException {
        if (c == null) {
            if (log.isErrorEnabled()) {
                log.error("argument must not be null");
            }
            return;
        }
        Object object = this.mutex;
        synchronized (object) {
            if (this.closed) {
                throw new QueueClosedException();
            }
            if (this.num_markers > 0) {
                throw new QueueClosedException("queue has been closed. You can not add more elements. Waiting for removal of remaining elements.");
            }
            for (Object obj : c) {
                if (obj == null) continue;
                this.addInternal(obj);
            }
            this.mutex.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(List<Object> list) throws QueueClosedException {
        if (list == null) {
            if (log.isErrorEnabled()) {
                log.error("argument must not be null");
            }
            return;
        }
        Object object = this.mutex;
        synchronized (object) {
            if (this.closed) {
                throw new QueueClosedException();
            }
            if (this.num_markers > 0) {
                throw new QueueClosedException("queue has been closed. You can not add more elements. Waiting for removal of remaining elements.");
            }
            for (Object obj : list) {
                if (obj == null) continue;
                this.addInternal(obj);
            }
            this.mutex.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAtHead(Object obj) throws QueueClosedException {
        if (obj == null) {
            if (log.isErrorEnabled()) {
                log.error("argument must not be null");
            }
            return;
        }
        Object object = this.mutex;
        synchronized (object) {
            if (this.closed) {
                throw new QueueClosedException();
            }
            if (this.num_markers > 0) {
                throw new QueueClosedException("Queue.addAtHead(): queue has been closed. You can not add more elements. Waiting for removal of remaining elements.");
            }
            Element el = new Element(obj);
            if (this.head == null) {
                this.tail = this.head = el;
                this.size = 1;
            } else {
                el.next = this.head;
                this.head = el;
                ++this.size;
            }
            this.mutex.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove() throws QueueClosedException {
        Object retval;
        Object object = this.mutex;
        synchronized (object) {
            while (this.size == 0) {
                if (this.closed) {
                    throw new QueueClosedException();
                }
                try {
                    this.mutex.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.closed) {
                throw new QueueClosedException();
            }
            retval = this.removeInternal();
            if (retval == null && log.isErrorEnabled()) {
                log.error("element was null, should never be the case");
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(long timeout) throws QueueClosedException, TimeoutException {
        Object object = this.mutex;
        synchronized (object) {
            if (this.closed) {
                throw new QueueClosedException();
            }
            if (this.size == 0) {
                try {
                    this.mutex.wait(timeout);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
            if (this.closed) {
                throw new QueueClosedException();
            }
            Object retval = this.removeInternal();
            if (retval == null) {
                throw new TimeoutException("timeout=" + timeout + "ms");
            }
            return retval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeElement(Object obj) throws QueueClosedException {
        if (obj == null) {
            if (log.isErrorEnabled()) {
                log.error("argument must not be null");
            }
            return;
        }
        Object object = this.mutex;
        synchronized (object) {
            if (this.closed) {
                throw new QueueClosedException();
            }
            Element el = this.head;
            if (el == null) {
                return;
            }
            if (el.obj.equals(obj)) {
                this.head = el.next;
                el.next = null;
                el.obj = null;
                if (this.size == 1) {
                    this.tail = this.head;
                }
                this.decrementSize();
                return;
            }
            while (el.next != null) {
                if (el.next.obj.equals(obj)) {
                    Element tmp_el = el.next;
                    if (tmp_el == this.tail) {
                        this.tail = el;
                    }
                    el.next.obj = null;
                    el.next = el.next.next;
                    tmp_el.next = null;
                    tmp_el.obj = null;
                    this.decrementSize();
                    break;
                }
                el = el.next;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object peek() throws QueueClosedException {
        Object retval;
        Object object = this.mutex;
        synchronized (object) {
            while (this.size == 0) {
                if (this.closed) {
                    throw new QueueClosedException();
                }
                try {
                    this.mutex.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.closed) {
                throw new QueueClosedException();
            }
            retval = this.head != null ? this.head.obj : null;
        }
        if (retval == endMarker) {
            this.close(false);
            throw new QueueClosedException();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object peek(long timeout) throws QueueClosedException, TimeoutException {
        Object object = this.mutex;
        synchronized (object) {
            Object retval;
            if (this.size == 0) {
                if (this.closed) {
                    throw new QueueClosedException();
                }
                try {
                    this.mutex.wait(timeout);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
            if (this.closed) {
                throw new QueueClosedException();
            }
            Object object2 = retval = this.head != null ? this.head.obj : null;
            if (retval == null) {
                throw new TimeoutException("timeout=" + timeout + "ms");
            }
            if (retval == endMarker) {
                this.close(false);
                throw new QueueClosedException();
            }
            return retval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.mutex;
        synchronized (object) {
            this.tail = null;
            this.head = null;
            this.size = 0;
            this.num_markers = 0;
            this.mutex.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean flush_entries) {
        Object object = this.mutex;
        synchronized (object) {
            if (flush_entries && this.size > 0) {
                try {
                    this.add(endMarker);
                    ++this.num_markers;
                }
                catch (QueueClosedException queueClosedException) {
                    // empty catch block
                }
                return;
            }
            this.closed = true;
            this.mutex.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilClosed(long timeout) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            try {
                this.mutex.wait(timeout);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.mutex;
        synchronized (object) {
            this.num_markers = 0;
            if (!this.closed) {
                this.close(false);
            }
            this.size = 0;
            this.head = null;
            this.tail = null;
            this.closed = false;
            this.mutex.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedList values() {
        LinkedList<Object> retval = new LinkedList<Object>();
        Object object = this.mutex;
        synchronized (object) {
            Element el = this.head;
            while (el != null) {
                retval.add(el.obj);
                el = el.next;
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.mutex;
        synchronized (object) {
            return this.size - this.num_markers;
        }
    }

    public String toString() {
        return "Queue (" + this.size() + ") elements";
    }

    private final void addInternal(Object obj) {
        Element el = new Element(obj);
        if (this.head == null) {
            this.tail = this.head = el;
            this.size = 1;
        } else {
            this.tail.next = el;
            this.tail = el;
            ++this.size;
        }
    }

    private Object removeInternal() {
        if (this.head == null) {
            return null;
        }
        Element retval = this.head;
        this.head = this.head.next;
        if (this.head == null) {
            this.tail = null;
        }
        this.decrementSize();
        if (this.head != null && this.head.obj == endMarker) {
            this.closed = true;
            this.mutex.notifyAll();
        }
        retval.next = null;
        Object obj = retval.obj;
        retval.obj = null;
        return obj;
    }

    private final void decrementSize() {
        --this.size;
        if (this.size < 0) {
            this.size = 0;
        }
    }

    static class Element {
        Object obj = null;
        Element next = null;

        Element(Object o) {
            this.obj = o;
        }

        public String toString() {
            return this.obj != null ? this.obj.toString() : "null";
        }
    }
}

