/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.jbosscache;

import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import net.jcip.annotations.NotThreadSafe;
import org.jboss.cache.Cache;
import org.modeshape.connector.jbosscache.JBossCacheConnectorI18n;
import org.modeshape.connector.jbosscache.JBossCacheNode;
import org.modeshape.connector.jbosscache.JBossCacheRepository;
import org.modeshape.connector.jbosscache.JBossCacheWorkspace;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.connector.base.MapTransaction;
import org.modeshape.graph.connector.base.Repository;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.request.InvalidWorkspaceException;

@NotThreadSafe
public class JBossCacheTransaction
extends MapTransaction<JBossCacheNode, JBossCacheWorkspace> {
    private final JBossCacheRepository repository;
    private final Lock lock;

    protected JBossCacheTransaction(ExecutionContext context, JBossCacheRepository repository, UUID rootNodeUuid, Lock lock) {
        super(context, (Repository)repository, rootNodeUuid);
        this.repository = repository;
        this.lock = lock;
    }

    public Set<String> getWorkspaceNames() {
        return this.repository.getWorkspaceNames();
    }

    public JBossCacheWorkspace getWorkspace(String name, JBossCacheWorkspace originalToClone) {
        Cache<UUID, JBossCacheNode> workspaceCache = this.repository.getCache();
        if (workspaceCache == null) {
            String msg = JBossCacheConnectorI18n.unableToCreateWorkspace.text(new Object[]{name, this.repository.getSourceName()});
            throw new InvalidWorkspaceException(msg);
        }
        if (originalToClone != null) {
            return new JBossCacheWorkspace(name, workspaceCache, originalToClone);
        }
        return new JBossCacheWorkspace(name, workspaceCache, new JBossCacheNode(this.repository.getRootNodeUuid()));
    }

    public boolean destroyWorkspace(JBossCacheWorkspace workspace) {
        workspace.removeAll();
        return true;
    }

    protected JBossCacheNode createNode(UUID uuid, Path.Segment name, UUID parentUuid, Iterable<Property> properties) {
        return new JBossCacheNode(uuid, name, parentUuid, properties, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() {
        try {
            super.commit();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() {
        try {
            super.rollback();
        }
        finally {
            this.lock.unlock();
        }
    }
}

