/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.config;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.RegionManagerImpl;
import org.jboss.cache.config.ConfigurationComponent;
import org.jboss.cache.config.ConfigurationException;
import org.jboss.cache.config.Dynamic;
import org.jboss.cache.config.EvictionRegionConfig;
import org.jboss.cache.config.UnsupportedEvictionImplException;
import org.jboss.cache.eviction.DefaultEvictionActionPolicy;
import org.jboss.cache.eviction.EvictionAlgorithm;
import org.jboss.cache.eviction.EvictionPolicy;
import org.jboss.cache.eviction.ModernizablePolicy;
import org.jboss.cache.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvictionConfig
extends ConfigurationComponent {
    private static final long serialVersionUID = -7979639000026975201L;
    public static final int WAKEUP_DEFAULT = 5000;
    public static final int EVENT_QUEUE_SIZE_DEFAULT = 200000;
    public static final String EVICTION_ACTION_POLICY_CLASS_DEFAULT = DefaultEvictionActionPolicy.class.getName();
    @Dynamic
    private long wakeupInterval = 5000L;
    private int defaultEventQueueSize = 200000;
    @Dynamic
    private List<EvictionRegionConfig> evictionRegionConfigs = new LinkedList<EvictionRegionConfig>();
    private EvictionRegionConfig defaultEvictionRegionConfig;
    @Deprecated
    private String defaultEvictionPolicyClass;

    public EvictionConfig() {
        this.defaultEvictionRegionConfig = new EvictionRegionConfig(Fqn.ROOT);
        this.defaultEvictionRegionConfig.setEventQueueSize(200000);
        this.defaultEvictionRegionConfig.setEvictionActionPolicyClassName(DefaultEvictionActionPolicy.class.getName());
    }

    @Deprecated
    public EvictionConfig(String defaultEvictionPolicyClass) {
        this();
        this.setDefaultEvictionPolicyClass(defaultEvictionPolicyClass);
    }

    public EvictionConfig(EvictionRegionConfig defaultEvictionRegionConfig) {
        try {
            this.defaultEvictionRegionConfig = defaultEvictionRegionConfig.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new ConfigurationException(e);
        }
        this.defaultEvictionRegionConfig.setEventQueueSize(200000);
        if (this.defaultEvictionRegionConfig.getEvictionActionPolicyClassName() == null) {
            this.defaultEvictionRegionConfig.setEvictionActionPolicyClassName(DefaultEvictionActionPolicy.class.getName());
        }
    }

    public EvictionConfig(EvictionRegionConfig defaultEvictionRegionConfig, int wakeupInterval) {
        this(defaultEvictionRegionConfig);
        this.wakeupInterval = wakeupInterval;
    }

    public boolean isValidConfig() {
        return this.defaultEvictionRegionConfig != null && this.defaultEvictionRegionConfig.getEvictionActionPolicyClassName() != null && this.defaultEvictionRegionConfig.getEvictionAlgorithmConfig() != null || this.evictionRegionConfigs != null && this.evictionRegionConfigs.size() > 0;
    }

    public EvictionRegionConfig getDefaultEvictionRegionConfig() {
        return this.defaultEvictionRegionConfig;
    }

    public void setDefaultEvictionRegionConfig(EvictionRegionConfig defaultEvictionRegionConfig) {
        this.defaultEvictionRegionConfig = defaultEvictionRegionConfig;
        this.defaultEvictionRegionConfig.setEventQueueSizeIfUnset(200000);
    }

    @Deprecated
    public String getDefaultEvictionPolicyClass() {
        return this.defaultEvictionPolicyClass;
    }

    @Deprecated
    public void setDefaultEvictionPolicyClass(String defaultEvictionPolicyClass) {
        EvictionConfig.assertIsTransformable(defaultEvictionPolicyClass);
        try {
            EvictionPolicy policy = (EvictionPolicy)Util.getInstance(defaultEvictionPolicyClass);
            EvictionAlgorithm ea = policy.getEvictionAlgorithm();
            this.defaultEvictionRegionConfig.setEvictionAlgorithmConfig(Util.getInstance(ea.getConfigurationClass()));
            this.defaultEvictionPolicyClass = defaultEvictionPolicyClass;
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    @Deprecated
    public static final void assertIsTransformable(String evictionPolicyClass) throws UnsupportedEvictionImplException {
        boolean throwException;
        block5: {
            throwException = true;
            if (evictionPolicyClass.indexOf("org.jboss.cache.eviction") > -1) {
                EvictionPolicy ep = null;
                try {
                    ep = (EvictionPolicy)Util.getInstance(evictionPolicyClass);
                    if (ep instanceof ModernizablePolicy) {
                        throwException = false;
                    }
                }
                catch (Exception e) {
                    Log l = LogFactory.getLog(EvictionConfig.class);
                    if (!l.isTraceEnabled()) break block5;
                    l.trace(e);
                }
            }
        }
        if (throwException) {
            throw new UnsupportedEvictionImplException("Unsupported custom eviction policy [" + evictionPolicyClass + "]. Starting with 3.x the eviction API has changed, the code needs to be manually migrated.  Please re-implement your custom policy.");
        }
    }

    @Deprecated
    public EvictionRegionConfig createDefaultEvictionRegionConfig() {
        return this.getDefaultEvictionRegionConfig();
    }

    public List<EvictionRegionConfig> getEvictionRegionConfigs() {
        return this.evictionRegionConfigs;
    }

    public void setEvictionRegionConfigs(List<EvictionRegionConfig> evictionRegionConfigs) {
        this.testImmutability("evictionRegionConfigs");
        EvictionRegionConfig toRemove = null;
        for (EvictionRegionConfig erc : evictionRegionConfigs) {
            if (!erc.getRegionFqn().isRoot() && !erc.getRegionFqn().equals(RegionManagerImpl.DEFAULT_REGION)) continue;
            this.mergeWithDefault(erc);
            toRemove = erc;
            break;
        }
        if (toRemove != null) {
            evictionRegionConfigs.remove(toRemove);
        }
        this.evictionRegionConfigs = evictionRegionConfigs;
    }

    private void mergeWithDefault(EvictionRegionConfig erc) {
        erc.setEventQueueSizeIfUnset(this.defaultEvictionRegionConfig.getEventQueueSize());
        if (erc.getEvictionAlgorithmConfig() == null) {
            erc.setEvictionAlgorithmConfig(this.defaultEvictionRegionConfig.getEvictionAlgorithmConfig());
        }
        this.defaultEvictionRegionConfig = erc;
    }

    public void addEvictionRegionConfig(EvictionRegionConfig evictionRegionConfig) {
        this.testImmutability("evictionRegionConfigs");
        if (evictionRegionConfig.getRegionFqn().isRoot() || evictionRegionConfig.getRegionFqn().equals(RegionManagerImpl.DEFAULT_REGION)) {
            this.mergeWithDefault(evictionRegionConfig);
        } else {
            this.evictionRegionConfigs.add(evictionRegionConfig);
        }
    }

    public long getWakeupInterval() {
        return this.wakeupInterval;
    }

    public void setWakeupInterval(long wakeupInterval) {
        this.testImmutability("wakeupInterval");
        this.wakeupInterval = wakeupInterval;
    }

    public void setWakeupInterval(long wakeupInterval, TimeUnit timeUnit) {
        this.testImmutability("wakeupInterval");
        this.wakeupInterval = timeUnit.toMillis(wakeupInterval);
    }

    @Deprecated
    public int getWakeupIntervalSeconds() {
        return (int)TimeUnit.MILLISECONDS.toSeconds(this.wakeupInterval);
    }

    @Deprecated
    public void setWakeupIntervalSeconds(int wakeupIntervalSeconds) {
        this.setWakeupInterval(wakeupIntervalSeconds, TimeUnit.SECONDS);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EvictionConfig)) {
            return false;
        }
        EvictionConfig that = (EvictionConfig)o;
        if (this.defaultEventQueueSize != that.defaultEventQueueSize) {
            return false;
        }
        if (this.wakeupInterval != that.wakeupInterval) {
            return false;
        }
        if (this.defaultEvictionRegionConfig != null ? !this.defaultEvictionRegionConfig.equals(that.defaultEvictionRegionConfig) : that.defaultEvictionRegionConfig != null) {
            return false;
        }
        return !(this.evictionRegionConfigs != null ? !((Object)this.evictionRegionConfigs).equals(that.evictionRegionConfigs) : that.evictionRegionConfigs != null);
    }

    public int hashCode() {
        int result = 31 + (int)(this.wakeupInterval ^ this.wakeupInterval >>> 32);
        result = 31 * result + this.defaultEventQueueSize;
        result = 31 * result + (this.evictionRegionConfigs != null ? ((Object)this.evictionRegionConfigs).hashCode() : 0);
        return result;
    }

    @Override
    public EvictionConfig clone() throws CloneNotSupportedException {
        EvictionConfig clone = (EvictionConfig)super.clone();
        if (this.evictionRegionConfigs != null) {
            clone.evictionRegionConfigs = new LinkedList<EvictionRegionConfig>();
            for (EvictionRegionConfig erc : this.evictionRegionConfigs) {
                clone.addEvictionRegionConfig(erc.clone());
            }
        }
        return clone;
    }

    public EvictionRegionConfig getEvictionRegionConfig(String region) {
        Fqn<String> fqn = Fqn.fromString(region);
        for (EvictionRegionConfig evConfig : this.getEvictionRegionConfigs()) {
            if (!evConfig.getRegionFqn().equals(fqn)) continue;
            return evConfig;
        }
        return null;
    }

    public void applyDefaults(EvictionRegionConfig config) {
        if (config == null) {
            return;
        }
        config.setDefaults(this.defaultEvictionRegionConfig);
    }

    @Deprecated
    public void setDefaultEventQueueSize(int queueSize) {
        this.defaultEvictionRegionConfig.setEventQueueSize(queueSize);
    }
}

