/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.config.EvictionAlgorithmConfig;
import org.jboss.cache.eviction.BaseSortedEvictionAlgorithm;
import org.jboss.cache.eviction.EvictionException;
import org.jboss.cache.eviction.EvictionQueue;
import org.jboss.cache.eviction.LFUAlgorithmConfig;
import org.jboss.cache.eviction.LFUQueue;
import org.jboss.cache.eviction.NodeEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LFUAlgorithm
extends BaseSortedEvictionAlgorithm {
    private static final Log log = LogFactory.getLog(LFUAlgorithm.class);
    private static final boolean trace = log.isTraceEnabled();

    @Override
    protected boolean shouldEvictNode(NodeEntry ne) {
        if (trace) {
            log.trace("Deciding whether node in queue " + ne.getFqn() + " requires eviction.");
        }
        if (this.isYoungerThanMinimumTimeToLive(ne)) {
            return false;
        }
        LFUAlgorithmConfig config = (LFUAlgorithmConfig)this.evictionAlgorithmConfig;
        int size = this.getEvictionQueue().getNumberOfNodes();
        if (config.getMaxNodes() > -1 && size > config.getMaxNodes()) {
            return true;
        }
        return size > config.getMinNodes();
    }

    @Override
    protected EvictionQueue setupEvictionQueue() throws EvictionException {
        return new LFUQueue();
    }

    @Override
    protected void prune() throws EvictionException {
        super.prune();
        ((LFUQueue)this.evictionQueue).prune();
    }

    @Override
    public Class<? extends EvictionAlgorithmConfig> getConfigurationClass() {
        return LFUAlgorithmConfig.class;
    }
}

