/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.config.Option;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.interceptors.base.CommandInterceptor;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.TransactionContext;
import org.jboss.cache.transaction.TransactionTable;

public abstract class BaseTransactionalContextInterceptor
extends CommandInterceptor {
    protected TransactionTable txTable;
    protected TransactionManager txManager;

    @Inject
    void injectDependencies(TransactionTable txTable, TransactionManager txManager) {
        this.txManager = txManager;
        this.txTable = txTable;
    }

    protected void copyInvocationScopeOptionsToTxScope(InvocationContext ctx) {
        TransactionContext tCtx = this.txTable.get(ctx.getGlobalTransaction());
        if (tCtx != null) {
            Option txScopeOption = new Option();
            txScopeOption.setCacheModeLocal(ctx.getOptionOverrides() != null && ctx.getOptionOverrides().isCacheModeLocal());
            txScopeOption.setSkipCacheStatusCheck(ctx.getOptionOverrides() != null && ctx.getOptionOverrides().isSkipCacheStatusCheck());
            tCtx.setOption(txScopeOption);
        }
    }

    protected void setTransactionalContext(Transaction tx, GlobalTransaction gtx, TransactionContext tCtx, InvocationContext ctx) {
        if (this.trace) {
            this.log.trace("Setting up transactional context.");
            this.log.trace("Setting tx as " + tx + " and gtx as " + gtx);
        }
        ctx.setTransaction(tx);
        ctx.setGlobalTransaction(gtx);
        if (tCtx == null) {
            if (gtx != null) {
                ctx.setTransactionContext(this.txTable.get(gtx));
            } else if (tx == null) {
                ctx.setTransactionContext(null);
            }
        } else {
            ctx.setTransactionContext(tCtx);
        }
    }

    protected boolean isRollingBack(Transaction tx) {
        if (tx == null) {
            return false;
        }
        try {
            int status = tx.getStatus();
            return status == 9 || status == 4;
        }
        catch (SystemException e) {
            this.log.error("failed getting transaction status", e);
            return false;
        }
    }
}

