/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.jboss.cache.CacheException;
import org.jboss.cache.DataContainer;
import org.jboss.cache.Fqn;
import org.jboss.cache.InternalNode;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.commands.read.GetChildrenNamesCommand;
import org.jboss.cache.commands.read.GetDataMapCommand;
import org.jboss.cache.commands.read.GetKeyValueCommand;
import org.jboss.cache.commands.read.GetKeysCommand;
import org.jboss.cache.commands.read.GetNodeCommand;
import org.jboss.cache.commands.tx.RollbackCommand;
import org.jboss.cache.commands.write.ClearDataCommand;
import org.jboss.cache.commands.write.MoveCommand;
import org.jboss.cache.commands.write.PutDataMapCommand;
import org.jboss.cache.commands.write.PutForExternalReadCommand;
import org.jboss.cache.commands.write.PutKeyValueCommand;
import org.jboss.cache.commands.write.RemoveKeyCommand;
import org.jboss.cache.commands.write.RemoveNodeCommand;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.factories.annotations.Start;
import org.jboss.cache.interceptors.base.JmxStatsCommandInterceptor;
import org.jboss.cache.jmx.annotations.ManagedAttribute;
import org.jboss.cache.jmx.annotations.ManagedOperation;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.loader.CacheLoaderManager;
import org.jboss.cache.mvcc.MVCCNodeHelper;
import org.jboss.cache.mvcc.NullMarkerNode;
import org.jboss.cache.mvcc.ReadCommittedNode;
import org.jboss.cache.notifications.Notifier;
import org.jboss.cache.transaction.TransactionTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheLoaderInterceptor
extends JmxStatsCommandInterceptor {
    private long cacheLoads = 0L;
    private long cacheMisses = 0L;
    private CacheLoaderManager clm;
    protected TransactionTable txTable = null;
    protected CacheLoader loader;
    protected DataContainer dataContainer;
    protected Notifier notifier;
    protected boolean isActivation = false;
    protected MVCCNodeHelper helper;
    protected boolean useCacheStore = true;

    @Inject
    protected void injectDependencies(TransactionTable txTable, CacheLoaderManager clm, Configuration configuration, DataContainer dataContainer, Notifier notifier, MVCCNodeHelper helper) {
        this.txTable = txTable;
        this.clm = clm;
        this.dataContainer = dataContainer;
        this.notifier = notifier;
        this.helper = helper;
    }

    @Start
    protected void startInterceptor() {
        this.loader = this.clm.getCacheLoader();
    }

    @Override
    public Object visitPutDataMapCommand(InvocationContext ctx, PutDataMapCommand command) throws Throwable {
        if (command.getFqn() != null) {
            if (command.isErase()) {
                this.replace(ctx, command.getFqn());
            } else {
                this.loadIfNeeded(ctx, command.getFqn(), null, true, true, false, false, false, false, true);
            }
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        if (command.getFqn() != null) {
            this.loadIfNeeded(ctx, command.getFqn(), command.getKey(), false, this.useCacheStore, !this.useCacheStore, false, false, false, true);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitPutForExternalReadCommand(InvocationContext ctx, PutForExternalReadCommand command) throws Throwable {
        return this.visitPutKeyValueCommand(ctx, command);
    }

    @Override
    public Object visitMoveCommand(InvocationContext ctx, MoveCommand command) throws Throwable {
        if (command.getFqn() != null) {
            if (command.getTo() != null) {
                this.loadIfNeeded(ctx, command.getTo(), null, false, false, true, false, true, false, true);
            }
            this.loadIfNeeded(ctx, command.getFqn(), null, false, false, true, true, true, false, true);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        if (command.getFqn() != null) {
            this.loadIfNeeded(ctx, command.getFqn(), command.getKey(), false, false, true, false, false, false, true);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitGetNodeCommand(InvocationContext ctx, GetNodeCommand command) throws Throwable {
        if (command.getFqn() != null) {
            this.loadIfNeeded(ctx, command.getFqn(), null, false, false, true, false, false, true, true);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitGetChildrenNamesCommand(InvocationContext ctx, GetChildrenNamesCommand command) throws Throwable {
        Fqn fqn = command.getFqn();
        if (fqn != null) {
            this.loadIfNeeded(ctx, fqn, null, false, false, false, false, false, true, true);
            this.loadChildren(fqn, this.dataContainer.peekInternalNode(fqn, true), false, false, ctx);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitGetKeysCommand(InvocationContext ctx, GetKeysCommand command) throws Throwable {
        if (command.getFqn() != null) {
            this.loadIfNeeded(ctx, command.getFqn(), null, true, false, true, false, false, false, true);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitGetDataMapCommand(InvocationContext ctx, GetDataMapCommand command) throws Throwable {
        if (command.getFqn() != null) {
            this.loadIfNeeded(ctx, command.getFqn(), null, true, false, true, false, false, false, true);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitRollbackCommand(InvocationContext ctx, RollbackCommand command) throws Throwable {
        List<Fqn> list;
        if (this.trace) {
            this.log.trace("Removing temporarily created nodes");
        }
        if ((list = ctx.getTransactionContext().getDummyNodesCreatedByCacheLoader()) != null && list.size() > 0) {
            ListIterator<Fqn> i = list.listIterator(list.size());
            while (i.hasPrevious()) {
                Fqn fqn = i.previous();
                try {
                    this.dataContainer.evict(fqn, false);
                }
                catch (CacheException e) {
                    if (!this.trace) continue;
                    this.log.trace("Unable to evict node " + fqn, e);
                }
            }
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitRemoveNodeCommand(InvocationContext ctx, RemoveNodeCommand command) throws Throwable {
        if (this.configuration.getNodeLockingScheme() == Configuration.NodeLockingScheme.OPTIMISTIC && command.getFqn() != null) {
            this.loadIfNeeded(ctx, command.getFqn(), null, false, false, false, false, false, false, false);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitRemoveKeyCommand(InvocationContext ctx, RemoveKeyCommand command) throws Throwable {
        if (command.getFqn() != null && !this.useCacheStore) {
            this.loadIfNeeded(ctx, command.getFqn(), command.getKey(), false, false, false, false, false, false, true);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitClearDataCommand(InvocationContext ctx, ClearDataCommand command) throws Throwable {
        Fqn fqn = command.getFqn();
        if (fqn != null && !this.useCacheStore) {
            this.loadIfNeeded(ctx, fqn, null, false, true, false, false, false, false, true);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    private void replace(InvocationContext ctx, Fqn fqn) throws InterruptedException {
        NodeSPI n = this.helper.wrapNodeForReading(ctx, fqn, true);
        if (n instanceof NullMarkerNode) {
            ctx.getLookedUpNodes().remove(fqn);
        }
        n = this.helper.wrapNodeForWriting(ctx, fqn, true, true, true, false, false);
        n.setDataLoaded(true);
    }

    private void loadIfNeeded(InvocationContext ctx, Fqn fqn, Object key, boolean allKeys, boolean initNode, boolean acquireWriteLock, boolean recursive, boolean isMove, boolean bypassLoadingData, boolean shouldLoadIfNodeIsNull) throws Throwable {
        NodeSPI n = this.helper.wrapNodeForReading(ctx, fqn, true);
        if (n instanceof NullMarkerNode) {
            ctx.getLookedUpNodes().remove(fqn);
            n = null;
        }
        boolean mustLoad = this.mustLoad(fqn, n, key, allKeys || isMove, shouldLoadIfNodeIsNull);
        if (this.trace) {
            this.log.trace("load element " + fqn + " mustLoad=" + mustLoad);
        }
        if (mustLoad) {
            if (acquireWriteLock || initNode) {
                boolean isNew = n == null;
                n = this.helper.wrapNodeForWriting(ctx, fqn, true, false, true, false, true);
                if (isNew && n != null) {
                    n.setDataLoaded(false);
                }
            }
            if (n == null || !n.isDeleted()) {
                boolean exists;
                Map nodeData = null;
                if (bypassLoadingData) {
                    exists = this.loader.exists(fqn);
                } else {
                    nodeData = this.loadData(ctx, fqn);
                    boolean bl = exists = nodeData != null;
                }
                if (n == null && exists) {
                    for (NodeSPI node = n = this.helper.wrapNodeForWriting(ctx, fqn, true, true, true, false, false); node != null && node.isCreated(); node = node.getParentDirect()) {
                        node.setDataLoaded(false);
                    }
                }
                if (nodeData != null) {
                    this.setNodeState(ctx, fqn, n, nodeData);
                }
            }
        }
        if (recursive && n != null) {
            this.loadChildren(fqn, n.getDelegationTarget(), recursive, isMove, ctx);
        }
    }

    private void loadChildren(Fqn fqn, InternalNode node, boolean recursive, boolean isMove, InvocationContext ctxt) throws Throwable {
        Set<?> childrenNames;
        if (node != null && node.isChildrenLoaded()) {
            if (this.trace) {
                this.log.trace("Children already loaded!");
            }
            return;
        }
        try {
            childrenNames = this.loader.getChildrenNames(fqn);
        }
        catch (Exception e) {
            if (this.log.isInfoEnabled()) {
                this.log.info("Cache loader was unable to load state", e);
            }
            return;
        }
        if (this.trace) {
            this.log.trace("load children " + fqn + " children=" + childrenNames);
        }
        if (childrenNames == null) {
            if (node != null) {
                if (this.useCacheStore) {
                    node.removeChildren();
                }
                node.setChildrenLoaded(true);
            }
            return;
        }
        if (node == null) {
            ReadCommittedNode temp = this.helper.wrapNodeForWriting(ctxt, fqn, true, true, true, false, false);
            node = temp.getDelegationTarget();
        }
        for (Object name : childrenNames) {
            Fqn<Object> childFqn = Fqn.fromRelativeElements(fqn, name);
            ReadCommittedNode child = this.helper.wrapNodeForWriting(ctxt, childFqn, true, true, true, false, false);
            if (child.isCreated()) {
                child.setDataLoaded(false);
            }
            if ((isMove || this.isActivation) && recursive) {
                child.setInternalState(this.loadData(ctxt, child.getFqn()));
                child.setDataLoaded(true);
            }
            if (!recursive) continue;
            this.loadChildren(child.getFqn(), child.getDelegationTarget(), true, isMove, ctxt);
        }
        node.setChildrenLoaded(true);
    }

    private boolean mustLoad(Fqn fqn, NodeSPI n, Object key, boolean allKeys, boolean shouldLoadIfNodeIsNull) {
        if (n == null) {
            if (this.trace) {
                this.log.trace("Node [" + fqn + "] is null in memory.  Must load? " + shouldLoadIfNodeIsNull);
            }
            return shouldLoadIfNodeIsNull;
        }
        if (!n.isValid()) {
            if (this.trace) {
                this.log.trace("Loading node [" + fqn + "] again from cache loader since in-memory node is marked as invalid");
            }
            return true;
        }
        if (!allKeys) {
            if (key == null) {
                if (this.trace) {
                    this.log.trace("Don't load [" + fqn + "], key requested is null");
                }
                return false;
            }
            if (n.containsKeyDirect(key)) {
                if (this.trace) {
                    this.log.trace("Don't load [" + fqn + "], already have necessary key in memory");
                }
                return false;
            }
        }
        if (!n.isDataLoaded()) {
            if (this.trace) {
                this.log.trace("Must load node [" + fqn + "], uninitialized");
            }
            return true;
        }
        if (this.trace) {
            this.log.trace("Don't load node [" + fqn + "], by default");
        }
        return false;
    }

    private void setNodeState(InvocationContext ctx, Fqn fqn, NodeSPI n, Map nodeData) throws Exception {
        if (this.trace) {
            this.log.trace("setNodeState node is " + n);
        }
        if (nodeData != null) {
            Map internalState;
            this.notifier.notifyNodeLoaded(fqn, true, Collections.emptyMap(), ctx);
            if (this.isActivation) {
                this.notifier.notifyNodeActivated(fqn, true, Collections.emptyMap(), ctx);
            }
            if ((internalState = n.getInternalState(false)) != null && !internalState.isEmpty()) {
                nodeData = new HashMap(nodeData);
                nodeData.putAll(internalState);
            }
            n.setInternalState(nodeData);
            n.setValid(true, false);
            this.notifier.notifyNodeLoaded(fqn, false, nodeData, ctx);
            if (this.isActivation) {
                this.notifier.notifyNodeActivated(fqn, false, nodeData, ctx);
            }
        }
        if (!n.isDataLoaded()) {
            if (this.trace) {
                this.log.trace("Setting dataLoaded to true");
            }
            n.setDataLoaded(true);
        }
    }

    private Map loadData(InvocationContext ctx, Fqn fqn) throws Exception {
        Map<Object, Object> nodeData;
        boolean nodeExists;
        if (this.trace) {
            this.log.trace("Attempting to load data for " + fqn);
        }
        boolean bl = nodeExists = (nodeData = this.loader.get(fqn)) != null;
        if (this.trace) {
            this.log.trace("Node " + fqn + " exists? " + nodeExists);
        }
        if (nodeExists) {
            this.recordNodeLoaded(ctx, fqn);
        }
        if (this.getStatisticsEnabled()) {
            if (nodeExists) {
                ++this.cacheLoads;
            } else {
                ++this.cacheMisses;
            }
        }
        return nodeData;
    }

    @ManagedAttribute(description="number of cache loader node loads")
    public long getCacheLoaderLoads() {
        return this.cacheLoads;
    }

    @ManagedAttribute(description="number of cache loader node misses")
    public long getCacheLoaderMisses() {
        return this.cacheMisses;
    }

    @Override
    @ManagedOperation
    public void resetStatistics() {
        this.cacheLoads = 0L;
        this.cacheMisses = 0L;
    }

    @Override
    @ManagedOperation
    public Map<String, Object> dumpStatistics() {
        HashMap<String, Object> retval = new HashMap<String, Object>();
        retval.put("CacheLoaderLoads", this.cacheLoads);
        retval.put("CacheLoaderMisses", this.cacheMisses);
        return retval;
    }

    protected void recordNodeLoaded(InvocationContext ctx, Fqn fqn) {
    }
}

