/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import javax.transaction.Transaction;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.commands.ReplicableCommand;
import org.jboss.cache.commands.VisitableCommand;
import org.jboss.cache.commands.WriteCommand;
import org.jboss.cache.commands.tx.CommitCommand;
import org.jboss.cache.commands.tx.OptimisticPrepareCommand;
import org.jboss.cache.commands.tx.PrepareCommand;
import org.jboss.cache.commands.tx.RollbackCommand;
import org.jboss.cache.commands.write.ClearDataCommand;
import org.jboss.cache.commands.write.MoveCommand;
import org.jboss.cache.commands.write.PutDataMapCommand;
import org.jboss.cache.commands.write.PutForExternalReadCommand;
import org.jboss.cache.commands.write.PutKeyValueCommand;
import org.jboss.cache.commands.write.RemoveKeyCommand;
import org.jboss.cache.commands.write.RemoveNodeCommand;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.annotations.Start;
import org.jboss.cache.interceptors.base.CommandInterceptor;
import org.jboss.cache.transaction.GlobalTransaction;

public class CallInterceptor
extends CommandInterceptor {
    private boolean notOptimisticLocking;

    @Start
    protected void start() {
        this.notOptimisticLocking = this.configuration.getNodeLockingScheme() != Configuration.NodeLockingScheme.OPTIMISTIC;
    }

    public Object visitPrepareCommand(InvocationContext ctx, PrepareCommand command) throws Throwable {
        if (this.trace) {
            this.log.trace("Suppressing invocation of method handlePrepareCommand.");
        }
        return null;
    }

    public Object visitOptimisticPrepareCommand(InvocationContext ctx, OptimisticPrepareCommand command) throws Throwable {
        if (this.trace) {
            this.log.trace("Suppressing invocation of method handleOptimisticPrepareCommand.");
        }
        return null;
    }

    public Object visitCommitCommand(InvocationContext ctx, CommitCommand command) throws Throwable {
        if (this.trace) {
            this.log.trace("Suppressing invocation of method handleCommitCommand.");
        }
        return null;
    }

    public Object visitRollbackCommand(InvocationContext ctx, RollbackCommand command) throws Throwable {
        if (this.trace) {
            this.log.trace("Suppressing invocation of method handleRollbackCommand.");
        }
        return null;
    }

    public Object handleDefault(InvocationContext ctx, VisitableCommand command) throws Throwable {
        if (this.trace) {
            this.log.trace("Executing command: " + command + ".");
        }
        return this.invokeCommand(ctx, command);
    }

    private Object invokeCommand(InvocationContext ctx, ReplicableCommand command) throws Throwable {
        Object retval;
        try {
            retval = command.perform(ctx);
        }
        catch (Throwable t) {
            Transaction tx = ctx.getTransaction();
            if (ctx.isValidTransaction()) {
                tx.setRollbackOnly();
            }
            throw t;
        }
        return retval;
    }

    public Object visitPutDataMapCommand(InvocationContext ctx, PutDataMapCommand command) throws Throwable {
        return this.handleAlterCacheMethod(ctx, command);
    }

    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        return this.handleAlterCacheMethod(ctx, command);
    }

    public Object visitPutForExternalReadCommand(InvocationContext ctx, PutForExternalReadCommand command) throws Throwable {
        return this.handleAlterCacheMethod(ctx, command);
    }

    public Object visitRemoveNodeCommand(InvocationContext ctx, RemoveNodeCommand command) throws Throwable {
        return this.handleAlterCacheMethod(ctx, command);
    }

    public Object visitClearDataCommand(InvocationContext ctx, ClearDataCommand command) throws Throwable {
        return this.handleAlterCacheMethod(ctx, command);
    }

    public Object visitRemoveKeyCommand(InvocationContext ctx, RemoveKeyCommand command) throws Throwable {
        return this.handleAlterCacheMethod(ctx, command);
    }

    public Object visitMoveCommand(InvocationContext ctx, MoveCommand command) throws Throwable {
        return this.handleAlterCacheMethod(ctx, command);
    }

    private Object handleAlterCacheMethod(InvocationContext ctx, WriteCommand command) throws Throwable {
        Object result = this.invokeCommand(ctx, command);
        if (this.notOptimisticLocking && ctx.isValidTransaction()) {
            GlobalTransaction gtx = ctx.getGlobalTransaction();
            if (gtx == null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("didn't find GlobalTransaction for " + ctx.getTransaction() + "; won't add modification to transaction list");
                }
            } else {
                ctx.getTransactionContext().addModification(command);
            }
        }
        return result;
    }
}

