/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.RPCManager;
import org.jboss.cache.commands.VisitableCommand;
import org.jboss.cache.commands.read.ExistsCommand;
import org.jboss.cache.commands.tx.CommitCommand;
import org.jboss.cache.commands.tx.OptimisticPrepareCommand;
import org.jboss.cache.commands.tx.PrepareCommand;
import org.jboss.cache.commands.tx.RollbackCommand;
import org.jboss.cache.commands.write.ClearDataCommand;
import org.jboss.cache.commands.write.PutDataMapCommand;
import org.jboss.cache.commands.write.PutForExternalReadCommand;
import org.jboss.cache.commands.write.PutKeyValueCommand;
import org.jboss.cache.commands.write.RemoveKeyCommand;
import org.jboss.cache.commands.write.RemoveNodeCommand;
import org.jboss.cache.config.Option;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.interceptors.BaseTransactionalContextInterceptor;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.TransactionTable;

public class InvocationContextInterceptor
extends BaseTransactionalContextInterceptor {
    private RPCManager rpcManager;

    @Inject
    public void setDependencies(RPCManager rpcManager) {
        this.rpcManager = rpcManager;
    }

    public Object visitPutDataMapCommand(InvocationContext ctx, PutDataMapCommand command) throws Throwable {
        return this.handleAll(ctx, command, command.getGlobalTransaction(), false);
    }

    public Object visitExistsNodeCommand(InvocationContext ctx, ExistsCommand command) throws Throwable {
        return this.handleAll(ctx, command, null, false);
    }

    public Object visitPutForExternalReadCommand(InvocationContext ctx, PutForExternalReadCommand command) throws Throwable {
        return this.handleAll(ctx, command, command.getGlobalTransaction(), false);
    }

    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        return this.handleAll(ctx, command, command.getGlobalTransaction(), false);
    }

    public Object visitRemoveNodeCommand(InvocationContext ctx, RemoveNodeCommand command) throws Throwable {
        return this.handleAll(ctx, command, command.getGlobalTransaction(), false);
    }

    public Object visitClearDataCommand(InvocationContext ctx, ClearDataCommand command) throws Throwable {
        return this.handleAll(ctx, command, command.getGlobalTransaction(), false);
    }

    public Object visitRemoveKeyCommand(InvocationContext ctx, RemoveKeyCommand command) throws Throwable {
        return this.handleAll(ctx, command, command.getGlobalTransaction(), false);
    }

    public Object visitPrepareCommand(InvocationContext ctx, PrepareCommand command) throws Throwable {
        return this.handleAll(ctx, command, command.getGlobalTransaction(), true);
    }

    public Object visitRollbackCommand(InvocationContext ctx, RollbackCommand command) throws Throwable {
        return this.handleAll(ctx, command, command.getGlobalTransaction(), true);
    }

    public Object visitCommitCommand(InvocationContext ctx, CommitCommand command) throws Throwable {
        return this.handleAll(ctx, command, command.getGlobalTransaction(), true);
    }

    public Object visitOptimisticPrepareCommand(InvocationContext ctx, OptimisticPrepareCommand command) throws Throwable {
        return this.handleAll(ctx, command, command.getGlobalTransaction(), true);
    }

    public Object handleDefault(InvocationContext ctx, VisitableCommand command) throws Throwable {
        return this.handleAll(ctx, command, null, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object handleAll(InvocationContext ctx, VisitableCommand command, GlobalTransaction gtx, boolean scrubContextOnCompletion) throws Throwable {
        Object realGtx;
        boolean resumeSuspended;
        Transaction suspendedTransaction;
        block29: {
            Option optionOverride = ctx.getOptionOverrides();
            boolean suppressExceptions = false;
            suspendedTransaction = null;
            resumeSuspended = false;
            if (this.trace) {
                this.log.trace("Invoked with command " + command + " and InvocationContext [" + ctx + "]");
            }
            try {
                if (this.txManager != null) {
                    Transaction tx = this.getTransaction();
                    realGtx = this.getGlobalTransaction(tx, gtx);
                    if (tx == null && realGtx != null && ((GlobalTransaction)realGtx).isRemote()) {
                        tx = this.txTable.getLocalTransaction(gtx);
                    }
                    this.setTransactionalContext(tx, (GlobalTransaction)realGtx, null, ctx);
                } else {
                    this.setTransactionalContext(null, null, null, ctx);
                }
                if (optionOverride != null && optionOverride.isFailSilently()) {
                    this.log.debug("FAIL_SILENTLY Option is present - suspending any ongoing transaction.");
                    suppressExceptions = true;
                    if (ctx.getTransaction() != null) {
                        suspendedTransaction = this.txManager.suspend();
                        this.setTransactionalContext(null, null, null, ctx);
                        if (this.trace) {
                            this.log.trace("Suspending transaction " + suspendedTransaction);
                        }
                        resumeSuspended = true;
                    } else if (this.trace) {
                        this.log.trace("No ongoing transaction to suspend");
                    }
                }
                try {
                    realGtx = this.invokeNextInterceptor(ctx, command);
                }
                catch (Throwable th) {
                    Throwable retval = th;
                    if (!suppressExceptions) {
                        Throwable t = retval;
                        if (!(t instanceof RuntimeException)) throw t;
                        if (t.getCause() == null) throw t;
                        throw t.getCause();
                    }
                    Object var11_15 = null;
                    Object var13_13 = null;
                    if (scrubContextOnCompletion) {
                        this.setTransactionalContext(null, null, null, ctx);
                    }
                    if (this.trace) {
                        this.log.trace("Resetting invocation-scope options");
                    }
                    ctx.getOptionOverrides().reset();
                    ctx.setFqnsLoaded(null);
                    if (resumeSuspended) {
                        this.txManager.resume(suspendedTransaction);
                    } else if (ctx.getTransaction() != null && TransactionTable.isValid(ctx.getTransaction())) {
                        this.copyInvocationScopeOptionsToTxScope(ctx);
                    }
                    ctx.setCommand(null);
                    ctx.setMethodCall(null);
                    ctx.clearLookedUpNodes();
                    return var11_15;
                }
                Object var13_12 = null;
                if (!scrubContextOnCompletion) break block29;
            }
            catch (Throwable throwable) {
                Object var13_14 = null;
                if (scrubContextOnCompletion) {
                    this.setTransactionalContext(null, null, null, ctx);
                }
                if (this.trace) {
                    this.log.trace("Resetting invocation-scope options");
                }
                ctx.getOptionOverrides().reset();
                ctx.setFqnsLoaded(null);
                if (resumeSuspended) {
                    this.txManager.resume(suspendedTransaction);
                } else if (ctx.getTransaction() != null && TransactionTable.isValid(ctx.getTransaction())) {
                    this.copyInvocationScopeOptionsToTxScope(ctx);
                }
                ctx.setCommand(null);
                ctx.setMethodCall(null);
                ctx.clearLookedUpNodes();
                throw throwable;
            }
            this.setTransactionalContext(null, null, null, ctx);
        }
        if (this.trace) {
            this.log.trace("Resetting invocation-scope options");
        }
        ctx.getOptionOverrides().reset();
        ctx.setFqnsLoaded(null);
        if (resumeSuspended) {
            this.txManager.resume(suspendedTransaction);
        } else if (ctx.getTransaction() != null && TransactionTable.isValid(ctx.getTransaction())) {
            this.copyInvocationScopeOptionsToTxScope(ctx);
        }
        ctx.setCommand(null);
        ctx.setMethodCall(null);
        ctx.clearLookedUpNodes();
        return realGtx;
    }

    private GlobalTransaction getGlobalTransaction(Transaction tx, GlobalTransaction gtx) {
        if (gtx == null) {
            gtx = this.txTable.getCurrentTransaction(tx, false);
        }
        if (gtx != null) {
            gtx.setRemote(this.isRemoteGlobalTx(gtx));
        }
        return gtx;
    }

    private Transaction getTransaction() throws SystemException {
        if (this.txManager == null) {
            if (this.trace) {
                this.log.trace("no transaction manager configured, setting tx as null.");
            }
            return null;
        }
        return this.txManager.getTransaction();
    }

    private boolean isRemoteGlobalTx(GlobalTransaction gtx) {
        return gtx != null && gtx.getAddress() != null && !gtx.getAddress().equals(this.rpcManager.getLocalAddress());
    }
}

