/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.remoting.jgroups;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.factories.annotations.NonVolatile;
import org.jboss.cache.io.ExposedByteArrayOutputStream;
import org.jboss.cache.statetransfer.StateTransferManager;
import org.jboss.util.stream.MarshalledValueInputStream;
import org.jboss.util.stream.MarshalledValueOutputStream;
import org.jgroups.ExtendedMessageListener;
import org.jgroups.Message;
import org.jgroups.util.Util;

@NonVolatile
public class ChannelMessageListener
implements ExtendedMessageListener {
    protected volatile Exception setStateException;
    private final Object stateLock = new Object();
    private static final Log log = LogFactory.getLog(ChannelMessageListener.class);
    private static final boolean trace = log.isTraceEnabled();
    private StateTransferManager stateTransferManager;
    private Configuration configuration;
    private volatile boolean isStateSet = false;

    @Inject
    void injectDependencies(StateTransferManager stateTransferManager, Configuration configuration) {
        this.stateTransferManager = stateTransferManager;
        this.configuration = configuration;
    }

    public boolean isStateSet() {
        return this.isStateSet;
    }

    public void setStateSet(boolean stateSet) {
        this.isStateSet = stateSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForState() throws Exception {
        Object object = this.stateLock;
        synchronized (object) {
            while (!this.isStateSet) {
                if (this.setStateException != null) {
                    throw this.setStateException;
                }
                try {
                    this.stateLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    protected void stateReceivedSuccess() {
        this.isStateSet = true;
        this.setStateException = null;
    }

    protected void stateReceivingFailed(Throwable t) {
        if (t instanceof CacheException) {
            log.debug("Caught exception integrating state!", t);
        } else {
            log.error("failed setting state", t);
        }
        this.setStateException = t instanceof Exception ? (Exception)t : new Exception(t);
    }

    protected void stateProducingFailed(Throwable t) {
        if (t instanceof CacheException) {
            log.debug("Caught exception generating state!", t);
        } else {
            log.error("Caught " + t.getClass().getName() + " while responding to state transfer request", t);
        }
    }

    public void receive(Message msg) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getState() {
        byte[] result;
        if (log.isTraceEnabled()) {
            log.trace("State retrieval request received");
        }
        MarshalledValueOutputStream out = null;
        ExposedByteArrayOutputStream baos = new ExposedByteArrayOutputStream(16384);
        try {
            out = new MarshalledValueOutputStream(baos);
            this.stateTransferManager.getState(out, Fqn.ROOT, this.configuration.getStateRetrievalTimeout(), true, true);
        }
        catch (Throwable t) {
            this.stateProducingFailed(t);
        }
        finally {
            result = baos.getRawBuffer();
            Util.close(out);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(byte[] new_state) {
        if (new_state == null) {
            log.debug("transferred state is null (may be first member in cluster)");
            return;
        }
        if (trace) {
            log.trace("setState() called with byte array of size " + new_state.length);
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(new_state);
        MarshalledValueInputStream in = null;
        try {
            in = new MarshalledValueInputStream(bais);
            this.stateTransferManager.setState(in, Fqn.ROOT);
            this.stateReceivedSuccess();
        }
        catch (Throwable t) {
            try {
                this.stateReceivingFailed(t);
            }
            catch (Throwable throwable) {
                Util.close(in);
                Object object = this.stateLock;
                synchronized (object) {
                    this.stateLock.notifyAll();
                }
                throw throwable;
            }
            Util.close(in);
            Object object = this.stateLock;
            synchronized (object) {
                this.stateLock.notifyAll();
            }
        }
        Util.close(in);
        Object object = this.stateLock;
        synchronized (object) {
            this.stateLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getState(String state_id) {
        byte[] result;
        boolean hasDifferentSourceAndIntegrationRoots;
        if (trace) {
            log.trace("Getting state for state id " + state_id);
        }
        MarshalledValueOutputStream out = null;
        String sourceRoot = state_id;
        boolean bl = hasDifferentSourceAndIntegrationRoots = state_id.indexOf("_PARTIAL_STATE_DELIMITER") > 0;
        if (hasDifferentSourceAndIntegrationRoots) {
            sourceRoot = state_id.split("_PARTIAL_STATE_DELIMITER")[0];
        }
        ExposedByteArrayOutputStream baos = new ExposedByteArrayOutputStream(16384);
        try {
            out = new MarshalledValueOutputStream(baos);
            this.stateTransferManager.getState(out, Fqn.fromString(sourceRoot), this.configuration.getStateRetrievalTimeout(), true, true);
        }
        catch (Throwable t) {
            this.stateProducingFailed(t);
        }
        finally {
            result = baos.getRawBuffer();
            Util.close(out);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getState(OutputStream ostream) {
        MarshalledValueOutputStream out = null;
        try {
            out = new MarshalledValueOutputStream(ostream);
            this.stateTransferManager.getState(out, Fqn.ROOT, this.configuration.getStateRetrievalTimeout(), true, true);
        }
        catch (Throwable t) {
            try {
                this.stateProducingFailed(t);
            }
            catch (Throwable throwable) {
                Util.close(out);
                throw throwable;
            }
            Util.close(out);
        }
        Util.close(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getState(String state_id, OutputStream ostream) {
        boolean hasDifferentSourceAndIntegrationRoots;
        if (trace) {
            log.trace("Getting state for state id " + state_id);
        }
        String sourceRoot = state_id;
        MarshalledValueOutputStream out = null;
        boolean bl = hasDifferentSourceAndIntegrationRoots = state_id.indexOf("_PARTIAL_STATE_DELIMITER") > 0;
        if (hasDifferentSourceAndIntegrationRoots) {
            sourceRoot = state_id.split("_PARTIAL_STATE_DELIMITER")[0];
        }
        try {
            out = new MarshalledValueOutputStream(ostream);
            this.stateTransferManager.getState(out, Fqn.fromString(sourceRoot), this.configuration.getStateRetrievalTimeout(), true, true);
        }
        catch (Throwable t) {
            try {
                this.stateProducingFailed(t);
            }
            catch (Throwable throwable) {
                Util.close(out);
                throw throwable;
            }
            Util.close(out);
        }
        Util.close(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(InputStream istream) {
        if (istream == null) {
            log.debug("stream is null (may be first member in cluster)");
            return;
        }
        if (trace) {
            log.trace("setState() called with input stream");
        }
        MarshalledValueInputStream in = null;
        try {
            in = new MarshalledValueInputStream(istream);
            this.stateTransferManager.setState(in, Fqn.ROOT);
            this.stateReceivedSuccess();
        }
        catch (Throwable t) {
            try {
                this.stateReceivingFailed(t);
            }
            catch (Throwable throwable) {
                Util.close(in);
                Object object = this.stateLock;
                synchronized (object) {
                    this.stateLock.notifyAll();
                }
                throw throwable;
            }
            Util.close(in);
            Object object = this.stateLock;
            synchronized (object) {
                this.stateLock.notifyAll();
            }
        }
        Util.close(in);
        Object object = this.stateLock;
        synchronized (object) {
            this.stateLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(String state_id, byte[] state) {
        Object subroot;
        boolean hasDifferentSourceAndIntegrationRoots;
        if (state == null) {
            log.debug("partial transferred state for id " + state_id + " is null");
            return;
        }
        if (trace) {
            log.trace("Receiving state byte array of length " + state.length + " for " + state_id);
        }
        MarshalledValueInputStream in = null;
        String targetRoot = state_id;
        boolean bl = hasDifferentSourceAndIntegrationRoots = state_id.indexOf("_PARTIAL_STATE_DELIMITER") > 0;
        if (hasDifferentSourceAndIntegrationRoots) {
            targetRoot = state_id.split("_PARTIAL_STATE_DELIMITER")[1];
        }
        try {
            log.debug("Setting received partial state for subroot " + state_id);
            subroot = Fqn.fromString(targetRoot);
            ByteArrayInputStream bais = new ByteArrayInputStream(state);
            in = new MarshalledValueInputStream(bais);
            this.stateTransferManager.setState(in, (Fqn)subroot);
            this.stateReceivedSuccess();
        }
        catch (Throwable t) {
            try {
                this.stateReceivingFailed(t);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                Util.close(in);
                Object object = this.stateLock;
                synchronized (object) {
                    this.stateLock.notifyAll();
                }
            }
        }
        Util.close(in);
        subroot = this.stateLock;
        synchronized (subroot) {
            this.stateLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(String stateId, InputStream istream) {
        Object subroot;
        boolean hasDifferentSourceAndIntegrationRoots;
        if (trace) {
            log.trace("Receiving state on stream for " + stateId);
        }
        String targetRoot = stateId;
        MarshalledValueInputStream in = null;
        boolean bl = hasDifferentSourceAndIntegrationRoots = stateId.indexOf("_PARTIAL_STATE_DELIMITER") > 0;
        if (hasDifferentSourceAndIntegrationRoots) {
            targetRoot = stateId.split("_PARTIAL_STATE_DELIMITER")[1];
        }
        if (istream == null) {
            log.debug("stream is null (may be first member in cluster). State is not set");
            return;
        }
        try {
            log.debug("Setting received partial state for subroot " + stateId);
            in = new MarshalledValueInputStream(istream);
            subroot = Fqn.fromString(targetRoot);
            this.stateTransferManager.setState(in, (Fqn)subroot);
            this.stateReceivedSuccess();
        }
        catch (Throwable t) {
            try {
                if (log.isTraceEnabled()) {
                    log.trace("Unknown error while integrating state", t);
                }
                this.stateReceivingFailed(t);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                Util.close(in);
                Object object = this.stateLock;
                synchronized (object) {
                    this.stateLock.notifyAll();
                }
            }
        }
        Util.close(in);
        subroot = this.stateLock;
        synchronized (subroot) {
            this.stateLock.notifyAll();
        }
    }
}

